/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim;

public class ShimVersion {
    private static final String DOT = ".";
    private int major;
    private int minor;
    private int micro;
    private String qualifier;

    public ShimVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public ShimVersion(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public ShimVersion(int major, int minor, int micro, String qualifier) {
        if (major < 0 || minor < 0 || micro < 0) {
            throw new IllegalArgumentException("major, minor, and micro version numbers must be >= 0");
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getMicroVersion() {
        return this.micro;
    }

    public String getQualifierVersion() {
        return this.qualifier;
    }

    public String getVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        sb.append(DOT);
        sb.append(this.minor);
        sb.append(DOT);
        sb.append(this.micro);
        if (this.qualifier != null) {
            sb.append(DOT);
            sb.append(this.qualifier);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getVersion();
    }
}

