/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.config;

import java.util.Enumeration;
import java.util.Iterator;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfiguration;

public class ExtendedConfigurationWrapper
implements ExtendedConfiguration {
    private static final long serialVersionUID = -3600564448124904906L;
    private Configuration parent;

    public ExtendedConfigurationWrapper(Configuration parent) {
        if (parent == null) {
            throw new NullPointerException("Parent given must not be null");
        }
        this.parent = parent;
    }

    @Override
    public boolean getBoolProperty(String name) {
        return this.getBoolProperty(name, false);
    }

    @Override
    public boolean getBoolProperty(String name, boolean defaultValue) {
        return "true".equals(this.parent.getConfigProperty(name, String.valueOf(defaultValue)));
    }

    @Override
    public int getIntProperty(String name) {
        return this.getIntProperty(name, 0);
    }

    @Override
    public int getIntProperty(String name, int defaultValue) {
        String retval = this.parent.getConfigProperty(name);
        if (retval == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(retval);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public boolean isPropertySet(String name) {
        return this.parent.getConfigProperty(name) != null;
    }

    @Override
    public Iterator<String> findPropertyKeys(String prefix) {
        return this.parent.findPropertyKeys(prefix);
    }

    @Override
    public String getConfigProperty(String key) {
        return this.parent.getConfigProperty(key);
    }

    @Override
    public String getConfigProperty(String key, String defaultValue) {
        return this.parent.getConfigProperty(key, defaultValue);
    }

    @Override
    public Enumeration<String> getConfigProperties() {
        return this.parent.getConfigProperties();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ExtendedConfigurationWrapper wrapper = (ExtendedConfigurationWrapper)super.clone();
        wrapper.parent = (Configuration)this.parent.clone();
        return this.parent;
    }
}

