/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.mailer.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.extensions.modules.mailer.MailDefinition;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentMetaData;
import org.pentaho.reporting.libraries.repository.ContentIOException;

public class MailDefinitionBundleWriter {
    public void writeMailDefinition(WriteableDocumentBundle documentBundle, MailDefinition report, DocumentBundle globalBundle) {
        if (documentBundle == null) {
            throw new NullPointerException();
        }
        if (report == null) {
            throw new NullPointerException();
        }
        if (globalBundle == null) {
            throw new NullPointerException();
        }
        WriteableDocumentMetaData data = documentBundle.getWriteableDocumentMetaData();
        data.setBundleType("application/vnd.pentaho.reporting.mailer-definition");
    }

    public static void writeReportToZipFile(MailDefinition report, File file) throws IOException, BundleWriterException, ContentIOException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (file == null) {
            throw new NullPointerException();
        }
        MemoryDocumentBundle documentBundle = new MemoryDocumentBundle();
        MailDefinitionBundleWriter writer = new MailDefinitionBundleWriter();
        writer.writeMailDefinition((WriteableDocumentBundle)documentBundle, report, null);
        BundleUtilities.writeAsZip((File)file, (DocumentBundle)documentBundle);
    }

    public static void writeReportToZipStream(MailDefinition report, OutputStream out) throws IOException, BundleWriterException, ContentIOException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (out == null) {
            throw new NullPointerException();
        }
        MemoryDocumentBundle documentBundle = new MemoryDocumentBundle();
        MailDefinitionBundleWriter writer = new MailDefinitionBundleWriter();
        writer.writeMailDefinition((WriteableDocumentBundle)documentBundle, report, null);
        BundleUtilities.writeAsZip((OutputStream)out, (DocumentBundle)documentBundle);
    }

    public static void writeReportToDirectory(MailDefinition report, File file) throws IOException, BundleWriterException, ContentIOException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (file == null) {
            throw new NullPointerException();
        }
        MemoryDocumentBundle documentBundle = new MemoryDocumentBundle();
        MailDefinitionBundleWriter writer = new MailDefinitionBundleWriter();
        writer.writeMailDefinition((WriteableDocumentBundle)documentBundle, report, null);
        BundleUtilities.writeToDirectory((File)file, (DocumentBundle)documentBundle);
    }
}

