/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.SqlDataSource;
import org.pentaho.metadata.model.SqlPhysicalColumn;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.security.RowLevelSecurity;
import org.pentaho.metadata.model.concept.security.Security;
import org.pentaho.metadata.model.concept.security.SecurityOwner;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.Alignment;
import org.pentaho.metadata.model.concept.types.Color;
import org.pentaho.metadata.model.concept.types.ColumnWidth;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.FieldType;
import org.pentaho.metadata.model.concept.types.Font;
import org.pentaho.metadata.model.concept.types.LocaleType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.concept.types.RelationshipType;
import org.pentaho.metadata.model.concept.types.TableType;
import org.pentaho.metadata.model.concept.types.TargetColumnType;
import org.pentaho.metadata.model.concept.types.TargetTableType;
import org.pentaho.metadata.query.model.Constraint;
import org.pentaho.metadata.query.model.Order;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.pms.locale.LocaleInterface;
import org.pentaho.pms.locale.LocaleMeta;
import org.pentaho.pms.mql.MQLQueryImpl;
import org.pentaho.pms.schema.BusinessCategory;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.PhysicalColumn;
import org.pentaho.pms.schema.PhysicalTable;
import org.pentaho.pms.schema.RelationshipMeta;
import org.pentaho.pms.schema.SchemaMeta;
import org.pentaho.pms.schema.concept.ConceptPropertyInterface;
import org.pentaho.pms.schema.concept.ConceptUtilityInterface;
import org.pentaho.pms.schema.concept.types.aggregation.AggregationSettings;
import org.pentaho.pms.schema.concept.types.aggregation.ConceptPropertyAggregation;
import org.pentaho.pms.schema.concept.types.aggregation.ConceptPropertyAggregationList;
import org.pentaho.pms.schema.concept.types.alignment.AlignmentSettings;
import org.pentaho.pms.schema.concept.types.alignment.ConceptPropertyAlignment;
import org.pentaho.pms.schema.concept.types.bool.ConceptPropertyBoolean;
import org.pentaho.pms.schema.concept.types.color.ColorSettings;
import org.pentaho.pms.schema.concept.types.color.ConceptPropertyColor;
import org.pentaho.pms.schema.concept.types.columnwidth.ColumnWidth;
import org.pentaho.pms.schema.concept.types.columnwidth.ConceptPropertyColumnWidth;
import org.pentaho.pms.schema.concept.types.datatype.ConceptPropertyDataType;
import org.pentaho.pms.schema.concept.types.datatype.DataTypeSettings;
import org.pentaho.pms.schema.concept.types.date.ConceptPropertyDate;
import org.pentaho.pms.schema.concept.types.fieldtype.ConceptPropertyFieldType;
import org.pentaho.pms.schema.concept.types.fieldtype.FieldTypeSettings;
import org.pentaho.pms.schema.concept.types.font.ConceptPropertyFont;
import org.pentaho.pms.schema.concept.types.font.FontSettings;
import org.pentaho.pms.schema.concept.types.localstring.ConceptPropertyLocalizedString;
import org.pentaho.pms.schema.concept.types.localstring.LocalizedStringSettings;
import org.pentaho.pms.schema.concept.types.number.ConceptPropertyNumber;
import org.pentaho.pms.schema.concept.types.rowlevelsecurity.ConceptPropertyRowLevelSecurity;
import org.pentaho.pms.schema.concept.types.security.ConceptPropertySecurity;
import org.pentaho.pms.schema.concept.types.string.ConceptPropertyString;
import org.pentaho.pms.schema.concept.types.tabletype.ConceptPropertyTableType;
import org.pentaho.pms.schema.concept.types.tabletype.TableTypeSettings;
import org.pentaho.pms.schema.concept.types.url.ConceptPropertyURL;
import org.pentaho.pms.util.ObjectAlreadyExistsException;

public class ThinModelConverter {
    private static final Log logger = LogFactory.getLog(ThinModelConverter.class);

    public static DatabaseMeta convertToLegacy(String name, SqlDataSource datasource) {
        try {
            KettleEnvironment.init((boolean)false);
        }
        catch (KettleException e) {
            logger.error((Object)"Error initializing the Kettle Environment", (Throwable)e);
            throw new RuntimeException("Error initializing the Kettle Environment", e);
        }
        DatabaseMeta databaseMeta = new DatabaseMeta();
        databaseMeta.setName(name);
        databaseMeta.setHostname(datasource.getHostname());
        if (datasource.getDialectType() == null) {
            databaseMeta.setDatabaseType("GENERIC");
        } else {
            databaseMeta.setDatabaseType(datasource.getDialectType());
        }
        databaseMeta.setAccessType(DatabaseMeta.getAccessType((String)datasource.getType().toString()));
        databaseMeta.setDBName(datasource.getDatabaseName());
        databaseMeta.setDBPort(datasource.getPort());
        databaseMeta.setUsername(datasource.getUsername());
        databaseMeta.setPassword(datasource.getPassword());
        databaseMeta.setServername(datasource.getServername());
        for (String key : datasource.getAttributes().keySet()) {
            databaseMeta.getAttributes().put(key, datasource.getAttributes().get(key));
        }
        return databaseMeta;
    }

    public static SchemaMeta convertToLegacy(Domain domain) throws ObjectAlreadyExistsException {
        SchemaMeta schemaMeta = new SchemaMeta();
        schemaMeta.setDomainName(domain.getId());
        if (domain.getLocales() != null) {
            int order = 0;
            for (LocaleType localeType : domain.getLocales()) {
                boolean found = false;
                for (String code : schemaMeta.getLocales().getLocaleCodes()) {
                    if (!code.equals(localeType.getCode())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Iterator<LogicalTable> localeInterface = new LocaleMeta();
                localeInterface.setCode(localeType.getCode());
                localeInterface.setDescription(localeType.getDescription());
                localeInterface.setOrder(order++);
                localeInterface.setActive(true);
                schemaMeta.getLocales().addLocale((LocaleInterface)((Object)localeInterface));
            }
        }
        DatabaseMeta database = null;
        for (IPhysicalModel physicalModel : domain.getPhysicalModels()) {
            if (physicalModel instanceof SqlPhysicalModel) {
                SqlPhysicalModel sqlModel = (SqlPhysicalModel)physicalModel;
                if (sqlModel.getDatasource().getType() == SqlDataSource.DataSourceType.JNDI) {
                    database = new DatabaseMeta(((SqlPhysicalModel)physicalModel).getDatasource().getDatabaseName(), "MYSQL", "JNDI", "", "", "", "", "");
                    database.getDatabaseInterface().setDatabaseName(((SqlPhysicalModel)physicalModel).getDatasource().getDatabaseName());
                }
                schemaMeta.addDatabase(database);
                for (IPhysicalTable iPhysicalTable : sqlModel.getPhysicalTables()) {
                    SqlPhysicalTable sqlTable = (SqlPhysicalTable)iPhysicalTable;
                    PhysicalTable physicalTable = new PhysicalTable();
                    physicalTable.setDatabaseMeta(database);
                    ThinModelConverter.convertConceptToLegacy(iPhysicalTable, physicalTable);
                    for (IPhysicalColumn col : sqlTable.getPhysicalColumns()) {
                        PhysicalColumn column = new PhysicalColumn();
                        column.setTable(physicalTable);
                        ThinModelConverter.convertConceptToLegacy(col, column);
                        physicalTable.addPhysicalColumn(column);
                    }
                    schemaMeta.addTable(physicalTable);
                }
                continue;
            }
            logger.error((Object)("physical model not supported " + physicalModel.getClass()));
        }
        for (LogicalModel logicalModel : domain.getLogicalModels()) {
            BusinessColumn col;
            BusinessModel model = new BusinessModel();
            model.setConnection(database);
            ThinModelConverter.convertConceptToLegacy(logicalModel, model);
            for (LogicalTable logicalTable : logicalModel.getLogicalTables()) {
                BusinessTable biztable = new BusinessTable();
                PhysicalTable pt = schemaMeta.findPhysicalTable(logicalTable.getPhysicalTable().getId());
                ThinModelConverter.convertConceptToLegacy(logicalTable, biztable);
                biztable.setPhysicalTable(pt);
                for (LogicalColumn column : logicalTable.getLogicalColumns()) {
                    col = new BusinessColumn();
                    ThinModelConverter.convertConceptToLegacy(column, col);
                    col.setBusinessTable(biztable);
                    PhysicalColumn physicalColumn = schemaMeta.findPhysicalColumn(column.getPhysicalColumn().getPhysicalTable().getId(), column.getPhysicalColumn().getId());
                    col.setPhysicalColumn(physicalColumn);
                    col.getConcept().setSecurityParentInterface(biztable.getConcept());
                    biztable.addBusinessColumn(col);
                }
                model.addBusinessTable(biztable);
            }
            BusinessCategory root = new BusinessCategory();
            root.setRootCategory(true);
            model.setRootCategory(root);
            for (Category category : logicalModel.getCategories()) {
                BusinessCategory cat = new BusinessCategory();
                ThinModelConverter.convertConceptToLegacy(category, cat);
                for (LogicalColumn column : category.getLogicalColumns()) {
                    col = model.findBusinessColumn(column.getId());
                    cat.addBusinessColumn(col);
                }
                root.addBusinessCategory(cat);
            }
            schemaMeta.addModel(model);
        }
        return schemaMeta;
    }

    private static void convertConceptToLegacy(IConcept concept, ConceptUtilityInterface legacy) throws ObjectAlreadyExistsException {
        legacy.setId(concept.getId());
        for (String propertyName : concept.getChildProperties().keySet()) {
            Object property;
            ConceptPropertyInterface prop = ThinModelConverter.convertPropertyToLegacy(propertyName, property = concept.getChildProperty(propertyName));
            if (prop == null) continue;
            legacy.getConcept().addProperty(prop);
        }
    }

    public static ConceptPropertyInterface convertPropertyToLegacy(String propertyName, Object property) {
        if (property instanceof String) {
            if (propertyName.equals("target_column")) {
                propertyName = "formula";
            }
            ConceptPropertyString string = new ConceptPropertyString(propertyName, (String)property);
            return string;
        }
        if (property instanceof LocalizedString) {
            LocalizedString str = (LocalizedString)property;
            LocalizedStringSettings value = new LocalizedStringSettings(str.getLocaleStringMap());
            ConceptPropertyLocalizedString string = new ConceptPropertyLocalizedString(propertyName, value);
            return string;
        }
        if (property instanceof DataType) {
            DataType dt = (DataType)((Object)property);
            DataTypeSettings datatypeSettings = DataTypeSettings.types[dt.ordinal()];
            ConceptPropertyDataType cpdt = new ConceptPropertyDataType(propertyName, datatypeSettings);
            return cpdt;
        }
        if (property instanceof AggregationType) {
            AggregationSettings aggSettings = ThinModelConverter.convertToLegacy((AggregationType)((Object)property));
            ConceptPropertyAggregation agg = new ConceptPropertyAggregation(propertyName, aggSettings);
            return agg;
        }
        if (property instanceof TargetTableType) {
            return null;
        }
        if (property instanceof TargetColumnType) {
            TargetColumnType colType = (TargetColumnType)((Object)property);
            if (propertyName.equals("target_column_type")) {
                propertyName = "exact";
            }
            ConceptPropertyBoolean bool = new ConceptPropertyBoolean(propertyName, colType == TargetColumnType.OPEN_FORMULA);
            return bool;
        }
        if (property instanceof Font) {
            Font font = (Font)property;
            FontSettings value = new FontSettings(font.getName(), font.getHeight(), font.isBold(), font.isItalic());
            ConceptPropertyFont fontprop = new ConceptPropertyFont(propertyName, value);
            return fontprop;
        }
        if (property instanceof TableType) {
            TableType tt = (TableType)((Object)property);
            ConceptPropertyTableType tbltype = new ConceptPropertyTableType(propertyName, TableTypeSettings.types[tt.ordinal()]);
            return tbltype;
        }
        if (property instanceof List) {
            List list = (List)property;
            if (propertyName.equals("aggregation_list")) {
                ArrayList<AggregationSettings> listaggs = new ArrayList<AggregationSettings>();
                ConceptPropertyAggregationList agglist = new ConceptPropertyAggregationList(propertyName, listaggs);
                for (Object obj : list) {
                    AggregationType aggType = (AggregationType)((Object)obj);
                    listaggs.add(AggregationSettings.types[aggType.ordinal()]);
                }
                return agglist;
            }
        }
        logger.error((Object)("unsupported property: " + property));
        return null;
    }

    public static MQLQueryImpl convertToLegacy(Query query, DatabaseMeta databaseMeta) throws Exception {
        SchemaMeta meta = ThinModelConverter.convertToLegacy(query.getDomain());
        BusinessModel model = meta.findModel(query.getLogicalModel().getId());
        if (databaseMeta == null) {
            databaseMeta = meta.getDatabase(0);
        }
        MQLQueryImpl impl = new MQLQueryImpl(meta, model, databaseMeta, null);
        impl.setDisableDistinct(query.getDisableDistinct());
        impl.setLimit(query.getLimit());
        for (Selection sel : query.getSelections()) {
            BusinessColumn column = model.findBusinessColumn(sel.getLogicalColumn().getId());
            org.pentaho.pms.mql.Selection legSel = new org.pentaho.pms.mql.Selection(column, ThinModelConverter.convertToLegacy(sel.getAggregationType()));
            impl.addSelection(legSel);
        }
        for (Constraint constr : query.getConstraints()) {
            impl.addConstraint(constr.getCombinationType().toString(), constr.getFormula());
        }
        for (Order order : query.getOrders()) {
            AggregationSettings aggregation = ThinModelConverter.convertToLegacy(order.getSelection().getAggregationType());
            String aggStr = null;
            if (aggregation != null) {
                aggStr = aggregation.getCode();
            }
            impl.addOrderBy(order.getSelection().getCategory().getId(), order.getSelection().getLogicalColumn().getId(), aggStr, order.getType() == Order.Type.ASC);
        }
        return impl;
    }

    public static AggregationSettings convertToLegacy(AggregationType aggType) {
        if (aggType == null) {
            return null;
        }
        return AggregationSettings.types[aggType.ordinal()];
    }

    public static void convertConceptFromLegacy(ConceptUtilityInterface legacy, IConcept concept) {
        concept.setId(legacy.getId());
        for (String propertyName : legacy.getConcept().getChildPropertyIDs()) {
            ConceptPropertyInterface property = legacy.getConcept().getChildProperty(propertyName);
            Object prop = ThinModelConverter.convertPropertyFromLegacy(propertyName, property);
            String newPropertyName = ThinModelConverter.convertPropertyNameFromLegacy(propertyName);
            if (prop == null) continue;
            concept.setProperty(newPropertyName, prop);
        }
    }

    private static String convertPropertyNameFromLegacy(String propertyName) {
        if ("formula".equals(propertyName)) {
            return "target_column";
        }
        if ("exact".equals(propertyName)) {
            return "target_column_type";
        }
        return propertyName;
    }

    private static Object convertPropertyFromLegacy(String propertyName, ConceptPropertyInterface property) {
        if (property instanceof ConceptPropertyString) {
            return (String)property.getValue();
        }
        if (property instanceof ConceptPropertyLocalizedString) {
            LocalizedStringSettings settings = (LocalizedStringSettings)property.getValue();
            return new LocalizedString(settings.getLocaleStringMap());
        }
        if (property instanceof ConceptPropertyDataType) {
            DataTypeSettings settings = (DataTypeSettings)property.getValue();
            if (settings == null) {
                return null;
            }
            return DataType.values()[settings.getType()];
        }
        if (property instanceof ConceptPropertyAggregationList) {
            List orig = (List)property.getValue();
            ArrayList<AggregationType> list = new ArrayList<AggregationType>();
            for (AggregationSettings setting : orig) {
                list.add(AggregationType.values()[setting.getType()]);
            }
            return list;
        }
        if (property instanceof ConceptPropertyAggregation) {
            AggregationSettings aggSettings = (AggregationSettings)property.getValue();
            return AggregationType.values()[aggSettings.getType()];
        }
        if (property instanceof ConceptPropertyBoolean) {
            Boolean boolVal = (Boolean)property.getValue();
            if (propertyName.equals("exact")) {
                if (boolVal.booleanValue()) {
                    return TargetColumnType.OPEN_FORMULA;
                }
                return TargetColumnType.COLUMN_NAME;
            }
            return boolVal;
        }
        if (property instanceof ConceptPropertySecurity) {
            org.pentaho.pms.schema.security.Security security = (org.pentaho.pms.schema.security.Security)property.getValue();
            HashMap<SecurityOwner, Integer> map = new HashMap<SecurityOwner, Integer>();
            for (org.pentaho.pms.schema.security.SecurityOwner owner : security.getOwners()) {
                SecurityOwner ownerObj = new SecurityOwner(SecurityOwner.OwnerType.values()[owner.getOwnerType()], owner.getOwnerName());
                Integer val = security.getOwnerRights(owner);
                map.put(ownerObj, val);
            }
            return new Security(map);
        }
        if (property instanceof ConceptPropertyRowLevelSecurity) {
            org.pentaho.pms.schema.security.RowLevelSecurity security = (org.pentaho.pms.schema.security.RowLevelSecurity)property.getValue();
            RowLevelSecurity securityObj = new RowLevelSecurity();
            securityObj.setType(RowLevelSecurity.Type.values()[security.getType().ordinal()]);
            securityObj.setGlobalConstraint(security.getGlobalConstraint());
            HashMap<SecurityOwner, String> map = new HashMap<SecurityOwner, String>();
            for (org.pentaho.pms.schema.security.SecurityOwner owner : security.getRoleBasedConstraintMap().keySet()) {
                SecurityOwner ownerObj = new SecurityOwner(SecurityOwner.OwnerType.values()[owner.getOwnerType()], owner.getOwnerName());
                map.put(ownerObj, security.getRoleBasedConstraintMap().get(owner));
            }
            securityObj.setRoleBasedConstraintMap(map);
            return securityObj;
        }
        if (property instanceof ConceptPropertyAlignment) {
            AlignmentSettings alignment = (AlignmentSettings)property.getValue();
            return Alignment.values()[alignment.getType()];
        }
        if (property instanceof ConceptPropertyColor) {
            ColorSettings color = (ColorSettings)property.getValue();
            return new Color(color.getRed(), color.getGreen(), color.getBlue());
        }
        if (property instanceof ConceptPropertyColumnWidth) {
            ColumnWidth colWidth = (ColumnWidth)property.getValue();
            return new org.pentaho.metadata.model.concept.types.ColumnWidth(ColumnWidth.WidthType.values()[colWidth.getType()], colWidth.getWidth().doubleValue());
        }
        if (property instanceof ConceptPropertyDate) {
            return property.getValue();
        }
        if (property instanceof ConceptPropertyURL) {
            return property.getValue();
        }
        if (property instanceof ConceptPropertyFieldType) {
            FieldTypeSettings fieldType = (FieldTypeSettings)property.getValue();
            return FieldType.values()[fieldType.getType()];
        }
        if (property instanceof ConceptPropertyTableType) {
            TableTypeSettings tableType = (TableTypeSettings)property.getValue();
            return TableType.values()[tableType.getType()];
        }
        if (property instanceof ConceptPropertyFont) {
            FontSettings font = (FontSettings)property.getValue();
            return new Font(font.getName(), font.getHeight(), font.isBold(), font.isItalic());
        }
        if (property instanceof ConceptPropertyNumber) {
            if (property.getValue() != null) {
                return ((BigDecimal)property.getValue()).doubleValue();
            }
            return null;
        }
        logger.error((Object)("unsupported property: " + property));
        return null;
    }

    public static SqlDataSource convertFromLegacy(DatabaseMeta database) {
        SqlDataSource dataSource = new SqlDataSource();
        dataSource.setDialectType(database.getDatabaseTypeDesc());
        dataSource.setDatabaseName(database.environmentSubstitute(database.getDatabaseName()));
        dataSource.setHostname(database.environmentSubstitute(database.getHostname()));
        dataSource.setPort(database.environmentSubstitute(database.getDatabasePortNumberString()));
        dataSource.setUsername(database.environmentSubstitute(database.getUsername()));
        dataSource.setPassword(database.environmentSubstitute(database.getPassword()));
        dataSource.setServername(database.environmentSubstitute(database.getServername()));
        if (database.getAccessType() == 4) {
            dataSource.setType(SqlDataSource.DataSourceType.values()[database.getAccessType()]);
        } else if (database.getAccessType() == 0) {
            dataSource.setType(SqlDataSource.DataSourceType.NATIVE);
        }
        if (database.getAttributes() != null) {
            for (Object key : database.getAttributes().keySet()) {
                dataSource.getAttributes().put((String)key, database.environmentSubstitute((String)database.getAttributes().get(key)));
            }
        }
        return dataSource;
    }

    public static Domain convertFromLegacy(SchemaMeta schemaMeta) throws Exception {
        Domain domain = new Domain();
        domain.setId(schemaMeta.getDomainName());
        ArrayList<LocaleType> localeTypes = new ArrayList<LocaleType>();
        List list = schemaMeta.getLocales().getLocaleList();
        Collections.sort(list, new Comparator<LocaleInterface>(){

            @Override
            public int compare(LocaleInterface o1, LocaleInterface o2) {
                if (o1.getOrder() > o2.getOrder()) {
                    return 1;
                }
                if (o1.getOrder() < o2.getOrder()) {
                    return -1;
                }
                return 0;
            }
        });
        for (LocaleInterface locale : list) {
            LocaleType localeType = new LocaleType();
            localeType.setDescription(locale.getDescription());
            localeType.setCode(locale.getCode());
            localeTypes.add(localeType);
        }
        domain.setLocales(localeTypes);
        for (DatabaseMeta database : schemaMeta.getDatabases()) {
            PhysicalTable[] tables;
            SqlPhysicalModel sqlModel = new SqlPhysicalModel();
            SqlDataSource dataSource = ThinModelConverter.convertFromLegacy(database);
            sqlModel.setDatasource(dataSource);
            sqlModel.setId(database.getName());
            for (PhysicalTable table : tables = schemaMeta.getTablesOnDatabase(database)) {
                SqlPhysicalTable sqlTable = new SqlPhysicalTable(sqlModel);
                ThinModelConverter.convertConceptFromLegacy(table, sqlTable);
                if (table.getTargetTable().toLowerCase().startsWith("select ")) {
                    sqlTable.setTargetTableType(TargetTableType.INLINE_SQL);
                }
                for (PhysicalColumn column : table.getPhysicalColumns()) {
                    SqlPhysicalColumn sqlColumn = new SqlPhysicalColumn(sqlTable);
                    ThinModelConverter.convertConceptFromLegacy(column, sqlColumn);
                    sqlTable.getPhysicalColumns().add(sqlColumn);
                }
                sqlModel.getPhysicalTables().add(sqlTable);
            }
            domain.addPhysicalModel(sqlModel);
        }
        for (BusinessModel model : schemaMeta.getBusinessModels()) {
            LogicalModel logicalModel = new LogicalModel();
            ThinModelConverter.convertConceptFromLegacy(model, logicalModel);
            for (Object biztable : model.getBusinessTables()) {
                BusinessTable businessTable = (BusinessTable)biztable;
                LogicalTable logicalTable = new LogicalTable();
                IPhysicalTable physicalTable = domain.findPhysicalTable(businessTable.getPhysicalTable().getId());
                if (physicalTable != null && logicalModel.getPhysicalModel() == null) {
                    logicalModel.setPhysicalModel(physicalTable.getPhysicalModel());
                }
                logicalTable.setPhysicalTable(physicalTable);
                logicalTable.setLogicalModel(logicalModel);
                if (businessTable.getLocation() != null) {
                    logicalTable.setProperty("__LEGACY_TAG_POSITION_X", "" + businessTable.getLocation().x);
                    logicalTable.setProperty("__LEGACY_TAG_POSITION_Y", "" + businessTable.getLocation().y);
                }
                logicalTable.setProperty("__LEGACY_TABLE_IS_DRAWN", "" + businessTable.isDrawn());
                ThinModelConverter.convertConceptFromLegacy(businessTable, logicalTable);
                for (BusinessColumn column : businessTable.getBusinessColumns()) {
                    LogicalColumn logicalColumn = new LogicalColumn();
                    for (IPhysicalColumn physicalColumn : physicalTable.getPhysicalColumns()) {
                        if (!physicalColumn.getId().equals(column.getPhysicalColumn().getId())) continue;
                        logicalColumn.setPhysicalColumn(physicalColumn);
                    }
                    logicalColumn.setLogicalTable(logicalTable);
                    ThinModelConverter.convertConceptFromLegacy(column, logicalColumn);
                    logicalTable.getLogicalColumns().add(logicalColumn);
                }
                logicalModel.getLogicalTables().add(logicalTable);
            }
            for (RelationshipMeta rel : model.getRelationships()) {
                LogicalRelationship logical = new LogicalRelationship();
                logical.setComplex(rel.isComplex());
                logical.setComplexJoin(rel.getComplexJoin());
                logical.setJoinOrderKey(rel.getJoinOrderKey());
                if (domain.getLocales().size() > 0) {
                    logical.setRelationshipDescription(rel.getDescription());
                }
                logical.setRelationshipType(RelationshipType.values()[rel.getType()]);
                LogicalTable toTable = null;
                LogicalTable fromTable = null;
                LogicalColumn toColumn = null;
                LogicalColumn fromColumn = null;
                if (rel.getTableTo() != null) {
                    toTable = logicalModel.findLogicalTable(rel.getTableTo().getId());
                }
                if (rel.getTableFrom() != null) {
                    fromTable = logicalModel.findLogicalTable(rel.getTableFrom().getId());
                }
                if (rel.getFieldTo() != null) {
                    toColumn = logicalModel.findLogicalColumn(rel.getFieldTo().getId());
                }
                if (rel.getFieldFrom() != null) {
                    fromColumn = logicalModel.findLogicalColumn(rel.getFieldFrom().getId());
                }
                logical.setToTable(toTable);
                logical.setToColumn(toColumn);
                logical.setFromTable(fromTable);
                logical.setFromColumn(fromColumn);
                String logicalRelationshipId = "";
                if (fromTable != null) {
                    logicalRelationshipId = logicalRelationshipId + fromTable.getId();
                    if (fromColumn != null) {
                        logicalRelationshipId = logicalRelationshipId + "." + fromColumn.getId();
                    }
                }
                if (fromTable != null && toTable != null) {
                    logicalRelationshipId = logicalRelationshipId + "-";
                }
                if (toTable != null) {
                    logicalRelationshipId = logicalRelationshipId + toTable.getId();
                    if (toColumn != null) {
                        logicalRelationshipId = logicalRelationshipId + "." + toColumn.getId();
                    }
                }
                logical.setId(logicalRelationshipId);
                logical.setLogicalModel(logicalModel);
                logicalModel.getLogicalRelationships().add(logical);
            }
            for (BusinessCategory bizCategory : model.getRootCategory().getBusinessCategories()) {
                Category category = new Category(logicalModel);
                ThinModelConverter.convertConceptFromLegacy(bizCategory, category);
                for (Object bizColumn : bizCategory.getBusinessColumns()) {
                    BusinessColumn businessColumn = (BusinessColumn)bizColumn;
                    category.getLogicalColumns().add(logicalModel.findLogicalColumn(businessColumn.getId()));
                }
                logicalModel.getCategories().add(category);
            }
            domain.addLogicalModel(logicalModel);
        }
        return domain;
    }
}

