/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.graph;

import org.pentaho.pms.mql.graph.ConsistencyException;
import org.pentaho.pms.mql.graph.GraphElement;
import org.pentaho.pms.mql.graph.GraphElementRequirement;

public class GraphElementDomain {
    private GraphElement element;
    private GraphElementRequirement requirement;

    public GraphElementDomain(GraphElement element) {
        this.element = element;
        this.requirement = GraphElementRequirement.UNKNOWN;
    }

    public boolean setRequirement(boolean required) throws ConsistencyException {
        if (!required && this.requirement == GraphElementRequirement.NOT_REQUIRED || required && this.requirement == GraphElementRequirement.REQUIRED) {
            return false;
        }
        if (this.requirement != GraphElementRequirement.UNKNOWN) {
            throw new ConsistencyException(this.element);
        }
        this.requirement = required ? GraphElementRequirement.REQUIRED : GraphElementRequirement.NOT_REQUIRED;
        return true;
    }

    public void clearRequirement() {
        this.requirement = GraphElementRequirement.UNKNOWN;
    }

    public GraphElementRequirement getRequirement() {
        return this.requirement;
    }
}

