/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.impl;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.ftp4che.FTPConnection;
import org.ftp4che.commands.Command;
import org.ftp4che.exception.AuthenticationNotSupportedException;
import org.ftp4che.exception.FtpIOException;
import org.ftp4che.exception.FtpWorkflowException;
import org.ftp4che.exception.NotConnectedException;
import org.ftp4che.io.ReplyWorker;
import org.ftp4che.io.SocketProvider;
import org.ftp4che.reply.Reply;

public class NormalFTPConnection
extends FTPConnection {
    Logger log = Logger.getLogger((String)NormalFTPConnection.class.getName());

    public void connect() throws NotConnectedException, IOException, AuthenticationNotSupportedException, FtpIOException, FtpWorkflowException {
        this.setConnectionStatusLock(1);
        this.socketProvider = new SocketProvider();
        String hostAndPort = this.getAddress().getHostName() + ":" + this.getAddress().getPort();
        try {
            this.socketProvider.connect(this.getAddress(), this.getProxy(), this.getDownloadBandwidth(), this.getUploadBandwidth());
            this.log.debug((Object)("connected to:" + hostAndPort));
            this.socketProvider.socket().setSoTimeout(this.getTimeout());
            this.socketProvider.socket().setKeepAlive(true);
        }
        catch (IOException ioe) {
            String error = "Error connection to:" + hostAndPort;
            this.log.error((Object)error, (Throwable)ioe);
            throw new NotConnectedException(error);
        }
        ReplyWorker.readReply(this.socketProvider).dumpReply();
        Reply reply = this.sendCommand(new Command("USER", this.getUser()));
        reply.dumpReply();
        reply.validate();
        if (this.getPassword() != null && this.getPassword().length() > 0) {
            reply = this.sendCommand(new Command("PASS", this.getPassword()));
            reply.dumpReply();
            reply.validate();
        }
        if (this.getAccount() != null && this.getAccount().length() > 0) {
            reply = this.sendCommand(new Command("ACCT", this.getAccount()));
            reply.dumpReply();
            reply.validate();
        }
        this.checkFeatures();
        this.setConnectionStatus(1001);
        this.setConnectionStatus(1003);
        this.checkSystem();
        this.setConnectionStatusLock(0);
    }
}

