/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import com.cloudera.sqoop.mapreduce.db.DBConfiguration;
import com.cloudera.sqoop.mapreduce.db.DBInputFormat;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.sqoop.mapreduce.DBWritable;
import org.apache.sqoop.util.LoggingUtils;

public class DBRecordReader<T extends DBWritable>
extends RecordReader<LongWritable, T> {
    private static final Log LOG = LogFactory.getLog(DBRecordReader.class);
    private ResultSet results = null;
    private Class<T> inputClass;
    private Configuration conf;
    private DBInputFormat.DBInputSplit split;
    private long pos = 0L;
    private LongWritable key = null;
    private T value = null;
    private Connection connection;
    protected PreparedStatement statement;
    private DBConfiguration dbConf;
    private String conditions;
    private String[] fieldNames;
    private String tableName;

    public DBRecordReader(DBInputFormat.DBInputSplit split, Class<T> inputClass, Configuration conf, Connection conn, DBConfiguration dbConfig, String cond, String[] fields, String table) throws SQLException {
        this.inputClass = inputClass;
        this.split = split;
        this.conf = conf;
        this.connection = conn;
        this.dbConf = dbConfig;
        this.conditions = cond;
        if (fields != null) {
            this.fieldNames = Arrays.copyOf(fields, fields.length);
        }
        this.tableName = table;
    }

    protected ResultSet executeQuery(String query) throws SQLException {
        this.statement = this.connection.prepareStatement(query, 1003, 1007);
        Integer fetchSize = this.dbConf.getFetchSize();
        if (fetchSize != null) {
            LOG.debug((Object)("Using fetchSize for next query: " + fetchSize));
            this.statement.setFetchSize(fetchSize);
        }
        LOG.info((Object)("Executing query: " + query));
        return this.statement.executeQuery();
    }

    protected String getSelectQuery() {
        StringBuilder query = new StringBuilder();
        if (this.dbConf.getInputQuery() == null) {
            String orderBy;
            query.append("SELECT ");
            for (int i = 0; i < this.fieldNames.length; ++i) {
                query.append(this.fieldNames[i]);
                if (i == this.fieldNames.length - 1) continue;
                query.append(", ");
            }
            query.append(" FROM ").append(this.tableName);
            query.append(" AS ").append(this.tableName);
            if (this.conditions != null && this.conditions.length() > 0) {
                query.append(" WHERE (").append(this.conditions).append(")");
            }
            if ((orderBy = this.dbConf.getInputOrderBy()) != null && orderBy.length() > 0) {
                query.append(" ORDER BY ").append(orderBy);
            }
        } else {
            query.append(this.dbConf.getInputQuery());
        }
        try {
            query.append(" LIMIT ").append(this.split.getLength());
            query.append(" OFFSET ").append(this.split.getStart());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return query.toString();
    }

    public void close() throws IOException {
        try {
            if (null != this.results) {
                this.results.close();
            }
            if (null != this.statement) {
                this.statement.close();
            }
            if (null != this.connection && !this.connection.isClosed()) {
                this.connection.commit();
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public T getCurrentValue() {
        return this.value;
    }

    @Deprecated
    public T createValue() {
        return (T)((DBWritable)ReflectionUtils.newInstance(this.inputClass, (Configuration)this.conf));
    }

    @Deprecated
    public long getPos() throws IOException {
        return this.pos;
    }

    @Deprecated
    public boolean next(LongWritable k, T v) throws IOException {
        this.key = k;
        this.value = v;
        return this.nextKeyValue();
    }

    public float getProgress() throws IOException {
        return (float)this.pos / (float)this.split.getLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextKeyValue() throws IOException {
        try {
            if (this.key == null) {
                this.key = new LongWritable();
            }
            if (this.value == null) {
                this.value = this.createValue();
            }
            if (null == this.results) {
                LOG.info((Object)("Working on split: " + (Object)((Object)this.split)));
                this.results = this.executeQuery(this.getSelectQuery());
            }
            if (!this.results.next()) {
                return false;
            }
            this.key.set(this.pos + this.split.getStart());
            this.value.readFields(this.results);
            ++this.pos;
        }
        catch (SQLException e) {
            LoggingUtils.logAll(LOG, e);
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", ex);
                }
                finally {
                    this.statement = null;
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close connection", ex);
                }
                finally {
                    this.connection = null;
                }
            }
            if (this.results != null) {
                try {
                    this.results.close();
                }
                catch (SQLException ex) {
                    LoggingUtils.logAll(LOG, "Failed to close ResultsSet", ex);
                }
                finally {
                    this.results = null;
                }
            }
            throw new IOException("SQLException in nextKeyValue", e);
        }
        return true;
    }

    protected boolean isDone() {
        try {
            return this.results != null && this.results.isAfterLast();
        }
        catch (SQLException sqlE) {
            return true;
        }
    }

    protected DBInputFormat.DBInputSplit getSplit() {
        return this.split;
    }

    protected String[] getFieldNames() {
        return this.fieldNames;
    }

    protected String getTableName() {
        return this.tableName;
    }

    protected String getConditions() {
        return this.conditions;
    }

    protected DBConfiguration getDBConf() {
        return this.dbConf;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected void setConnection(Connection conn) {
        this.connection = conn;
    }

    protected PreparedStatement getStatement() {
        return this.statement;
    }

    protected void setStatement(PreparedStatement stmt) {
        this.statement = stmt;
    }

    protected Configuration getConf() {
        return this.conf;
    }
}

