/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Font;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.LineRenderer3D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.pentaho.plugin.jfreereport.reportcharts.BarChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.CollectorFunctionResult;
import org.pentaho.plugin.jfreereport.reportcharts.ICollectorFunction;
import org.pentaho.plugin.jfreereport.reportcharts.MultiPlotChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.backport.FastNumberTickUnit;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;

public class BarLineChartExpression
extends BarChartExpression
implements MultiPlotChartExpression {
    private static final long serialVersionUID = 7082583397390897215L;
    private String linesDataSource;
    private String secondValueAxisLabel = "";
    private ArrayList<String> lineSeriesColor = new ArrayList();
    private String linesLabelFont = "SansSerif--8";
    @Deprecated
    private String linesTickLabelFont = "SansSerif--8";
    private String lineTicksLabelFormat;
    private String lineStyle;
    private float lineWidth = 1.0f;
    private boolean markersVisible = false;
    private boolean sharedRangeAxis;
    private double linePeriodCount = 0.0;
    private Class lineTimePeriod;
    private Font lineTitleFont;
    private Font lineTickFont;
    private double lineRangeMinimum = 0.0;
    private double lineRangeMaximum = 1.0;
    private boolean lineAxisAutoRange = true;
    private boolean lineAxisIncludesZero = true;
    private boolean lineAxisStickyZero = true;

    public boolean isLineAxisIncludesZero() {
        return this.lineAxisIncludesZero;
    }

    public void setLineAxisIncludesZero(boolean lineAxisIncludesZero) {
        this.lineAxisIncludesZero = lineAxisIncludesZero;
    }

    public boolean isLineAxisStickyZero() {
        return this.lineAxisStickyZero;
    }

    public void setLineAxisStickyZero(boolean lineAxisStickyZero) {
        this.lineAxisStickyZero = lineAxisStickyZero;
    }

    public Font getLineTitleFont() {
        return this.lineTitleFont;
    }

    public void setLineTitleFont(Font lineTitleFont) {
        this.lineTitleFont = lineTitleFont;
    }

    public Font getLineTickFont() {
        return this.lineTickFont;
    }

    public void setLineTickFont(Font lineTickFont) {
        this.lineTickFont = lineTickFont;
    }

    public double getLineRangeMinimum() {
        return this.lineRangeMinimum;
    }

    public void setLineRangeMinimum(double lineRangeMinimum) {
        this.lineRangeMinimum = lineRangeMinimum;
    }

    public double getLineRangeMaximum() {
        return this.lineRangeMaximum;
    }

    public void setLineRangeMaximum(double lineRangeMaximum) {
        this.lineRangeMaximum = lineRangeMaximum;
    }

    public double getLinePeriodCount() {
        return this.linePeriodCount;
    }

    public void setLinePeriodCount(double linePeriodCount) {
        this.linePeriodCount = linePeriodCount;
    }

    public Class getLineTimePeriod() {
        return this.lineTimePeriod;
    }

    public void setLineTimePeriod(Class lineTimePeriod) {
        this.lineTimePeriod = lineTimePeriod;
    }

    public boolean isSharedRangeAxis() {
        return this.sharedRangeAxis;
    }

    public void setSharedRangeAxis(boolean sharedRangeAxis) {
        this.sharedRangeAxis = sharedRangeAxis;
    }

    @Override
    public Expression getInstance() {
        BarLineChartExpression chartExpression = (BarLineChartExpression)super.getInstance();
        chartExpression.lineSeriesColor = (ArrayList)this.lineSeriesColor.clone();
        return chartExpression;
    }

    public String getLinesDataSource() {
        return this.linesDataSource;
    }

    public void setLinesDataSource(String linesDataSource) {
        this.linesDataSource = linesDataSource;
    }

    @Override
    public String getSecondaryDataSet() {
        return this.getLinesDataSource();
    }

    @Override
    public void setSecondaryDataSet(String dataset) {
        this.setLinesDataSource(dataset);
    }

    public String getLinesLabelFont() {
        return this.linesLabelFont;
    }

    public void setLinesLabelFont(String linesLabelFont) {
        this.linesLabelFont = linesLabelFont;
    }

    @Deprecated
    public String getLinesTickLabelFont() {
        return this.linesTickLabelFont;
    }

    @Deprecated
    public void setLinesTickLabelFont(String linesTickLabelFont) {
        this.linesTickLabelFont = linesTickLabelFont;
    }

    public String getSecondValueAxisLabel() {
        return this.secondValueAxisLabel;
    }

    public void setSecondValueAxisLabel(String secondValueAxisLabel) {
        this.secondValueAxisLabel = secondValueAxisLabel;
    }

    public String getLineTicksLabelFormat() {
        return this.lineTicksLabelFormat;
    }

    public void setLineTicksLabelFormat(String lineTicksLabelFormat) {
        this.lineTicksLabelFormat = lineTicksLabelFormat;
    }

    public void setLineSeriesColor(int index, String field) {
        if (this.lineSeriesColor.size() == index) {
            this.lineSeriesColor.add(field);
        } else {
            this.lineSeriesColor.set(index, field);
        }
    }

    public String getLineSeriesColor(int index) {
        return this.lineSeriesColor.get(index);
    }

    public int getLineSeriesColorCount() {
        return this.lineSeriesColor.size();
    }

    public String[] getLineSeriesColor() {
        String[] toArray = this.lineSeriesColor.toArray(new String[this.lineSeriesColor.size()]);
        return toArray;
    }

    public void setLineSeriesColor(String[] fields) {
        this.lineSeriesColor.clear();
        this.lineSeriesColor.addAll(Arrays.asList(fields));
    }

    public String getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(String value) {
        this.lineStyle = value;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float value) {
        this.lineWidth = value;
    }

    public boolean isMarkersVisible() {
        return this.markersVisible;
    }

    public void setMarkersVisible(boolean markersVisible) {
        this.markersVisible = markersVisible;
    }

    public String getBarsTickLabelFont() {
        return this.convertFontToString(this.getRangeTickFont());
    }

    public void setBarsTickLabelFont(String barsTickLabelFont) {
        this.setRangeTickFont(Font.decode(barsTickLabelFont));
    }

    public String getCategoryTickLabelFont() {
        return this.getLabelFont();
    }

    public void setCategoryTickLabelFont(String categoryTickLabelFont) {
        this.setLabelFont(categoryTickLabelFont);
    }

    public String getBarTicksLabelFormat() {
        return this.getRangeTickFormatString();
    }

    public void setBarTicksLabelFormat(String lineTicksLabelDateFormat) {
        this.setRangeTickFormatString(lineTicksLabelDateFormat);
    }

    public String getBarsLabelFont() {
        return this.convertFontToString(this.getRangeTitleFont());
    }

    public void setBarsLabelFont(String barsLabelFont) {
        this.setRangeTitleFont(Font.decode(barsLabelFont));
    }

    public boolean isLineAxisAutoRange() {
        return this.lineAxisAutoRange;
    }

    public void setLineAxisAutoRange(boolean lineAxisAutoRange) {
        this.lineAxisAutoRange = lineAxisAutoRange;
    }

    @Override
    public JFreeChart computeCategoryChart(CategoryDataset barsDataset) {
        JFreeChart chart = super.computeCategoryChart(barsDataset);
        CategoryDataset linesDataset = this.createLinesDataset();
        CategoryPlot plot = chart.getCategoryPlot();
        Object lineRenderer = this.isThreeD() ? new LineRenderer3D() : new LineAndShapeRenderer();
        if (linesDataset != null) {
            Object linesAxis = this.isSharedRangeAxis() ? plot.getRangeAxis() : (this.isThreeD() ? new NumberAxis3D(this.getSecondValueAxisLabel()) : new NumberAxis(this.getSecondValueAxisLabel()));
            plot.setRenderer(1, (CategoryItemRenderer)lineRenderer);
            plot.setDataset(1, linesDataset);
            plot.setRangeAxis(1, linesAxis);
            plot.mapDatasetToRangeAxis(1, 1);
            plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        }
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        return chart;
    }

    private CategoryDataset createLinesDataset() {
        Dataset dataset;
        Object collector;
        Object maybeCollector = this.getDataRow().get(this.getLinesDataSource());
        if (maybeCollector instanceof ICollectorFunction) {
            collector = (ICollectorFunction)maybeCollector;
            dataset = (Dataset)collector.getDatasourceValue();
        } else if (maybeCollector instanceof CollectorFunctionResult) {
            collector = (CollectorFunctionResult)maybeCollector;
            dataset = collector.getDataSet();
        } else {
            dataset = null;
        }
        CategoryDataset linesDataset = dataset instanceof CategoryDataset ? (CategoryDataset)dataset : null;
        return linesDataset;
    }

    @Override
    protected void configureChart(JFreeChart chart) {
        LineAndShapeRenderer linesRenderer;
        super.configureChart(chart);
        CategoryPlot plot = chart.getCategoryPlot();
        if (!this.isSharedRangeAxis()) {
            Format formatter;
            NumberAxis numberAxis;
            ValueAxis linesAxis = plot.getRangeAxis(1);
            if (linesAxis instanceof NumberAxis) {
                numberAxis = (NumberAxis)linesAxis;
                numberAxis.setAutoRangeIncludesZero(this.isLineAxisIncludesZero());
                numberAxis.setAutoRangeStickyZero(this.isLineAxisStickyZero());
                if (this.getLinePeriodCount() > 0.0) {
                    if (this.getLineTicksLabelFormat() != null) {
                        formatter = new FastDecimalFormat(this.getLineTicksLabelFormat(), this.getResourceBundleFactory().getLocale());
                        numberAxis.setTickUnit((NumberTickUnit)new FastNumberTickUnit(this.getLinePeriodCount(), (FastDecimalFormat)formatter));
                    } else {
                        numberAxis.setTickUnit((NumberTickUnit)new FastNumberTickUnit(this.getLinePeriodCount()));
                    }
                } else if (this.getLineTicksLabelFormat() != null) {
                    formatter = new DecimalFormat(this.getLineTicksLabelFormat(), new DecimalFormatSymbols(this.getResourceBundleFactory().getLocale()));
                    numberAxis.setNumberFormatOverride((NumberFormat)formatter);
                }
            } else if (linesAxis instanceof DateAxis) {
                numberAxis = (DateAxis)linesAxis;
                if (this.getLinePeriodCount() > 0.0 && this.getLineTimePeriod() != null) {
                    if (this.getLineTicksLabelFormat() != null) {
                        formatter = new SimpleDateFormat(this.getLineTicksLabelFormat(), new DateFormatSymbols(this.getResourceBundleFactory().getLocale()));
                        numberAxis.setTickUnit(new DateTickUnit(this.getDateUnitAsInt(this.getLineTimePeriod()), (int)this.getLinePeriodCount(), (DateFormat)formatter));
                    } else {
                        numberAxis.setTickUnit(new DateTickUnit(this.getDateUnitAsInt(this.getLineTimePeriod()), (int)this.getLinePeriodCount()));
                    }
                } else if (this.getRangeTickFormatString() != null) {
                    formatter = new SimpleDateFormat(this.getRangeTickFormatString(), new DateFormatSymbols(this.getResourceBundleFactory().getLocale()));
                    numberAxis.setDateFormatOverride((DateFormat)formatter);
                }
            }
            if (linesAxis != null) {
                int level;
                Font labelFont = Font.decode(this.getLabelFont());
                linesAxis.setLabelFont(labelFont);
                linesAxis.setTickLabelFont(labelFont);
                if (this.getLineTitleFont() != null) {
                    linesAxis.setLabelFont(this.getLineTitleFont());
                }
                if (this.getLineTickFont() != null) {
                    linesAxis.setTickLabelFont(this.getLineTickFont());
                }
                if (ClassicEngineBoot.isEnforceCompatibilityFor((int)(level = this.getRuntime().getProcessingContext().getCompatibilityLevel()), (int)3, (int)8)) {
                    if (this.getRangeMinimum() != 0.0) {
                        linesAxis.setLowerBound(this.getLineRangeMinimum());
                    }
                    if (this.getRangeMaximum() != 1.0) {
                        linesAxis.setUpperBound(this.getLineRangeMaximum());
                    }
                    if (this.getLineRangeMinimum() == 0.0 && this.getLineRangeMaximum() == 1.0) {
                        linesAxis.setLowerBound(0.0);
                        linesAxis.setUpperBound(1.0);
                        linesAxis.setAutoRange(true);
                    }
                } else {
                    linesAxis.setLowerBound(this.getLineRangeMinimum());
                    linesAxis.setUpperBound(this.getLineRangeMaximum());
                    linesAxis.setAutoRange(this.isLineAxisAutoRange());
                }
            }
        }
        if ((linesRenderer = (LineAndShapeRenderer)plot.getRenderer(1)) != null) {
            linesRenderer.setStroke(BarLineChartExpression.translateLineStyle(this.lineWidth, this.lineStyle));
            linesRenderer.setShapesVisible(this.isMarkersVisible());
            linesRenderer.setBaseShapesFilled(this.isMarkersVisible());
            for (int i = 0; i < this.lineSeriesColor.size(); ++i) {
                String s = this.lineSeriesColor.get(i);
                linesRenderer.setSeriesPaint(i, (Paint)this.parseColorFromString(s));
            }
        }
    }

    private String convertFontToString(Font font) {
        if (font == null) {
            return null;
        }
        String fontName = font.getFamily();
        int fontSize = font.getSize();
        int fontStyle = font.getStyle();
        String fontStyleText = (fontStyle & 3) == 3 ? "BOLDITALIC" : ((fontStyle & 1) == 1 ? "BOLD" : ((fontStyle & 2) == 2 ? "ITALIC" : "PLAIN"));
        return fontName + "-" + fontStyleText + "-" + fontSize;
    }

    @Override
    public void reconfigureForCompatibility(int versionTag) {
        super.reconfigureForCompatibility(versionTag);
        if (ClassicEngineBoot.isEnforceCompatibilityFor((int)versionTag, (int)3, (int)8)) {
            this.setLineAxisAutoRange(this.getLineRangeMinimum() == 0.0 && this.getLineRangeMaximum() == 1.0);
        }
    }
}

