/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMActiveServiceContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class RMContextImpl
implements RMContext {
    private static final Log LOG = LogFactory.getLog(RMContextImpl.class);
    private static final String UNAVAILABLE = "N/A";
    private Dispatcher rmDispatcher;
    private boolean isHAEnabled;
    private HAServiceProtocol.HAServiceState haServiceState = HAServiceProtocol.HAServiceState.INITIALIZING;
    private AdminService adminService;
    private ConfigurationProvider configurationProvider;
    private RMActiveServiceContext activeServiceContext;
    private Configuration yarnConfiguration;
    private ResourceManager resourceManager;
    private String proxyHostAndPort = null;

    public RMContextImpl() {
    }

    @VisibleForTesting
    public RMContextImpl(Dispatcher rmDispatcher, ContainerAllocationExpirer containerAllocationExpirer, AMLivelinessMonitor amLivelinessMonitor, AMLivelinessMonitor amFinishingMonitor, DelegationTokenRenewer delegationTokenRenewer, AMRMTokenSecretManager appTokenSecretManager, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager, ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager, RMApplicationHistoryWriter rmApplicationHistoryWriter) {
        this();
        this.setDispatcher(rmDispatcher);
        this.setActiveServiceContext(new RMActiveServiceContext(rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, delegationTokenRenewer, appTokenSecretManager, containerTokenSecretManager, nmTokenSecretManager, clientToAMTokenSecretManager, rmApplicationHistoryWriter));
        LocalConfigurationProvider provider = new LocalConfigurationProvider();
        this.setConfigurationProvider((ConfigurationProvider)provider);
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.rmDispatcher;
    }

    @Override
    public RMStateStore getStateStore() {
        return this.activeServiceContext.getStateStore();
    }

    @Override
    public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
        return this.activeServiceContext.getRMApps();
    }

    @Override
    public ConcurrentMap<NodeId, RMNode> getRMNodes() {
        return this.activeServiceContext.getRMNodes();
    }

    @Override
    public ConcurrentMap<NodeId, RMNode> getInactiveRMNodes() {
        return this.activeServiceContext.getInactiveRMNodes();
    }

    @Override
    public ContainerAllocationExpirer getContainerAllocationExpirer() {
        return this.activeServiceContext.getContainerAllocationExpirer();
    }

    @Override
    public AMLivelinessMonitor getAMLivelinessMonitor() {
        return this.activeServiceContext.getAMLivelinessMonitor();
    }

    @Override
    public AMLivelinessMonitor getAMFinishingMonitor() {
        return this.activeServiceContext.getAMFinishingMonitor();
    }

    @Override
    public DelegationTokenRenewer getDelegationTokenRenewer() {
        return this.activeServiceContext.getDelegationTokenRenewer();
    }

    @Override
    public AMRMTokenSecretManager getAMRMTokenSecretManager() {
        return this.activeServiceContext.getAMRMTokenSecretManager();
    }

    @Override
    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.activeServiceContext.getContainerTokenSecretManager();
    }

    @Override
    public NMTokenSecretManagerInRM getNMTokenSecretManager() {
        return this.activeServiceContext.getNMTokenSecretManager();
    }

    @Override
    public ResourceScheduler getScheduler() {
        return this.activeServiceContext.getScheduler();
    }

    @Override
    public ReservationSystem getReservationSystem() {
        return this.activeServiceContext.getReservationSystem();
    }

    @Override
    public NodesListManager getNodesListManager() {
        return this.activeServiceContext.getNodesListManager();
    }

    @Override
    public ClientToAMTokenSecretManagerInRM getClientToAMTokenSecretManager() {
        return this.activeServiceContext.getClientToAMTokenSecretManager();
    }

    @Override
    public AdminService getRMAdminService() {
        return this.adminService;
    }

    @VisibleForTesting
    public void setStateStore(RMStateStore store) {
        this.activeServiceContext.setStateStore(store);
    }

    @Override
    public ClientRMService getClientRMService() {
        return this.activeServiceContext.getClientRMService();
    }

    @Override
    public ApplicationMasterService getApplicationMasterService() {
        return this.activeServiceContext.getApplicationMasterService();
    }

    @Override
    public ResourceTrackerService getResourceTrackerService() {
        return this.activeServiceContext.getResourceTrackerService();
    }

    void setHAEnabled(boolean isHAEnabled) {
        this.isHAEnabled = isHAEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHAServiceState(HAServiceProtocol.HAServiceState haServiceState) {
        HAServiceProtocol.HAServiceState hAServiceState = haServiceState;
        synchronized (hAServiceState) {
            this.haServiceState = haServiceState;
        }
    }

    void setDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    void setRMAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    @Override
    public void setClientRMService(ClientRMService clientRMService) {
        this.activeServiceContext.setClientRMService(clientRMService);
    }

    @Override
    public RMDelegationTokenSecretManager getRMDelegationTokenSecretManager() {
        return this.activeServiceContext.getRMDelegationTokenSecretManager();
    }

    @Override
    public void setRMDelegationTokenSecretManager(RMDelegationTokenSecretManager delegationTokenSecretManager) {
        this.activeServiceContext.setRMDelegationTokenSecretManager(delegationTokenSecretManager);
    }

    void setContainerAllocationExpirer(ContainerAllocationExpirer containerAllocationExpirer) {
        this.activeServiceContext.setContainerAllocationExpirer(containerAllocationExpirer);
    }

    void setAMLivelinessMonitor(AMLivelinessMonitor amLivelinessMonitor) {
        this.activeServiceContext.setAMLivelinessMonitor(amLivelinessMonitor);
    }

    void setAMFinishingMonitor(AMLivelinessMonitor amFinishingMonitor) {
        this.activeServiceContext.setAMFinishingMonitor(amFinishingMonitor);
    }

    void setContainerTokenSecretManager(RMContainerTokenSecretManager containerTokenSecretManager) {
        this.activeServiceContext.setContainerTokenSecretManager(containerTokenSecretManager);
    }

    void setNMTokenSecretManager(NMTokenSecretManagerInRM nmTokenSecretManager) {
        this.activeServiceContext.setNMTokenSecretManager(nmTokenSecretManager);
    }

    void setScheduler(ResourceScheduler scheduler) {
        this.activeServiceContext.setScheduler(scheduler);
    }

    void setReservationSystem(ReservationSystem reservationSystem) {
        this.activeServiceContext.setReservationSystem(reservationSystem);
    }

    void setDelegationTokenRenewer(DelegationTokenRenewer delegationTokenRenewer) {
        this.activeServiceContext.setDelegationTokenRenewer(delegationTokenRenewer);
    }

    void setClientToAMTokenSecretManager(ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager) {
        this.activeServiceContext.setClientToAMTokenSecretManager(clientToAMTokenSecretManager);
    }

    void setAMRMTokenSecretManager(AMRMTokenSecretManager amRMTokenSecretManager) {
        this.activeServiceContext.setAMRMTokenSecretManager(amRMTokenSecretManager);
    }

    void setNodesListManager(NodesListManager nodesListManager) {
        this.activeServiceContext.setNodesListManager(nodesListManager);
    }

    void setApplicationMasterService(ApplicationMasterService applicationMasterService) {
        this.activeServiceContext.setApplicationMasterService(applicationMasterService);
    }

    void setResourceTrackerService(ResourceTrackerService resourceTrackerService) {
        this.activeServiceContext.setResourceTrackerService(resourceTrackerService);
    }

    @Override
    public boolean isHAEnabled() {
        return this.isHAEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HAServiceProtocol.HAServiceState getHAServiceState() {
        HAServiceProtocol.HAServiceState hAServiceState = this.haServiceState;
        synchronized (hAServiceState) {
            return this.haServiceState;
        }
    }

    public void setWorkPreservingRecoveryEnabled(boolean enabled) {
        this.activeServiceContext.setWorkPreservingRecoveryEnabled(enabled);
    }

    @Override
    public boolean isWorkPreservingRecoveryEnabled() {
        return this.activeServiceContext.isWorkPreservingRecoveryEnabled();
    }

    @Override
    public RMApplicationHistoryWriter getRMApplicationHistoryWriter() {
        return this.activeServiceContext.getRMApplicationHistoryWriter();
    }

    @Override
    public void setSystemMetricsPublisher(SystemMetricsPublisher systemMetricsPublisher) {
        this.activeServiceContext.setSystemMetricsPublisher(systemMetricsPublisher);
    }

    @Override
    public SystemMetricsPublisher getSystemMetricsPublisher() {
        return this.activeServiceContext.getSystemMetricsPublisher();
    }

    @Override
    public void setRMApplicationHistoryWriter(RMApplicationHistoryWriter rmApplicationHistoryWriter) {
        this.activeServiceContext.setRMApplicationHistoryWriter(rmApplicationHistoryWriter);
    }

    @Override
    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    @Override
    public long getEpoch() {
        return this.activeServiceContext.getEpoch();
    }

    void setEpoch(long epoch) {
        this.activeServiceContext.setEpoch(epoch);
    }

    @Override
    public RMNodeLabelsManager getNodeLabelManager() {
        return this.activeServiceContext.getNodeLabelManager();
    }

    @Override
    public void setNodeLabelManager(RMNodeLabelsManager mgr) {
        this.activeServiceContext.setNodeLabelManager(mgr);
    }

    public void setSchedulerRecoveryStartAndWaitTime(long waitTime) {
        this.activeServiceContext.setSchedulerRecoveryStartAndWaitTime(waitTime);
    }

    @Override
    public boolean isSchedulerReadyForAllocatingContainers() {
        return this.activeServiceContext.isSchedulerReadyForAllocatingContainers();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setSystemClock(Clock clock) {
        this.activeServiceContext.setSystemClock(clock);
    }

    @Override
    public ConcurrentMap<ApplicationId, ByteBuffer> getSystemCredentialsForApps() {
        return this.activeServiceContext.getSystemCredentialsForApps();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public RMActiveServiceContext getActiveServiceContext() {
        return this.activeServiceContext;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setActiveServiceContext(RMActiveServiceContext activeServiceContext) {
        this.activeServiceContext = activeServiceContext;
    }

    @Override
    public Configuration getYarnConfiguration() {
        return this.yarnConfiguration;
    }

    public void setYarnConfiguration(Configuration yarnConfiguration) {
        this.yarnConfiguration = yarnConfiguration;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager rm) {
        this.resourceManager = rm;
    }

    String getProxyHostAndPort(Configuration conf) {
        if (this.proxyHostAndPort == null) {
            this.proxyHostAndPort = WebAppUtils.getProxyHostAndPort((Configuration)conf);
        }
        return this.proxyHostAndPort;
    }

    @Override
    public String getAppProxyUrl(Configuration conf, ApplicationId applicationId) {
        try {
            String scheme = WebAppUtils.getHttpSchemePrefix((Configuration)conf);
            URI proxyUri = ProxyUriUtils.getUriFromAMUrl((String)scheme, (String)this.getProxyHostAndPort(conf));
            URI result = ProxyUriUtils.getProxyUri(null, (URI)proxyUri, (ApplicationId)applicationId);
            return result.toASCIIString();
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Could not generate default proxy tracking URL for " + applicationId));
            return UNAVAILABLE;
        }
    }
}

