/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.ShapeElement;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class Group
extends ShapeElement {
    Rectangle2D boundingBox;
    Shape cachedShape;
    final Rectangle clipBounds = new Rectangle();

    public void loaderAddChild(SVGLoaderHelper helper, SVGElement child) throws SVGElementException {
        super.loaderAddChild(helper, child);
    }

    protected boolean outsideClip(Graphics2D g) throws SVGException {
        g.getClipBounds(this.clipBounds);
        Rectangle2D rect = this.getBoundingBox();
        return !rect.intersects(this.clipBounds);
    }

    public void render(Graphics2D g) throws SVGException {
        boolean ignoreClip = this.diagram.ignoringClipHeuristic();
        if (!ignoreClip && this.outsideClip(g)) {
            return;
        }
        this.beginLayer(g);
        Iterator it = this.children.iterator();
        g.getClipBounds(this.clipBounds);
        while (it.hasNext()) {
            SVGElement ele = (SVGElement)it.next();
            if (!(ele instanceof RenderableElement)) continue;
            RenderableElement rendEle = (RenderableElement)ele;
            if (!(ele instanceof Group) && !ignoreClip && !rendEle.getBoundingBox().intersects(this.clipBounds)) continue;
            rendEle.render(g);
        }
        this.finishLayer(g);
    }

    public Shape getShape() {
        if (this.cachedShape == null) {
            this.calcShape();
        }
        return this.cachedShape;
    }

    public void calcShape() {
        Area retShape = new Area();
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            ShapeElement shpEle;
            Shape shape;
            SVGElement ele = (SVGElement)it.next();
            if (!(ele instanceof ShapeElement) || (shape = (shpEle = (ShapeElement)ele).getShape()) == null) continue;
            retShape.add(new Area(shape));
        }
        this.cachedShape = this.shapeToParent(retShape);
    }

    public Rectangle2D getBoundingBox() throws SVGException {
        if (this.boundingBox == null) {
            this.calcBoundingBox();
        }
        return this.boundingBox;
    }

    public void calcBoundingBox() throws SVGException {
        Rectangle2D retRect = null;
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            RenderableElement rendEle;
            Rectangle2D bounds;
            SVGElement ele = (SVGElement)it.next();
            if (!(ele instanceof RenderableElement) || (bounds = (rendEle = (RenderableElement)ele).getBoundingBox()) == null) continue;
            if (retRect == null) {
                retRect = bounds;
                continue;
            }
            retRect = ((Rectangle2D)retRect).createUnion(bounds);
        }
        if (retRect == null) {
            retRect = new Rectangle2D.Float();
        }
        this.boundingBox = this.boundsToParent(retRect);
    }

    public boolean updateTime(double curTime) throws SVGException {
        boolean changeState = super.updateTime(curTime);
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            SVGElement ele = (SVGElement)it.next();
            boolean updateVal = ele.updateTime(curTime);
            boolean bl = changeState = changeState || updateVal;
            if (ele instanceof ShapeElement) {
                this.cachedShape = null;
            }
            if (!(ele instanceof RenderableElement)) continue;
            this.boundingBox = null;
        }
        return changeState;
    }
}

