/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.SVGException;
import com.kitfox.svg.ShapeElement;
import com.kitfox.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public class Rect
extends ShapeElement {
    float x = 0.0f;
    float y = 0.0f;
    float width = 0.0f;
    float height = 0.0f;
    float rx = 0.0f;
    float ry = 0.0f;
    RectangularShape rect;

    protected void build() throws SVGException {
        super.build();
        StyleAttribute sty = new StyleAttribute();
        if (this.getPres(sty.setName("x"))) {
            this.x = sty.getFloatValue();
        }
        if (this.getPres(sty.setName("y"))) {
            this.y = sty.getFloatValue();
        }
        if (this.getPres(sty.setName("width"))) {
            this.width = sty.getFloatValue();
        }
        if (this.getPres(sty.setName("height"))) {
            this.height = sty.getFloatValue();
        }
        boolean rxSet = false;
        if (this.getPres(sty.setName("rx"))) {
            this.rx = sty.getFloatValue();
            rxSet = true;
        }
        boolean rySet = false;
        if (this.getPres(sty.setName("ry"))) {
            this.ry = sty.getFloatValue();
            rySet = true;
        }
        if (!rxSet) {
            this.rx = this.ry;
        }
        if (!rySet) {
            this.ry = this.rx;
        }
        this.rect = this.rx == 0.0f && this.ry == 0.0f ? new Rectangle2D.Float(this.x, this.y, this.width, this.height) : new RoundRectangle2D.Float(this.x, this.y, this.width, this.height, this.rx, this.ry);
    }

    public void render(Graphics2D g) throws SVGException {
        this.beginLayer(g);
        this.renderShape(g, this.rect);
        this.finishLayer(g);
    }

    public Shape getShape() {
        return this.shapeToParent(this.rect);
    }

    public Rectangle2D getBoundingBox() throws SVGException {
        return this.boundsToParent(this.includeStrokeInBounds(this.rect.getBounds2D()));
    }

    public boolean updateTime(double curTime) throws SVGException {
        float newVal;
        boolean changeState = super.updateTime(curTime);
        StyleAttribute sty = new StyleAttribute();
        boolean shapeChange = false;
        if (this.getPres(sty.setName("x")) && (newVal = sty.getFloatValue()) != this.x) {
            this.x = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("y")) && (newVal = sty.getFloatValue()) != this.y) {
            this.y = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("width")) && (newVal = sty.getFloatValue()) != this.width) {
            this.width = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("height")) && (newVal = sty.getFloatValue()) != this.height) {
            this.height = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("rx")) && (newVal = sty.getFloatValue()) != this.rx) {
            this.rx = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("ry")) && (newVal = sty.getFloatValue()) != this.ry) {
            this.ry = newVal;
            shapeChange = true;
        }
        if (shapeChange) {
            this.rect = this.rx == 0.0f && this.ry == 0.0f ? new Rectangle2D.Float(this.x, this.y, this.width, this.height) : new RoundRectangle2D.Float(this.x, this.y, this.width, this.height, this.rx, this.ry);
            return true;
        }
        return changeState;
    }
}

