/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class SVGDisplayPanel
extends JPanel
implements Scrollable {
    public static final long serialVersionUID = 1L;
    SVGDiagram diagram = null;
    float scale = 1.0f;
    Color bgColor = null;

    public SVGDisplayPanel() {
        this.initComponents();
    }

    public void setDiagram(SVGDiagram diagram) {
        this.diagram = diagram;
        this.setDimension();
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.setDimension();
    }

    public void setBgColor(Color col) {
        this.bgColor = col;
    }

    private void setDimension() {
        if (this.diagram == null) {
            this.setPreferredSize(new Dimension(1, 1));
            this.revalidate();
            return;
        }
        Rectangle2D.Float rect = new Rectangle2D.Float();
        this.diagram.getViewRect(rect);
        int w = (int)(rect.width * this.scale);
        int h = (int)(rect.height * this.scale);
        this.setPreferredSize(new Dimension(w, h));
        this.revalidate();
    }

    public void updateTime(double curTime) throws SVGException {
        if (this.diagram == null) {
            return;
        }
        this.diagram.updateTime(curTime);
    }

    public void paintComponent(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        if (this.bgColor != null) {
            Dimension dim = this.getSize();
            g.setColor(this.bgColor);
            g.fillRect(0, 0, dim.width, dim.height);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.diagram != null) {
            try {
                this.diagram.render(g);
            }
            catch (SVGException e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width;
        }
        return visibleRect.height;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollableBlockIncrement(visibleRect, orientation, direction) / 16;
    }
}

