/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Group;
import com.kitfox.svg.SVGException;
import com.kitfox.xml.NumberWithUnits;
import com.kitfox.xml.StyleAttribute;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class SVGRoot
extends Group {
    NumberWithUnits x;
    NumberWithUnits y;
    NumberWithUnits width;
    NumberWithUnits height;
    Rectangle2D.Float viewBox = null;
    public static final int PA_X_NONE = 0;
    public static final int PA_X_MIN = 1;
    public static final int PA_X_MID = 2;
    public static final int PA_X_MAX = 3;
    public static final int PA_Y_NONE = 0;
    public static final int PA_Y_MIN = 1;
    public static final int PA_Y_MID = 2;
    public static final int PA_Y_MAX = 3;
    public static final int PS_MEET = 0;
    public static final int PS_SLICE = 1;
    int parSpecifier = 0;
    int parAlignX = 2;
    int parAlignY = 2;
    final AffineTransform viewXform = new AffineTransform();
    final Rectangle2D.Float clipRect = new Rectangle2D.Float();

    protected void build() throws SVGException {
        super.build();
        StyleAttribute sty = new StyleAttribute();
        if (this.getPres(sty.setName("x"))) {
            this.x = sty.getNumberWithUnits();
        }
        if (this.getPres(sty.setName("y"))) {
            this.y = sty.getNumberWithUnits();
        }
        if (this.getPres(sty.setName("width"))) {
            this.width = sty.getNumberWithUnits();
        }
        if (this.getPres(sty.setName("height"))) {
            this.height = sty.getNumberWithUnits();
        }
        if (this.getPres(sty.setName("viewBox"))) {
            float[] coords = sty.getFloatList();
            this.viewBox = new Rectangle2D.Float(coords[0], coords[1], coords[2], coords[3]);
        }
        if (this.getPres(sty.setName("preserveAspectRatio"))) {
            String[] parList = sty.getStringList();
            if (parList[0].equals("none")) {
                this.parAlignX = 0;
                this.parAlignY = 0;
            } else if (parList[0].equals("xMinYMin")) {
                this.parAlignX = 1;
                this.parAlignY = 1;
            } else if (parList[0].equals("xMidYMin")) {
                this.parAlignX = 2;
                this.parAlignY = 1;
            } else if (parList[0].equals("xMaxYMin")) {
                this.parAlignX = 3;
                this.parAlignY = 1;
            } else if (parList[0].equals("xMinYMid")) {
                this.parAlignX = 1;
                this.parAlignY = 2;
            } else if (parList[0].equals("xMidYMid")) {
                this.parAlignX = 2;
                this.parAlignY = 2;
            } else if (parList[0].equals("xMaxYMid")) {
                this.parAlignX = 3;
                this.parAlignY = 2;
            } else if (parList[0].equals("xMinYMax")) {
                this.parAlignX = 1;
                this.parAlignY = 3;
            } else if (parList[0].equals("xMidYMax")) {
                this.parAlignX = 2;
                this.parAlignY = 3;
            } else if (parList[0].equals("xMaxYMax")) {
                this.parAlignX = 3;
                this.parAlignY = 3;
            }
            if (parList[1].equals("meet")) {
                this.parSpecifier = 0;
            } else if (parList[1].equals("slice")) {
                this.parSpecifier = 1;
            }
        }
        this.prepareViewport();
    }

    protected void prepareViewport() {
        float xx = this.x == null ? 0.0f : this.convertUnitsToPixels(this.x.getUnits(), this.x.getValue());
        float yy = this.y == null ? 0.0f : this.convertUnitsToPixels(this.y.getUnits(), this.x.getValue());
        float ww = this.width == null ? 0.0f : this.convertUnitsToPixels(this.width.getUnits(), this.width.getValue());
        float hh = this.height == null ? 0.0f : this.convertUnitsToPixels(this.height.getUnits(), this.height.getValue());
        this.clipRect.setRect(xx, yy, ww, hh);
        if (this.viewBox == null) {
            this.viewXform.setToIdentity();
            return;
        }
        this.viewXform.setToTranslation(this.viewBox.x, this.viewBox.y);
        this.viewXform.scale(this.clipRect.width / this.viewBox.width, this.clipRect.height / this.viewBox.height);
        this.viewXform.translate(-this.clipRect.x, -this.clipRect.y);
    }

    public float getDeviceWidth() {
        return this.clipRect.width;
    }

    public float getDeviceHeight() {
        return this.clipRect.height;
    }

    public Rectangle2D getDeviceRect(Rectangle2D rect) {
        rect.setRect(this.clipRect);
        return rect;
    }

    private float convertUnitsToPixels(int unitType, float value) {
        float pixPerInch = Toolkit.getDefaultToolkit().getScreenResolution();
        float inchesPerCm = 0.3936f;
        switch (this.width.getUnits()) {
            case 4: {
                return value * pixPerInch;
            }
            case 2: {
                return value * 0.3936f * pixPerInch;
            }
            case 3: {
                return value * 0.1f * 0.3936f * pixPerInch;
            }
            case 7: {
                return value * 0.013888889f * pixPerInch;
            }
            case 8: {
                return value * 0.16666667f * pixPerInch;
            }
        }
        return value;
    }

    public boolean updateTime(double curTime) throws SVGException {
        boolean changeState = super.updateTime(curTime);
        return changeState;
    }
}

