/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Font;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoader;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SVGUniverse
implements Serializable {
    public static final long serialVersionUID = 0L;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    final HashMap loadedDocs = new HashMap();
    final HashMap loadedFonts = new HashMap();
    final HashMap loadedImages = new HashMap();
    public static final String INPUTSTREAM_SCHEME = "svgSalamander";
    protected double curTime = 0.0;
    private boolean verbose = false;

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    public void clear() {
        this.loadedDocs.clear();
        this.loadedFonts.clear();
        this.loadedImages.clear();
    }

    public double getCurTime() {
        return this.curTime;
    }

    public void setCurTime(double curTime) {
        double oldTime = this.curTime;
        this.curTime = curTime;
        this.changes.firePropertyChange("curTime", new Double(oldTime), new Double(curTime));
    }

    public void updateTime() throws SVGException {
        Iterator it = this.loadedDocs.values().iterator();
        while (it.hasNext()) {
            SVGDiagram dia = (SVGDiagram)it.next();
            dia.updateTime(this.curTime);
        }
    }

    void registerFont(Font font) {
        this.loadedFonts.put(font.getFontFace().getFontFamily(), font);
    }

    public Font getDefaultFont() {
        Iterator it = this.loadedFonts.values().iterator();
        if (it.hasNext()) {
            return (Font)it.next();
        }
        return null;
    }

    public Font getFont(String fontName) {
        return (Font)this.loadedFonts.get(fontName);
    }

    void registerImage(URL imageURL) {
        if (this.loadedImages.containsKey(imageURL)) {
            return;
        }
        try {
            BufferedImage img = ImageIO.read(imageURL);
            SoftReference<BufferedImage> ref = new SoftReference<BufferedImage>(img);
            this.loadedImages.put(imageURL, ref);
        }
        catch (Exception e) {
            System.err.println("Could not load image: " + imageURL);
            e.printStackTrace();
        }
    }

    BufferedImage getImage(URL imageURL) {
        SoftReference<BufferedImage> ref = (SoftReference<BufferedImage>)this.loadedImages.get(imageURL);
        if (ref == null) {
            return null;
        }
        BufferedImage img = (BufferedImage)ref.get();
        if (img == null) {
            try {
                img = ImageIO.read(imageURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ref = new SoftReference<BufferedImage>(img);
            this.loadedImages.put(imageURL, ref);
        }
        return img;
    }

    public SVGElement getElement(URI path) {
        return this.getElement(path, true);
    }

    public SVGElement getElement(URL path) {
        try {
            URI uri = new URI(path.toString());
            return this.getElement(uri, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SVGElement getElement(URI path, boolean loadIfAbsent) {
        try {
            URI xmlBase = new URI(path.getScheme(), path.getSchemeSpecificPart(), null);
            SVGDiagram dia = (SVGDiagram)this.loadedDocs.get(xmlBase);
            if (dia == null && loadIfAbsent) {
                URL url = xmlBase.toURL();
                this.loadSVG(url);
                dia = (SVGDiagram)this.loadedDocs.get(xmlBase);
                if (dia == null) {
                    return null;
                }
            }
            return dia.getElement(path.getFragment());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SVGDiagram getDiagram(URI xmlBase) {
        return this.getDiagram(xmlBase, true);
    }

    public SVGDiagram getDiagram(URI xmlBase, boolean loadIfAbsent) {
        SVGDiagram dia = (SVGDiagram)this.loadedDocs.get(xmlBase);
        if (dia != null || !loadIfAbsent) {
            return dia;
        }
        try {
            URL url = xmlBase.toURL();
            this.loadSVG(url);
            dia = (SVGDiagram)this.loadedDocs.get(xmlBase);
            return dia;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public URI loadSVG(URL docRoot) {
        try {
            URI uri = new URI(docRoot.toString());
            if (this.loadedDocs.containsKey(uri)) {
                return uri;
            }
            InputStream is = docRoot.openStream();
            return this.loadSVG(uri, new InputStreamReader(is));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public URI loadSVG(InputStream is, String name) {
        return this.loadSVG(new InputStreamReader(is), name);
    }

    public URI loadSVG(Reader reader, String name) {
        URI uri = this.getStreamBuiltURI(name);
        if (uri == null) {
            return null;
        }
        if (this.loadedDocs.containsKey(uri)) {
            return uri;
        }
        return this.loadSVG(uri, reader);
    }

    public URI getStreamBuiltURI(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (name.charAt(0) != '/') {
            name = '/' + name;
        }
        try {
            return new URI(INPUTSTREAM_SCHEME, name, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected URI loadSVG(URI xmlBase, Reader is) {
        SVGLoader handler = new SVGLoader(xmlBase, this, this.verbose);
        this.loadedDocs.put(xmlBase, handler.getLoadedDiagram());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(new BufferedReader(is)), (DefaultHandler)handler);
            return xmlBase;
        }
        catch (SAXParseException sex) {
            System.err.println("Error processing " + xmlBase);
            System.err.println(sex.getMessage());
            this.loadedDocs.remove(xmlBase);
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void main(String[] argv) {
        try {
            URL url = new URL(INPUTSTREAM_SCHEME, "localhost", -1, "abc.svg", new URLStreamHandler(){

                protected URLConnection openConnection(URL u) {
                    return null;
                }
            });
            URI uriA = new URI(INPUTSTREAM_SCHEME, "/names/mySpecialName", null);
            System.err.println(uriA.toString());
            System.err.println(uriA.getScheme());
            URI uriB = uriA.resolve("#begin");
            System.err.println(uriB.toString());
            URI uriC = uriA.resolve("tree#boing");
            System.err.println(uriC.toString());
            uriC = uriA.resolve("../tree#boing");
            System.err.println(uriC.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

