/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.FillElement;
import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.xml.StyleAttribute;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URI;

public abstract class ShapeElement
extends RenderableElement {
    protected float strokeWidthScalar = 1.0f;

    public abstract void render(Graphics2D var1) throws SVGException;

    protected void renderShape(Graphics2D g, Shape shape) throws SVGException {
        StyleAttribute styleAttrib = new StyleAttribute();
        if (this.getStyle(styleAttrib.setName("visibility")) && !styleAttrib.getStringValue().equals("visible")) {
            return;
        }
        if (this.getStyle(styleAttrib.setName("display")) && styleAttrib.getStringValue().equals("none")) {
            return;
        }
        Paint fillPaint = Color.black;
        if (this.getStyle(styleAttrib.setName("fill"))) {
            if (styleAttrib.getStringValue().equals("none")) {
                fillPaint = null;
            } else {
                URI uri;
                fillPaint = styleAttrib.getColorValue();
                if (fillPaint == null && (uri = styleAttrib.getURIValue(this.getXMLBase())) != null) {
                    Rectangle2D bounds = shape.getBounds2D();
                    AffineTransform xform = g.getTransform();
                    SVGElement ele = this.diagram.getUniverse().getElement(uri);
                    fillPaint = ((FillElement)ele).getPaint(bounds, xform);
                }
            }
        }
        float opacity = 1.0f;
        if (this.getStyle(styleAttrib.setName("opacity"))) {
            opacity = styleAttrib.getRatioValue();
        }
        float fillOpacity = opacity;
        if (this.getStyle(styleAttrib.setName("fill-opacity"))) {
            fillOpacity *= styleAttrib.getRatioValue();
        }
        Paint strokePaint = null;
        if (this.getStyle(styleAttrib.setName("stroke"))) {
            if (styleAttrib.getStringValue().equals("none")) {
                strokePaint = null;
            } else {
                URI uri;
                strokePaint = styleAttrib.getColorValue();
                if (strokePaint == null && (uri = styleAttrib.getURIValue(this.getXMLBase())) != null) {
                    Rectangle2D bounds = shape.getBounds2D();
                    AffineTransform xform = g.getTransform();
                    SVGElement ele = this.diagram.getUniverse().getElement(uri);
                    strokePaint = ((FillElement)ele).getPaint(bounds, xform);
                }
            }
        }
        float[] strokeDashArray = null;
        if (this.getStyle(styleAttrib.setName("stroke-dasharray")) && (strokeDashArray = styleAttrib.getFloatList()).length == 0) {
            strokeDashArray = null;
        }
        float strokeDashOffset = 0.0f;
        if (this.getStyle(styleAttrib.setName("stroke-dashoffset"))) {
            strokeDashOffset = styleAttrib.getFloatValue();
        }
        int strokeLinecap = 0;
        if (this.getStyle(styleAttrib.setName("stroke-linecap"))) {
            String val = styleAttrib.getStringValue();
            if (val.equals("round")) {
                strokeLinecap = 1;
            } else if (val.equals("square")) {
                strokeLinecap = 2;
            }
        }
        int strokeLinejoin = 0;
        if (this.getStyle(styleAttrib.setName("stroke-linejoin"))) {
            String val = styleAttrib.getStringValue();
            if (val.equals("round")) {
                strokeLinecap = 1;
            } else if (val.equals("bevel")) {
                strokeLinecap = 2;
            }
        }
        float strokeMiterLimit = 4.0f;
        if (this.getStyle(styleAttrib.setName("stroke-miterlimit"))) {
            strokeMiterLimit = styleAttrib.getFloatValue();
        }
        float strokeOpacity = opacity;
        if (this.getStyle(styleAttrib.setName("stroke-opacity"))) {
            strokeOpacity *= styleAttrib.getRatioValue();
        }
        float strokeWidth = 1.0f;
        if (this.getStyle(styleAttrib.setName("stroke-width"))) {
            strokeWidth = styleAttrib.getFloatValue();
        }
        strokeWidth *= this.strokeWidthScalar;
        if (fillPaint != null && fillOpacity != 0.0f) {
            Composite cachedComposite = null;
            cachedComposite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, fillOpacity));
            g.setPaint(fillPaint);
            g.fill(shape);
            if (cachedComposite != null) {
                g.setComposite(cachedComposite);
            }
        }
        if (strokePaint != null && strokeOpacity != 0.0f) {
            BasicStroke stroke = strokeDashArray == null ? new BasicStroke(strokeWidth, strokeLinecap, strokeLinejoin, strokeMiterLimit) : new BasicStroke(strokeWidth, strokeLinecap, strokeLinejoin, strokeMiterLimit, strokeDashArray, strokeDashOffset);
            Shape strokeShape = stroke.createStrokedShape(shape);
            Composite cachedComposite = null;
            if (strokeOpacity != 1.0f) {
                cachedComposite = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, strokeOpacity));
            }
            g.setPaint(strokePaint);
            g.fill(strokeShape);
            if (cachedComposite != null) {
                g.setComposite(cachedComposite);
            }
        }
    }

    public abstract Shape getShape();

    protected Rectangle2D includeStrokeInBounds(Rectangle2D rect) throws SVGException {
        StyleAttribute styleAttrib = new StyleAttribute();
        if (!this.getStyle(styleAttrib.setName("stroke"))) {
            return rect;
        }
        double strokeWidth = 1.0;
        if (this.getStyle(styleAttrib.setName("stroke-width"))) {
            strokeWidth = styleAttrib.getDoubleValue();
        }
        rect.setRect(rect.getX() - strokeWidth / 2.0, rect.getY() - strokeWidth / 2.0, rect.getWidth() + strokeWidth, rect.getHeight() + strokeWidth);
        return rect;
    }
}

