/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Font;
import com.kitfox.svg.FontFace;
import com.kitfox.svg.MissingGlyph;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.Tspan;
import com.kitfox.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Text
extends ShapeElement {
    float x = 0.0f;
    float y = 0.0f;
    AffineTransform transform = null;
    String fontFamily;
    float fontSize;
    LinkedList content = new LinkedList();
    Shape textShape;
    public static final int TXAN_START = 0;
    public static final int TXAN_MIDDLE = 1;
    public static final int TXAN_END = 2;
    int textAnchor = 0;

    public void appendText(String text) {
        this.content.addLast(text);
    }

    public void appendTspan(Tspan tspan) {
        this.content.addLast(tspan);
    }

    public void rebuild() throws SVGException {
        this.build();
    }

    public List getContent() {
        return this.content;
    }

    public void loaderAddChild(SVGLoaderHelper helper, SVGElement child) throws SVGElementException {
        super.loaderAddChild(helper, child);
        this.content.addLast(child);
    }

    public void loaderAddText(SVGLoaderHelper helper, String text) {
        Matcher matchWs = Pattern.compile("\\s*").matcher(text);
        if (!matchWs.matches()) {
            this.content.addLast(text);
        }
    }

    protected void build() throws SVGException {
        String s;
        super.build();
        StyleAttribute sty = new StyleAttribute();
        if (this.getPres(sty.setName("x"))) {
            this.x = sty.getFloatValue();
        }
        if (this.getPres(sty.setName("y"))) {
            this.y = sty.getFloatValue();
        }
        this.fontFamily = this.getStyle(sty.setName("font-family")) ? sty.getStringValue() : "Sans Serif";
        this.fontSize = this.getStyle(sty.setName("font-size")) ? sty.getFloatValue() : 12.0f;
        this.textAnchor = this.getStyle(sty.setName("text-anchor")) ? ((s = sty.getStringValue()).equals("middle") ? 1 : (s.equals("end") ? 2 : 0)) : 0;
        this.buildFont();
    }

    protected void buildFont() throws SVGException {
        Font font = this.diagram.getUniverse().getFont(this.fontFamily);
        if (font == null) {
            java.awt.Font sysFont = new java.awt.Font(this.fontFamily, 0, (int)this.fontSize);
            this.buildSysFont(sysFont);
            return;
        }
        GeneralPath textPath = new GeneralPath();
        this.textShape = textPath;
        float cursorX = this.x;
        float cursorY = this.y;
        FontFace fontFace = font.getFontFace();
        int ascent = fontFace.getAscent();
        float fontScale = this.fontSize / (float)ascent;
        AffineTransform xform = new AffineTransform();
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof String) {
                String text = (String)obj;
                this.strokeWidthScalar = 1.0f / fontScale;
                for (int i = 0; i < text.length(); ++i) {
                    xform.setToIdentity();
                    xform.setToTranslation(cursorX, cursorY);
                    xform.scale(fontScale, fontScale);
                    String unicode = text.substring(i, i + 1);
                    MissingGlyph glyph = font.getGlyph(unicode);
                    Shape path = glyph.getPath();
                    if (path != null) {
                        path = xform.createTransformedShape(path);
                        textPath.append(path, false);
                    }
                    cursorX += fontScale * (float)glyph.getHorizAdvX();
                }
                this.strokeWidthScalar = 1.0f;
                continue;
            }
            if (!(obj instanceof Tspan)) continue;
            Tspan tspan = (Tspan)obj;
            xform.setToIdentity();
            xform.setToTranslation(cursorX, cursorY);
            xform.scale(fontScale, fontScale);
            Shape tspanShape = tspan.getShape();
            tspanShape = xform.createTransformedShape(tspanShape);
            textPath.append(tspanShape, false);
        }
        switch (this.textAnchor) {
            case 1: {
                AffineTransform at = new AffineTransform();
                at.translate(-textPath.getBounds2D().getWidth() / 2.0, 0.0);
                textPath.transform(at);
                break;
            }
            case 2: {
                AffineTransform at = new AffineTransform();
                at.translate(-textPath.getBounds2D().getWidth(), 0.0);
                textPath.transform(at);
                break;
            }
        }
    }

    private void buildSysFont(java.awt.Font font) throws SVGException {
        GeneralPath textPath = new GeneralPath();
        this.textShape = textPath;
        float cursorX = this.x;
        float cursorY = this.y;
        FontRenderContext frc = new FontRenderContext(null, true, true);
        AffineTransform xform = new AffineTransform();
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof String) {
                String text = (String)obj;
                Shape textShape = font.createGlyphVector(frc, text).getOutline(cursorX, cursorY);
                textPath.append(textShape, false);
                Rectangle2D rect = font.getStringBounds(text, frc);
                cursorX += (float)rect.getWidth();
                continue;
            }
            if (!(obj instanceof Tspan)) continue;
            Tspan tspan = (Tspan)obj;
            tspan.setCursorX(cursorX);
            tspan.setCursorY(cursorY);
            tspan.addShape(textPath);
            cursorX = tspan.getCursorX();
            cursorY = tspan.getCursorY();
        }
        switch (this.textAnchor) {
            case 1: {
                AffineTransform at = new AffineTransform();
                at.translate(-textPath.getBounds2D().getWidth() / 2.0, 0.0);
                textPath.transform(at);
                break;
            }
            case 2: {
                AffineTransform at = new AffineTransform();
                at.translate(-textPath.getBounds2D().getWidth(), 0.0);
                textPath.transform(at);
                break;
            }
        }
    }

    public void render(Graphics2D g) throws SVGException {
        this.beginLayer(g);
        this.renderShape(g, this.textShape);
        this.finishLayer(g);
    }

    public Shape getShape() {
        return this.shapeToParent(this.textShape);
    }

    public Rectangle2D getBoundingBox() throws SVGException {
        return this.boundsToParent(this.includeStrokeInBounds(this.textShape.getBounds2D()));
    }

    public boolean updateTime(double curTime) throws SVGException {
        float newVal;
        boolean changeState = super.updateTime(curTime);
        StyleAttribute sty = new StyleAttribute();
        boolean shapeChange = false;
        if (this.getPres(sty.setName("x")) && (newVal = sty.getFloatValue()) != this.x) {
            this.x = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("y")) && (newVal = sty.getFloatValue()) != this.y) {
            this.y = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("font-family")) && !(newVal = sty.getStringValue()).equals(this.fontFamily)) {
            this.fontFamily = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("font-size")) && (newVal = sty.getFloatValue()) != this.fontSize) {
            this.fontSize = newVal;
            shapeChange = true;
        }
        if (shapeChange) {
            this.buildFont();
            return true;
        }
        return changeState;
    }
}

