/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.ShapeElement;
import com.kitfox.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URI;

public class Use
extends ShapeElement {
    float x = 0.0f;
    float y = 0.0f;
    float width = 1.0f;
    float height = 1.0f;
    SVGElement href = null;
    AffineTransform refXform;

    protected void build() throws SVGException {
        super.build();
        StyleAttribute sty = new StyleAttribute();
        if (this.getPres(sty.setName("x"))) {
            this.x = sty.getFloatValue();
        }
        if (this.getPres(sty.setName("y"))) {
            this.y = sty.getFloatValue();
        }
        if (this.getPres(sty.setName("width"))) {
            this.width = sty.getFloatValue();
        }
        if (this.getPres(sty.setName("height"))) {
            this.height = sty.getFloatValue();
        }
        if (this.getPres(sty.setName("xlink:href"))) {
            URI src = sty.getURIValue(this.getXMLBase());
            this.href = this.diagram.getUniverse().getElement(src);
        }
        this.refXform = new AffineTransform();
        this.refXform.translate(this.x, this.y);
        this.refXform.scale(this.width, this.height);
    }

    public void render(Graphics2D g) throws SVGException {
        this.beginLayer(g);
        AffineTransform oldXform = g.getTransform();
        g.transform(this.refXform);
        if (this.href == null || !(this.href instanceof RenderableElement)) {
            return;
        }
        ((RenderableElement)this.href).render(g);
        g.setTransform(oldXform);
        this.finishLayer(g);
    }

    public Shape getShape() {
        if (this.href instanceof ShapeElement) {
            Shape shape = ((ShapeElement)this.href).getShape();
            shape = this.refXform.createTransformedShape(shape);
            shape = this.shapeToParent(shape);
            return shape;
        }
        return null;
    }

    public Rectangle2D getBoundingBox() throws SVGException {
        if (this.href instanceof ShapeElement) {
            Rectangle2D bounds = ((ShapeElement)this.href).getBoundingBox();
            bounds = this.refXform.createTransformedShape(bounds).getBounds2D();
            bounds = this.boundsToParent(bounds);
            return bounds;
        }
        return null;
    }

    public boolean updateTime(double curTime) throws SVGException {
        float newVal;
        boolean changeState = super.updateTime(curTime);
        StyleAttribute sty = new StyleAttribute();
        boolean shapeChange = false;
        if (this.getPres(sty.setName("x")) && (newVal = sty.getFloatValue()) != this.x) {
            this.x = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("y")) && (newVal = sty.getFloatValue()) != this.y) {
            this.y = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("width")) && (newVal = sty.getFloatValue()) != this.width) {
            this.width = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("height")) && (newVal = sty.getFloatValue()) != this.height) {
            this.height = newVal;
            shapeChange = true;
        }
        if (this.getPres(sty.setName("xlink:href"))) {
            URI src = sty.getURIValue(this.getXMLBase());
            SVGElement newVal2 = this.diagram.getUniverse().getElement(src);
            if (newVal2 != this.href) {
                this.href = newVal2;
                shapeChange = true;
            }
        }
        if (shapeChange) {
            this.refXform.setToTranslation(this.x, this.y);
            this.refXform.scale(this.width, this.height);
            return true;
        }
        return changeState;
    }
}

