/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.animation;

import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.animation.AnimationElement;
import com.kitfox.svg.animation.AnimationTimeEval;
import com.kitfox.svg.animation.TimeBase;
import java.io.StringReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AnimateBase
extends AnimationElement {
    protected double repeatCount = Double.NaN;
    protected TimeBase repeatDur;

    public void evalParametric(AnimationTimeEval state, double curTime) {
        this.evalParametric(state, curTime, this.repeatCount, this.repeatDur == null ? Double.NaN : this.repeatDur.evalTime());
    }

    public void loaderStartElement(SVGLoaderHelper helper, Attributes attrs, SVGElement parent) throws SAXException {
        super.loaderStartElement(helper, attrs, parent);
        String repeatDurTime = attrs.getValue("repeatDur");
        try {
            if (repeatDurTime != null) {
                helper.animTimeParser.ReInit(new StringReader(repeatDurTime));
                this.repeatDur = helper.animTimeParser.Expr();
                this.repeatDur.setParentElement(this);
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        String strn = attrs.getValue("repeatCount");
        try {
            this.repeatCount = Double.parseDouble(strn);
        }
        catch (Exception e) {
            this.repeatCount = Double.NaN;
        }
    }
}

