/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.animation;

import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.animation.AnimateXform;
import com.kitfox.xml.XMLParseUtil;
import java.awt.geom.AffineTransform;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AnimateTransform
extends AnimateXform {
    protected double[] fromValue;
    protected double[] toValue;
    public static final int AT_REPLACE = 0;
    public static final int AT_SUM = 1;
    protected int additive = 0;
    public static final int TR_TRANSLATE = 0;
    public static final int TR_ROTATE = 1;
    public static final int TR_SCALE = 2;
    public static final int TR_SKEWY = 3;
    public static final int TR_SKEWX = 4;
    public static final int TR_INVALID = 5;
    protected int xformType = 5;

    public void loaderStartElement(SVGLoaderHelper helper, Attributes attrs, SVGElement parent) throws SAXException {
        super.loaderStartElement(helper, attrs, parent);
        String type = attrs.getValue("type").toLowerCase();
        if (type.equals("translate")) {
            this.xformType = 0;
        }
        if (type.equals("rotate")) {
            this.xformType = 1;
        }
        if (type.equals("scale")) {
            this.xformType = 2;
        }
        if (type.equals("skewx")) {
            this.xformType = 4;
        }
        if (type.equals("skewy")) {
            this.xformType = 3;
        }
        String strn = attrs.getValue("from");
        this.fromValue = XMLParseUtil.parseDoubleList(strn);
        this.fromValue = this.validate(this.fromValue);
        strn = attrs.getValue("to");
        this.toValue = XMLParseUtil.parseDoubleList(strn);
        this.toValue = this.validate(this.toValue);
        String additive = attrs.getValue("additive");
        if (additive != null && additive.equals("sum")) {
            this.additive = 1;
        }
    }

    private double[] validate(double[] paramList) {
        switch (this.xformType) {
            case 2: {
                if (paramList.length != 1) break;
                double[] tmp = paramList;
                paramList = new double[2];
                paramList[0] = paramList[1] = tmp[0];
            }
        }
        return paramList;
    }

    public AffineTransform eval(AffineTransform xform, double interp) {
        switch (this.xformType) {
            case 0: {
                double x = (1.0 - interp) * this.fromValue[0] + interp * this.toValue[0];
                double y = (1.0 - interp) * this.fromValue[1] + interp * this.toValue[1];
                xform.setToTranslation(x, y);
                break;
            }
            case 1: {
                double x1 = this.fromValue.length == 3 ? this.fromValue[1] : 0.0;
                double y1 = this.fromValue.length == 3 ? this.fromValue[2] : 0.0;
                double x2 = this.toValue.length == 3 ? this.toValue[1] : 0.0;
                double y2 = this.toValue.length == 3 ? this.toValue[2] : 0.0;
                double theta = (1.0 - interp) * this.fromValue[0] + interp * this.toValue[0];
                double x = (1.0 - interp) * x1 + interp * x2;
                double y = (1.0 - interp) * y1 + interp * y2;
                xform.setToRotation(Math.toRadians(theta), x, y);
                break;
            }
            case 2: {
                double x = (1.0 - interp) * this.fromValue[0] + interp * this.toValue[0];
                double y = (1.0 - interp) * this.fromValue[1] + interp * this.toValue[1];
                xform.setToScale(x, y);
                break;
            }
            case 4: {
                double x = (1.0 - interp) * this.fromValue[0] + interp * this.toValue[0];
                xform.setToShear(Math.toRadians(x), 0.0);
                break;
            }
            case 3: {
                double y = (1.0 - interp) * this.fromValue[0] + interp * this.toValue[0];
                xform.setToShear(0.0, Math.toRadians(y));
                break;
            }
            default: {
                xform.setToIdentity();
            }
        }
        return xform;
    }
}

