/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.app;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGDisplayPanel;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.app.VersionDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class SVGViewer
extends JFrame {
    public static final long serialVersionUID = 1L;
    SVGDisplayPanel svgDisplayPanel = new SVGDisplayPanel();
    final JFileChooser fileChooser = new JFileChooser();
    private JCheckBoxMenuItem CheckBoxMenuItem_anonInputStream;
    private JCheckBoxMenuItem cmCheck_verbose;
    private JMenuItem cm_800x600;
    private JMenuItem cm_about;
    private JMenuItem cm_load;
    private JMenuBar jMenuBar1;
    private JMenu menu_file;
    private JMenu menu_help;
    private JMenu menu_window;
    private JScrollPane scrollPane_svgArea;

    public SVGViewer() {
        this.fileChooser.setFileFilter(new FileFilter(){
            final Matcher matchLevelFile = Pattern.compile(".*\\.svg").matcher("");

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                this.matchLevelFile.reset(file.getName());
                return this.matchLevelFile.matches();
            }

            public String getDescription() {
                return "SVG file (*.svg)";
            }
        });
        this.initComponents();
        this.setSize(800, 600);
        this.svgDisplayPanel.setBgColor(Color.white);
        this.scrollPane_svgArea.setViewportView(this.svgDisplayPanel);
    }

    private void initComponents() {
        this.scrollPane_svgArea = new JScrollPane();
        this.jMenuBar1 = new JMenuBar();
        this.menu_file = new JMenu();
        this.cm_load = new JMenuItem();
        this.menu_window = new JMenu();
        this.cm_800x600 = new JMenuItem();
        this.CheckBoxMenuItem_anonInputStream = new JCheckBoxMenuItem();
        this.cmCheck_verbose = new JCheckBoxMenuItem();
        this.menu_help = new JMenu();
        this.cm_about = new JMenuItem();
        this.setTitle("SVG Viewer - Salamander Project");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SVGViewer.this.exitForm(evt);
            }
        });
        this.getContentPane().add((Component)this.scrollPane_svgArea, "Center");
        this.menu_file.setMnemonic('f');
        this.menu_file.setText("File");
        this.cm_load.setMnemonic('l');
        this.cm_load.setText("Load");
        this.cm_load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SVGViewer.this.cm_loadActionPerformed(evt);
            }
        });
        this.menu_file.add(this.cm_load);
        this.jMenuBar1.add(this.menu_file);
        this.menu_window.setText("Window");
        this.cm_800x600.setText("800 x 600");
        this.cm_800x600.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SVGViewer.this.cm_800x600ActionPerformed(evt);
            }
        });
        this.menu_window.add(this.cm_800x600);
        this.CheckBoxMenuItem_anonInputStream.setText("Anonymous Input Stream");
        this.menu_window.add(this.CheckBoxMenuItem_anonInputStream);
        this.cmCheck_verbose.setText("Verbose");
        this.cmCheck_verbose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SVGViewer.this.cmCheck_verboseActionPerformed(evt);
            }
        });
        this.menu_window.add(this.cmCheck_verbose);
        this.jMenuBar1.add(this.menu_window);
        this.menu_help.setText("Help");
        this.cm_about.setText("About...");
        this.cm_about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SVGViewer.this.cm_aboutActionPerformed(evt);
            }
        });
        this.menu_help.add(this.cm_about);
        this.jMenuBar1.add(this.menu_help);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void cmCheck_verboseActionPerformed(ActionEvent evt) {
        SVGCache.getSVGUniverse().setVerbose(this.cmCheck_verbose.isSelected());
    }

    private void cm_aboutActionPerformed(ActionEvent evt) {
        VersionDialog dlg = new VersionDialog((Frame)this, true, this.cmCheck_verbose.isSelected());
        dlg.setVisible(true);
    }

    private void cm_800x600ActionPerformed(ActionEvent evt) {
        this.setSize(800, 600);
    }

    private void cm_loadActionPerformed(ActionEvent evt) {
        block8: {
            boolean verbose = this.cmCheck_verbose.isSelected();
            try {
                int retVal = this.fileChooser.showOpenDialog(this);
                if (retVal != 0) break block8;
                File chosenFile = this.fileChooser.getSelectedFile();
                URL url = chosenFile.toURL();
                SVGUniverse universe = SVGCache.getSVGUniverse();
                SVGDiagram diagram = null;
                if (!this.CheckBoxMenuItem_anonInputStream.isSelected()) {
                    URI uri = universe.loadSVG(url);
                    if (verbose) {
                        System.err.println("Loading document " + uri.toString());
                    }
                    diagram = universe.getDiagram(uri);
                } else {
                    try {
                        InputStream is = url.openStream();
                        URI uri = universe.loadSVG(is, "defaultName");
                        if (verbose) {
                            System.err.println("Loading document " + uri.toString());
                        }
                        diagram = universe.getDiagram(uri);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.svgDisplayPanel.setDiagram(diagram);
                this.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        new SVGViewer().setVisible(true);
    }
}

