/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.app.ant;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SVGToImageAntTask
extends Task {
    private Vector filesets = new Vector();
    boolean verbose = false;
    File destDir;
    private String format = "png";

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void execute() {
        if (this.verbose) {
            this.log("Building SVG images");
        }
        Iterator it = this.filesets.iterator();
        while (it.hasNext()) {
            FileSet fs = (FileSet)it.next();
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            String[] files = scanner.getIncludedFiles();
            try {
                File basedir = scanner.getBasedir();
                if (this.verbose) {
                    this.log("Scaning " + basedir);
                }
                for (int i = 0; i < files.length; ++i) {
                    this.translate(basedir, files[i]);
                }
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private void translate(File baseDir, String shortName) throws BuildException {
        File outFile;
        Matcher matchName;
        File source = new File(baseDir, shortName);
        if (this.verbose) {
            this.log("Reading file: " + source);
        }
        if ((matchName = Pattern.compile("(.*)\\.svg", 2).matcher(shortName)).matches()) {
            shortName = matchName.group(1);
        }
        shortName = shortName + "." + this.format;
        SVGIcon icon = new SVGIcon();
        icon.setSvgURI(source.toURI());
        icon.setAntiAlias(true);
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        File file = outFile = this.destDir == null ? new File(baseDir, shortName) : new File(this.destDir, shortName);
        if (this.verbose) {
            this.log("Writing file: " + outFile);
        }
        try {
            ImageIO.write((RenderedImage)image, this.format, outFile);
        }
        catch (IOException e) {
            this.log("Error writing image: " + e.getMessage());
            throw new BuildException((Throwable)e);
        }
        SVGCache.getSVGUniverse().clear();
    }
}

