/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.app.beans;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URI;
import javax.swing.Icon;

public class SVGIcon
implements Icon {
    public static final long serialVersionUID = 1L;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    SVGUniverse svgUniverse = SVGCache.getSVGUniverse();
    private boolean antiAlias;
    private boolean clipToViewbox;
    URI svgURI;
    private boolean scaleToFit;
    AffineTransform scaleXform = new AffineTransform();
    Dimension preferredSize = new Dimension(100, 100);

    public void addPropertyChangeListener(PropertyChangeListener p) {
        this.changes.addPropertyChangeListener(p);
    }

    public void removePropertyChangeListener(PropertyChangeListener p) {
        this.changes.removePropertyChangeListener(p);
    }

    public int getIconHeight() {
        SVGDiagram diagram = this.svgUniverse.getDiagram(this.svgURI);
        if (diagram == null) {
            return 0;
        }
        return (int)diagram.getHeight();
    }

    public int getIconWidth() {
        SVGDiagram diagram = this.svgUniverse.getDiagram(this.svgURI);
        if (diagram == null) {
            return 0;
        }
        return (int)diagram.getWidth();
    }

    public void paintIcon(Component comp, Graphics gg, int x, int y) {
        Graphics2D g = (Graphics2D)gg;
        Object oldAliasHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        SVGDiagram diagram = this.svgUniverse.getDiagram(this.svgURI);
        if (diagram == null) {
            return;
        }
        g.translate(x, y);
        diagram.setIgnoringClipHeuristic(this.clipToViewbox);
        if (this.clipToViewbox) {
            g.setClip(new Rectangle2D.Float(0.0f, 0.0f, diagram.getWidth(), diagram.getHeight()));
        }
        if (!this.scaleToFit) {
            try {
                diagram.render(g);
                g.translate(-x, -y);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasHint);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        int width = this.preferredSize.width;
        int height = this.preferredSize.height;
        if (width == 0 || height == 0) {
            return;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double();
        diagram.getViewRect(rect);
        this.scaleXform.setToScale((double)width / rect.width, (double)height / rect.height);
        AffineTransform oldXform = g.getTransform();
        g.transform(this.scaleXform);
        try {
            diagram.render(g);
        }
        catch (SVGException e) {
            throw new RuntimeException(e);
        }
        g.setTransform(oldXform);
        g.translate(-x, -y);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasHint);
    }

    public SVGUniverse getSvgUniverse() {
        return this.svgUniverse;
    }

    public void setSvgUniverse(SVGUniverse svgUniverse) {
        SVGUniverse old = this.svgUniverse;
        this.svgUniverse = svgUniverse;
        this.changes.firePropertyChange("svgUniverse", old, svgUniverse);
    }

    public URI getSvgURI() {
        return this.svgURI;
    }

    public void setSvgURI(URI svgURI) {
        URI old = this.svgURI;
        this.svgURI = svgURI;
        this.changes.firePropertyChange("svgURI", old, svgURI);
    }

    public void setSvgResourcePath(String resourcePath) {
        URI old = this.svgURI;
        try {
            this.svgURI = new URI(this.getClass().getResource(resourcePath).toString());
            this.changes.firePropertyChange("svgURI", old, this.svgURI);
        }
        catch (Exception e) {
            this.svgURI = old;
        }
    }

    public boolean isScaleToFit() {
        return this.scaleToFit;
    }

    public void setScaleToFit(boolean scaleToFit) {
        boolean old = this.scaleToFit;
        this.scaleToFit = scaleToFit;
        this.changes.firePropertyChange("scaleToFit", old, scaleToFit);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    public void setPreferredSize(Dimension preferredSize) {
        Dimension old = this.preferredSize;
        this.preferredSize = preferredSize;
        this.changes.firePropertyChange("preferredSize", old, preferredSize);
    }

    public boolean getUseAntiAlias() {
        return this.getAntiAlias();
    }

    public void setUseAntiAlias(boolean antiAlias) {
        this.setAntiAlias(antiAlias);
    }

    public boolean getAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean antiAlias) {
        boolean old = this.antiAlias;
        this.antiAlias = antiAlias;
        this.changes.firePropertyChange("antiAlias", old, antiAlias);
    }

    public boolean isClipToViewbox() {
        return this.clipToViewbox;
    }

    public void setClipToViewbox(boolean clipToViewbox) {
        this.clipToViewbox = clipToViewbox;
    }
}

