/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.example;

import com.kitfox.svg.Circle;
import com.kitfox.svg.Group;
import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.Text;
import com.kitfox.svg.Tspan;
import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.util.LinkedList;
import javax.swing.JPanel;

class DynamicIconPanel
extends JPanel {
    public static final long serialVersionUID = 0L;
    final SVGIcon icon;
    URI uri;
    LinkedList extraCircles = new LinkedList();

    public DynamicIconPanel() {
        StringReader reader = new StringReader(this.makeDynamicSVG());
        this.uri = SVGCache.getSVGUniverse().loadSVG(reader, "myImage");
        this.icon = new SVGIcon();
        this.icon.setAntiAlias(true);
        this.icon.setSvgURI(this.uri);
        this.setPreferredSize(new Dimension(400, 400));
    }

    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        this.icon.paintIcon(this, g, 0, 0);
    }

    private String makeDynamicSVG() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<svg width=\"400\" height=\"400\" style=\"fill:none;stroke-width:16\">");
        pw.println("    <circle id=\"bigCircle\" cx=\"200\" cy=\"200\" r=\"200\" style=\"stroke:blue\"/>");
        pw.println("    <g id=\"extraCircleGroup\" style=\"stroke-width:4;fill:green\"/>");
        pw.println("    <text id=\"userTextParent\" x=\"0\" y=\"40\" style=\"font-size:40;stroke:none;fill:red\">");
        pw.println("        <tspan id=\"userText\">Hello!</tspan>");
        pw.println("    </text>");
        pw.println("</svg>");
        pw.close();
        return sw.toString();
    }

    public void setCircleForeground(Color color) {
        SVGDiagram diagram = SVGCache.getSVGUniverse().getDiagram(this.uri);
        Circle circle = (Circle)diagram.getElement("bigCircle");
        String colorStrn = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        try {
            if (!circle.hasAttribute("stroke", 0)) {
                circle.addAttribute("stroke", 0, "#" + colorStrn);
            } else {
                circle.setAttribute("stroke", 0, "#" + colorStrn);
            }
        }
        catch (SVGElementException e) {
            e.printStackTrace();
        }
    }

    public void setCircleBackground(Color color) {
        SVGDiagram diagram = SVGCache.getSVGUniverse().getDiagram(this.uri);
        Circle circle = (Circle)diagram.getElement("bigCircle");
        String colorStrn = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        try {
            if (!circle.hasAttribute("fill", 0)) {
                circle.addAttribute("fill", 0, "#" + colorStrn);
            } else {
                circle.setAttribute("fill", 0, "#" + colorStrn);
            }
        }
        catch (SVGElementException e) {
            e.printStackTrace();
        }
    }

    public void setText(String text) {
        SVGDiagram diagram = SVGCache.getSVGUniverse().getDiagram(this.uri);
        Tspan tspan = (Tspan)diagram.getElement("userText");
        tspan.setText(text);
        Text textEle = (Text)diagram.getElement("userTextParent");
        try {
            textEle.rebuild();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addCircle() {
        SVGDiagram diagram = SVGCache.getSVGUniverse().getDiagram(this.uri);
        Group group = (Group)diagram.getElement("extraCircleGroup");
        Circle circle = new Circle();
        try {
            int cx = (int)(Math.random() * 400.0);
            int cy = (int)(Math.random() * 400.0);
            circle.addAttribute("cx", 1, "" + cx);
            circle.addAttribute("cy", 1, "" + cy);
            circle.addAttribute("r", 1, "10");
            group.loaderAddChild(null, circle);
            group.updateTime(0.0);
            this.extraCircles.add(circle);
        }
        catch (SVGException e) {
            e.printStackTrace();
        }
    }

    public void removeCircle() {
        int size = this.extraCircles.size();
        if (size == 0) {
            return;
        }
        int idx = (int)(Math.random() * (double)size);
        Circle circle = (Circle)this.extraCircles.remove(idx);
        SVGDiagram diagram = SVGCache.getSVGUniverse().getDiagram(this.uri);
        Group group = (Group)diagram.getElement("extraCircleGroup");
        try {
            group.removeChild(circle);
        }
        catch (SVGException e) {
            e.printStackTrace();
        }
    }
}

