/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.example;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.app.beans.SVGIcon;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import javax.swing.JPanel;

class IconPanel
extends JPanel {
    public static final long serialVersionUID = 0L;
    final SVGIcon icon;

    public IconPanel() {
        StringReader reader = new StringReader(this.makeDynamicSVG());
        URI uri = SVGCache.getSVGUniverse().loadSVG(reader, "myImage");
        this.icon = new SVGIcon();
        this.icon.setSvgURI(uri);
        this.setPreferredSize(new Dimension(400, 400));
    }

    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        this.icon.paintIcon(this, g, 0, 0);
    }

    private String makeDynamicSVG() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<svg width=\"400\" height=\"400\" style=\"fill:none;stroke-width:4\">");
        pw.println("    <circle cx=\"200\" cy=\"200\" r=\"200\" style=\"stroke:blue\"/>");
        pw.println("    <circle cx=\"140\" cy=\"140\" r=\"40\" style=\"stroke:red\"/>");
        pw.println("    <circle cx=\"260\" cy=\"140\" r=\"40\" style=\"stroke:red\"/>");
        pw.println("    <polyline points=\"100 300 150 340 250 240 300 300\" style=\"stroke:red\"/>");
        pw.println("</svg>");
        pw.close();
        return sw.toString();
    }
}

