/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.xml;

import com.kitfox.xml.NumberWithUnits;
import com.kitfox.xml.XMLParseUtil;
import java.awt.Color;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StyleAttribute {
    static final Matcher matchUrl = Pattern.compile("\\s*url\\((.*)\\)\\s*").matcher("");
    static final Matcher matchFpNumUnits = Pattern.compile("\\s*([-+]?((\\d*\\.\\d+)|(\\d+))([-+]?[eE]\\d+)?)\\s*(px|cm|mm|in|pc|pt|em|ex)\\s*").matcher("");
    String name;
    String stringValue;
    boolean colorCompatable = false;
    boolean urlCompatable = false;

    public StyleAttribute() {
        this(null, null);
    }

    public StyleAttribute(String name) {
        this.name = name;
        this.stringValue = null;
    }

    public StyleAttribute(String name, String stringValue) {
        this.name = name;
        this.stringValue = stringValue;
    }

    public String getName() {
        return this.name;
    }

    public StyleAttribute setName(String name) {
        this.name = name;
        return this;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String[] getStringList() {
        return XMLParseUtil.parseStringList(this.stringValue);
    }

    public void setStringValue(String value) {
        this.stringValue = value;
    }

    public boolean getBooleanValue() {
        return this.stringValue.toLowerCase().equals("true");
    }

    public int getIntValue() {
        return XMLParseUtil.findInt(this.stringValue);
    }

    public int[] getIntList() {
        return XMLParseUtil.parseIntList(this.stringValue);
    }

    public double getDoubleValue() {
        return XMLParseUtil.findDouble(this.stringValue);
    }

    public double[] getDoubleList() {
        return XMLParseUtil.parseDoubleList(this.stringValue);
    }

    public float getFloatValue() {
        return XMLParseUtil.findFloat(this.stringValue);
    }

    public float[] getFloatList() {
        return XMLParseUtil.parseFloatList(this.stringValue);
    }

    public float getRatioValue() {
        return (float)XMLParseUtil.parseRatio(this.stringValue);
    }

    public String getUnits() {
        matchFpNumUnits.reset(this.stringValue);
        if (!matchFpNumUnits.matches()) {
            return null;
        }
        return matchFpNumUnits.group(6);
    }

    public NumberWithUnits getNumberWithUnits() {
        return XMLParseUtil.parseNumberWithUnits(this.stringValue);
    }

    public Color getColorValue() {
        return XMLParseUtil.parseColor(this.stringValue);
    }

    public String parseURLFn() {
        matchUrl.reset(this.stringValue);
        if (!matchUrl.matches()) {
            return null;
        }
        return matchUrl.group(1);
    }

    public URL getURLValue(URL docRoot) {
        String fragment = this.parseURLFn();
        if (fragment == null) {
            return null;
        }
        try {
            return new URL(docRoot, fragment);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public URL getURLValue(URI docRoot) {
        String fragment = this.parseURLFn();
        if (fragment == null) {
            return null;
        }
        try {
            URI ref = docRoot.resolve(fragment);
            return ref.toURL();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public URI getURIValue() {
        return this.getURIValue(null);
    }

    public URI getURIValue(URI base) {
        try {
            String fragment = this.parseURLFn();
            if (fragment == null) {
                fragment = this.stringValue;
            }
            if (fragment == null) {
                return null;
            }
            if (Pattern.matches("[a-zA-Z]:!\\\\.*", fragment)) {
                File file = new File(fragment);
                return file.toURI();
            }
            URI uriFrag = new URI(fragment);
            if (uriFrag.isAbsolute()) {
                return uriFrag;
            }
            if (base == null) {
                return uriFrag;
            }
            return base.resolve(uriFrag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            URI uri = new URI("jar:http://www.kitfox.com/jackal/jackal.jar!/res/doc/about.svg");
            uri = uri.resolve("#myFragment");
            System.err.println(uri.toString());
            uri = new URI("http://www.kitfox.com/jackal/jackal.html");
            uri = uri.resolve("#myFragment");
            System.err.println(uri.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

