/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.runtime.test.impl;

import java.util.Comparator;
import java.util.Map;
import org.pentaho.runtime.test.RuntimeTest;

public class RuntimeTestComparator
implements Comparator<RuntimeTest> {
    private final Map<String, Integer> orderedModules;

    public RuntimeTestComparator(Map<String, Integer> orderedModules) {
        this.orderedModules = orderedModules;
    }

    private Integer nullSafeCompare(Object first, Object second) {
        if (first == null) {
            if (second == null) {
                return null;
            }
            return 1;
        }
        if (second == null) {
            return -1;
        }
        if (first.equals(second)) {
            return 0;
        }
        return null;
    }

    private int compareModuleNames(String o1Module, String o2Module) {
        Integer o2OrderNum;
        Integer result = this.nullSafeCompare(o1Module, o2Module);
        if (result != null) {
            return result;
        }
        Integer o1OrderNum = this.orderedModules.get(o1Module);
        result = this.nullSafeCompare(o1OrderNum, o2OrderNum = this.orderedModules.get(o2Module));
        if (result != null) {
            return result;
        }
        return o1Module.compareTo(o2Module);
    }

    @Override
    public int compare(RuntimeTest o1, RuntimeTest o2) {
        String o2Id;
        Integer result = this.compareModuleNames(o1.getModule(), o2.getModule());
        if (result != 0) {
            return result;
        }
        String o1Id = o1.getId();
        result = this.nullSafeCompare(o1Id, o2Id = o2.getId());
        if (result == null) {
            result = o1Id.compareTo(o2Id);
        }
        return result;
    }
}

