/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobReference;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public final class JobId
implements Serializable {
    private static final long serialVersionUID = 1225914835379688976L;
    private final String project;
    private final String job;

    public String getProject() {
        return this.project;
    }

    public String getJob() {
        return this.job;
    }

    private JobId(String project, String job) {
        this.project = project;
        this.job = job;
    }

    public static JobId of(String project, String job) {
        return new JobId((String)Preconditions.checkNotNull((Object)project), (String)Preconditions.checkNotNull((Object)job));
    }

    public static JobId of(String job) {
        return new JobId(null, (String)Preconditions.checkNotNull((Object)job));
    }

    public static JobId of() {
        return new JobId(null, UUID.randomUUID().toString());
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof JobId && Objects.equals(this.toPb(), ((JobId)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(this.project, this.job);
    }

    public String toString() {
        return this.toPb().toString();
    }

    JobId setProjectId(String projectId) {
        return this.getProject() != null ? this : JobId.of(projectId, this.getJob());
    }

    JobReference toPb() {
        return new JobReference().setProjectId(this.project).setJobId(this.job);
    }

    static JobId fromPb(JobReference jobRef) {
        return new JobId(jobRef.getProjectId(), jobRef.getJobId());
    }
}

