/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.MemberVisibilityAwareComparator;
import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.mondrian.MondrianResult;
import com.tonbeller.jpivot.mondrian.MondrianUtil;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.MemberTree;
import com.tonbeller.jpivot.olap.query.Quax;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mondrian.olap.Formula;
import mondrian.olap.Query;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.SchemaReader;
import org.apache.log4j.Logger;

public class MondrianMemberTree
extends ExtensionSupport
implements MemberTree {
    static Logger logger = Logger.getLogger(MondrianMemberTree.class);

    public MondrianMemberTree() {
        super.setId("memberTree");
    }

    @Override
    public Member[] getRootMembers(Hierarchy hier) {
        try {
            return this.internalGetRootMembers(hier);
        }
        catch (ResultLimitExceededException e) {
            logger.error(null, (Throwable)e);
            throw new MemberTree.TooManyMembersException(e);
        }
    }

    private Member[] internalGetRootMembers(Hierarchy hier) {
        MondrianQueryAdapter adapter;
        Quax quax;
        MondrianModel model = (MondrianModel)this.getModel();
        mondrian.olap.Hierarchy monHier = ((MondrianHierarchy)hier).getMonHierarchy();
        Query q = ((MondrianQueryAdapter)model.getQueryAdapter()).getMonQuery();
        SchemaReader scr = model.getSchemaReader();
        List monMembers = scr.getHierarchyRootMembers(monHier);
        ArrayList<MondrianMember> aMem = new ArrayList<MondrianMember>();
        ArrayList<MondrianMember> visibleRootMembers = new ArrayList<MondrianMember>();
        int k = monMembers.size();
        for (int i = 0; i < k; ++i) {
            mondrian.olap.Member monMember = (mondrian.olap.Member)monMembers.get(i);
            if (!this.isVisible(monMember)) continue;
            aMem.add(model.addMember(monMember));
        }
        Formula[] formulas = q.getFormulas();
        for (int i = 0; i < formulas.length; ++i) {
            MondrianMember m;
            Formula f = formulas[i];
            mondrian.olap.Member monMem = f.getMdxMember();
            if (monMem == null || !monMem.getHierarchy().equals(monHier) || !this.isVisible(monMem) || monMem.getParentMember() != null || aMem.contains(m = model.addMember(monMem))) continue;
            aMem.add(m);
        }
        MondrianResult res = model.currentResult();
        if (res != null && (quax = (adapter = (MondrianQueryAdapter)model.getQueryAdapter()).findQuax(hier.getDimension())) != null) {
            int iDim = quax.dimIdx(hier.getDimension());
            int iAx = quax.getOrdinal();
            if (adapter.isSwapAxes()) {
                iAx = (iAx + 1) % 2;
            }
            Axis axis = res.getAxes()[iAx];
            List positions = axis.getPositions();
            for (Position pos : positions) {
                Member[] posMembers = pos.getMembers();
                MondrianMember mem = (MondrianMember)posMembers[iDim];
                if (!mem.getMonMember().getHierarchy().equals(monHier) || mem.getMonMember().getParentMember() != null) continue;
                if (!visibleRootMembers.contains(mem)) {
                    visibleRootMembers.add(mem);
                }
                if (aMem.contains(mem)) continue;
                aMem.add(mem);
            }
        }
        Member[] members = aMem.toArray(new Member[0]);
        if (!visibleRootMembers.isEmpty()) {
            Arrays.sort(members, new MemberVisibilityAwareComparator(visibleRootMembers));
        }
        return members;
    }

    private boolean isVisible(mondrian.olap.Member monMember) {
        if (monMember.getName().startsWith(".")) {
            return false;
        }
        MondrianModel model = (MondrianModel)this.getModel();
        SchemaReader scr = model.getSchemaReader();
        return MondrianUtil.isVisible(scr, monMember);
    }

    @Override
    public boolean hasChildren(Member member) {
        mondrian.olap.Member monMember = ((MondrianMember)member).getMonMember();
        if (monMember.isCalculatedInQuery()) {
            return false;
        }
        if (monMember.getLevel().getChildLevel() != null) {
            if (!monMember.isCalculated()) {
                return true;
            }
            return this.getChildren(member).length != 0;
        }
        MondrianModel model = (MondrianModel)this.getModel();
        SchemaReader scr = model.getSchemaReader();
        return scr.isDrillable(monMember);
    }

    @Override
    public Member[] getChildren(Member member) {
        try {
            return this.internalGetChildren(member);
        }
        catch (ResultLimitExceededException e) {
            logger.error(null, (Throwable)e);
            throw new MemberTree.TooManyMembersException(e);
        }
    }

    private Member[] internalGetChildren(Member member) {
        mondrian.olap.Member monMember = ((MondrianMember)member).getMonMember();
        MondrianModel model = (MondrianModel)this.getModel();
        SchemaReader scr = model.getSchemaReader();
        List monChildren = scr.getMemberChildren(monMember);
        ArrayList<MondrianMember> list = new ArrayList<MondrianMember>(monChildren.size());
        for (int i = 0; i < monChildren.size(); ++i) {
            mondrian.olap.Member m = (mondrian.olap.Member)monChildren.get(i);
            if (!MondrianUtil.isVisible(scr, m)) continue;
            list.add(model.addMember(m));
        }
        Query q = ((MondrianQueryAdapter)model.getQueryAdapter()).getMonQuery();
        Formula[] formulas = q.getFormulas();
        for (int i = 0; i < formulas.length; ++i) {
            MondrianMember m;
            Formula f = formulas[i];
            mondrian.olap.Member monMem = f.getMdxMember();
            if (monMem == null || !this.isVisible(monMem) || !monMem.getDimension().equals(monMember.getDimension()) || !monMem.getHierarchy().equals(monMember.getHierarchy()) || !monMem.getParentMember().equals(monMember) || list.contains(m = model.addMember(monMem))) continue;
            list.add(m);
        }
        MondrianResult res = model.currentResult();
        ArrayList<MondrianMember> visibleChildMembers = new ArrayList<MondrianMember>();
        if (res != null) {
            MondrianQueryAdapter adapter = (MondrianQueryAdapter)model.getQueryAdapter();
            mondrian.olap.Hierarchy monHier = monMember.getHierarchy();
            Hierarchy hier = member.getLevel().getHierarchy();
            Quax quax = adapter.findQuax(hier.getDimension());
            if (quax != null) {
                int iDim = quax.dimIdx(hier.getDimension());
                int iAx = quax.getOrdinal();
                if (adapter.isSwapAxes()) {
                    iAx = (iAx + 1) % 2;
                }
                Axis axis = res.getAxes()[iAx];
                List positions = axis.getPositions();
                for (Position pos : positions) {
                    Member[] posMembers = pos.getMembers();
                    MondrianMember mem = (MondrianMember)posMembers[iDim];
                    if (mem.getMonMember().getParentMember() == null || !mem.getMonMember().getHierarchy().equals(monHier) || !mem.getMonMember().getParentMember().equals(monMember)) continue;
                    visibleChildMembers.add(mem);
                    if (list.contains(mem)) continue;
                    list.add(mem);
                }
            }
        }
        Member[] children = list.toArray(new Member[list.size()]);
        if (res != null) {
            Arrays.sort(children, new MemberVisibilityAwareComparator(visibleChildMembers));
        }
        return children;
    }

    @Override
    public Member getParent(Member member) {
        mondrian.olap.Member monMember = ((MondrianMember)member).getMonMember();
        MondrianModel model = (MondrianModel)this.getModel();
        SchemaReader scr = model.getSchemaReader();
        mondrian.olap.Member monParent = scr.getMemberParent(monMember);
        if (monParent == null) {
            return null;
        }
        MondrianMember parent = model.addMember(monParent);
        return parent;
    }
}

