/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.Extension;
import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.mondrian.MondrianAxis;
import com.tonbeller.jpivot.mondrian.MondrianDimension;
import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianMemento;
import com.tonbeller.jpivot.mondrian.MondrianOldStuff;
import com.tonbeller.jpivot.mondrian.MondrianPosition;
import com.tonbeller.jpivot.mondrian.MondrianQuax;
import com.tonbeller.jpivot.mondrian.MondrianQuaxBean;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.mondrian.MondrianResult;
import com.tonbeller.jpivot.mondrian.MondrianSortRank;
import com.tonbeller.jpivot.mondrian.MondrianUtil;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.query.ExpBean;
import com.tonbeller.jpivot.olap.query.MdxOlapModel;
import com.tonbeller.jpivot.olap.query.PositionNodeBean;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.olap.query.QuaxBean;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DriverManager;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunCall;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.InvalidHierarchyException;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.MemoryLimitExceededException;
import mondrian.olap.MondrianException;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.ParameterImpl;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.ServletContextCatalogLocator;
import mondrian.util.MemoryMonitor;
import mondrian.util.MemoryMonitorFactory;
import org.apache.log4j.Logger;

public class MondrianModel
extends MdxOlapModel
implements OlapModel,
QueryAdapter.QueryAdapterHolder {
    static Logger logger = Logger.getLogger(MondrianModel.class);
    static final String LOGICAL_MDX_PROP = "com.tonbeller.jpivot.mondrian.logical.mdx";
    public static final String CELL_LIMIT_PROP = "com.tonbeller.jpivot.mondrian.cell.limit";
    public static final Integer CELL_LIMIT_DEFAULT = new Integer(0);
    private String connectString = null;
    private Util.PropertyList connectProperties = null;
    private String jdbcDriver = null;
    private Connection monConnection = null;
    private String mdxQuery = null;
    private Role role = null;
    private String currentMdx = null;
    private MondrianResult result = null;
    private HashMap hDimensions = new HashMap();
    private HashMap hHierarchies = new HashMap();
    private HashMap hLevels = new HashMap();
    private HashMap hMembers = new HashMap();
    private ArrayList aMeasures = new ArrayList();
    private List aLogicalModel = new LinkedList();
    private MondrianQueryAdapter queryAdapter = null;
    private Listener listener = null;
    private boolean isInitialized = false;
    private String ID = null;
    private Locale loc = null;
    private String sessionId = null;
    private String dynresolver = null;
    private String dynLocale = null;
    boolean useChecksum = false;
    private boolean connectionPooling = true;
    private DataSource externalDataSource = null;
    private ServletContext servletContext = null;
    private Object bookMark = null;
    private String dataSourceChangeListener = null;

    @Override
    public String getID() {
        return this.ID;
    }

    final void checkListener() throws MemoryLimitExceededException {
        if (this.listener != null) {
            this.listener.check();
        }
    }

    @Override
    public void setID(String ID) {
        this.ID = ID;
    }

    public MondrianModel() {
        this.addModelChangeListener(new ModelChangeListener(){

            @Override
            public void modelChanged(ModelChangeEvent e) {
                MondrianModel.this.result = null;
            }

            @Override
            public void structureChanged(ModelChangeEvent e) {
                MondrianModel.this.result = null;
            }
        });
    }

    public SchemaReader getSchemaReader() {
        return this.queryAdapter != null ? this.queryAdapter.getSchemaReader() : this.getConnection().getSchemaReader().withLocus();
    }

    @Override
    public QueryAdapter getQueryAdapter() {
        return this.queryAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Result getResult() throws OlapException {
        if (this.result != null) {
            return this.result;
        }
        if (!this.isInitialized) {
            throw new OlapException("Model not initialized");
        }
        this.listener = new Listener();
        MemoryMonitor mm = MemoryMonitorFactory.getMemoryMonitor();
        try {
            boolean tryagain;
            mondrian.olap.Result monResult;
            block21: {
                mm.addListener((MemoryMonitor.Listener)this.listener);
                this.queryAdapter.onExecute();
                monResult = null;
                tryagain = false;
                try {
                    String mdx = null;
                    if (Boolean.getBoolean(LOGICAL_MDX_PROP)) {
                        Query modiQuery = this.rewriteMDXQuery(this.queryAdapter.getMonQuery());
                        this.queryAdapter.setMonQuery(modiQuery);
                        mdx = this.queryAdapter.getMonQuery().toString();
                        this.setCurrentMdx(mdx);
                    }
                    if (logger.isDebugEnabled()) {
                        if (mdx == null) {
                            mdx = this.queryAdapter.getMonQuery().toString();
                        }
                        logger.debug(mdx);
                    }
                    this.listener.check();
                    long t1 = System.currentTimeMillis();
                    monResult = this.monConnection.execute(this.queryAdapter.getMonQuery());
                    this.listener.check();
                    if (logger.isInfoEnabled()) {
                        long t2 = System.currentTimeMillis();
                        logger.info((Object)("query execution time " + (t2 - t1) + " ms"));
                    }
                }
                catch (MondrianException ex) {
                    Throwable rootCause = this.getRootCause(ex);
                    if (rootCause instanceof ResultLimitExceededException) {
                        logger.warn((Object)("Mondrian result limit exceeded: " + rootCause.getMessage()));
                        if (this.bookMark != null) {
                            this.setBookmarkState(this.bookMark);
                            tryagain = true;
                        }
                    } else {
                        if (rootCause instanceof InvalidHierarchyException) {
                            logger.warn((Object)("Mondrian Hierarchy with no members: " + rootCause.getMessage()));
                            throw new OlapModel.EmptyCubeException(rootCause);
                        }
                        throw new OlapException(ex);
                    }
                    if (tryagain) break block21;
                    throw new OlapModel.ResultTooLargeException(ex);
                }
            }
            if (tryagain) {
                try {
                    long t1 = System.currentTimeMillis();
                    monResult = this.monConnection.execute(this.queryAdapter.getMonQuery());
                    this.listener.check();
                    if (logger.isInfoEnabled()) {
                        long t2 = System.currentTimeMillis();
                        logger.info((Object)("rollback query execution time " + (t2 - t1) + " ms"));
                    }
                }
                catch (MondrianException ex) {
                    throw new OlapModel.ResultTooLargeException("Error running previous query (prior to Result Overflow)", ex);
                }
            }
            this.result = new MondrianResult(monResult, this);
            if (tryagain) {
                this.result.setOverflowOccured(true);
            }
            this.queryAdapter.afterExecute(this.result);
            if (!tryagain) {
                this.bookMark = this.retrieveBookmarkState(0);
            }
        }
        finally {
            mm.removeListener((MemoryMonitor.Listener)this.listener);
            this.listener = null;
        }
        return this.result;
    }

    MondrianResult currentResult() {
        return this.result;
    }

    @Override
    public com.tonbeller.jpivot.olap.model.Dimension[] getDimensions() {
        return this.hDimensions.values().toArray(new com.tonbeller.jpivot.olap.model.Dimension[0]);
    }

    @Override
    public Member[] getMeasures() {
        return this.aMeasures.toArray(new Member[0]);
    }

    public void setConnectString(String connectString) {
        this.connectString = connectString;
        this.result = null;
        this.queryAdapter = null;
        this.monConnection = null;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("connectString=" + connectString));
        }
    }

    public void setConnectProperties(Util.PropertyList properties) {
        this.connectProperties = properties;
        this.result = null;
        this.queryAdapter = null;
        this.monConnection = null;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("connectProperties=" + this.connectProperties));
        }
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        this.result = null;
        this.queryAdapter = null;
        this.monConnection = null;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("jdbcDriver=" + jdbcDriver));
        }
    }

    public void setMdxQuery(String mdxQuery) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("setMdxQuery:" + mdxQuery));
        }
        this.mdxQuery = mdxQuery;
        this.currentMdx = mdxQuery.replaceAll("\r", "");
        this.result = null;
        this.queryAdapter = null;
    }

    @Override
    public void initialize() throws OlapException {
        Query monQuery;
        logger.info((Object)this);
        boolean logInfo = logger.isInfoEnabled();
        if (this.jdbcDriver != null) {
            try {
                Class.forName(this.jdbcDriver);
            }
            catch (Exception ex) {
                String err = "Could not load Jdbc Driver " + this.jdbcDriver;
                logger.error((Object)err);
                throw new OlapException(err);
            }
        }
        Util.PropertyList properties = this.getConnectProperties();
        boolean updatedProperties = false;
        if (properties == null) {
            properties = Util.parseConnectString((String)this.connectString);
            updatedProperties = true;
        }
        String catString = properties.get("Catalog");
        URI uri = null;
        try {
            if (catString != null) {
                uri = new URI(catString);
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (uri != null && uri.getScheme().equalsIgnoreCase("http") && this.sessionId != null) {
            catString = uri.getQuery() != null ? catString + "&sessionId=" + this.sessionId : catString + "?sessionId=" + this.sessionId;
            properties.put(RolapConnectionProperties.Catalog.name(), catString);
            updatedProperties = true;
        }
        if (this.dynresolver != null && this.dynresolver.length() > 0) {
            properties.put(RolapConnectionProperties.DynamicSchemaProcessor.name(), this.dynresolver);
            updatedProperties = true;
        }
        if (this.dynLocale != null) {
            properties.put(RolapConnectionProperties.Locale.name(), this.dynLocale);
            updatedProperties = true;
        }
        if (this.dataSourceChangeListener != null && this.dataSourceChangeListener.length() > 0) {
            properties.put(RolapConnectionProperties.DataSourceChangeListener.name(), this.dataSourceChangeListener);
            updatedProperties = true;
        }
        if (!this.connectionPooling) {
            properties.put(RolapConnectionProperties.PoolNeeded.name(), "false");
            updatedProperties = true;
        }
        if (this.useChecksum) {
            properties.put(RolapConnectionProperties.UseContentChecksum.name(), "true");
            updatedProperties = true;
        }
        if (updatedProperties) {
            this.setConnectProperties(properties);
        }
        ServletContextCatalogLocator catalogLocator = new ServletContextCatalogLocator(this.servletContext);
        this.monConnection = DriverManager.getConnection((Util.PropertyList)properties, (CatalogLocator)catalogLocator, (DataSource)this.externalDataSource);
        if (this.monConnection == null) {
            String err = "Could not create Mondrian connection:" + properties;
            logger.error((Object)err);
            throw new OlapException(err);
        }
        if (this.role != null) {
            this.monConnection.setRole(this.role);
        }
        if (logInfo) {
            logger.info((Object)("MondrianModel: opening connection " + properties));
        }
        this.loc = this.getLocale();
        if (this.loc != null) {
            if (logInfo) {
                String msg = "Locale language=" + this.loc.getLanguage() + " Country=" + this.loc.getCountry();
                logger.info((Object)msg);
            }
            ((RolapConnection)this.monConnection).setLocale(this.loc);
        }
        try {
            monQuery = this.parseMDX();
        }
        catch (OlapException e) {
            String err = e.getMessage();
            logger.error((Object)err);
            throw new OlapException(err);
        }
        this.resetMetaData(monQuery);
        this.queryAdapter = new MondrianQueryAdapter(this, monQuery);
        MondrianSortRank sortExt = (MondrianSortRank)this.getExtension("sortRank");
        if (sortExt != null) {
            sortExt.reset();
        }
        this.isInitialized = true;
        Map extMap = this.getExtensions();
        Collection extensions = extMap.values();
        for (Extension extension : extensions) {
            extension.modelInitialized();
        }
    }

    private Query parseMDX() throws OlapException {
        Query monQuery;
        try {
            monQuery = this.getConnection().parseQuery(this.mdxQuery);
        }
        catch (MondrianException ex) {
            logger.error((Object)"Parse Failure", (Throwable)ex);
            Throwable rootCause = this.getRootCause(ex);
            throw new OlapException(rootCause.getMessage());
        }
        catch (Exception ex) {
            logger.fatal((Object)("unexpected parse failure " + ex.getMessage()));
            throw new OlapException(ex);
        }
        if (monQuery == null) {
            logger.fatal((Object)"unexpected parse failure");
            throw new OlapException("unexpected parse failure");
        }
        return monQuery;
    }

    private Throwable getRootCause(MondrianException ex) {
        Throwable rootCause = ex;
        for (Throwable cause = ex.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    private void addDimension(Dimension monDimension) {
        String uniqueName = monDimension.getUniqueName();
        if (!this.hDimensions.containsKey(uniqueName)) {
            MondrianDimension dimension = new MondrianDimension(monDimension, this);
            this.hDimensions.put(uniqueName, dimension);
            Hierarchy[] monHiers = monDimension.getHierarchies();
            for (int i = 0; i < monHiers.length; ++i) {
                this.addHierarchy(monHiers[i], dimension);
            }
        }
    }

    private void addHierarchy(Hierarchy monHierarchy, MondrianDimension dimension) {
        String uniqueName = monHierarchy.getUniqueName();
        if (!this.hHierarchies.containsKey(uniqueName)) {
            MondrianHierarchy hierarchy = new MondrianHierarchy(monHierarchy, dimension, this);
            this.hHierarchies.put(uniqueName, hierarchy);
            SchemaReader scr = this.getSchemaReader();
            List monLevels = scr.getHierarchyLevels(monHierarchy);
            for (int i = 0; i < monLevels.size(); ++i) {
                this.addLevel((Level)monLevels.get(i), hierarchy);
            }
        }
    }

    protected void addLevel(Level monLevel, MondrianHierarchy hierarchy) {
        String uniqueName = monLevel.getUniqueName();
        if (!this.hLevels.containsKey(uniqueName)) {
            MondrianLevel level = new MondrianLevel(monLevel, hierarchy, this);
            this.hLevels.put(uniqueName, level);
        }
    }

    public MondrianMember addMember(mondrian.olap.Member monMember) {
        String uniqueName = monMember.getUniqueName();
        if (this.hMembers.containsKey(uniqueName)) {
            return (MondrianMember)this.hMembers.get(uniqueName);
        }
        Level monLevel = monMember.getLevel();
        MondrianLevel level = this.lookupLevel(monLevel.getUniqueName());
        MondrianMember member = new MondrianMember(monMember, level, this);
        this.hMembers.put(uniqueName, member);
        if (monMember.isMeasure()) {
            this.aMeasures.add(member);
        }
        return member;
    }

    public void removeMember(String uniqueName) {
        if (this.hMembers.containsKey(uniqueName)) {
            MondrianMember m = (MondrianMember)this.hMembers.get(uniqueName);
            if (this.aMeasures.contains(m)) {
                this.aMeasures.remove(m);
            }
            this.hMembers.remove(uniqueName);
        }
    }

    public MondrianDimension lookupDimension(String uniqueName) {
        return (MondrianDimension)this.hDimensions.get(uniqueName);
    }

    public MondrianHierarchy lookupHierarchy(String uniqueName) {
        return (MondrianHierarchy)this.hHierarchies.get(uniqueName);
    }

    @Override
    public Member lookupMemberByUName(String uniqueName) {
        MondrianMember m = (MondrianMember)this.hMembers.get(uniqueName);
        if (m != null) {
            return m;
        }
        SchemaReader scr = this.getSchemaReader();
        List uniqueNameParts = Util.parseIdentifier((String)uniqueName);
        Cube cube = this.queryAdapter.getMonQuery().getCube();
        mondrian.olap.Member monMember = (mondrian.olap.Member)Util.lookupCompound((SchemaReader)scr, (OlapElement)cube, (List)uniqueNameParts, (boolean)false, (int)6);
        if (monMember != null) {
            return this.addMember(monMember);
        }
        if (monMember == null) {
            Formula[] formulas = this.queryAdapter.getMonQuery().getFormulas();
            for (int i = 0; i < formulas.length; ++i) {
                monMember = formulas[i].getMdxMember();
                if (!uniqueName.equals(monMember.getUniqueName())) continue;
                return this.addMember(monMember);
            }
        }
        return null;
    }

    public MondrianLevel lookupLevel(String uniqueName) {
        return (MondrianLevel)this.hLevels.get(uniqueName);
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    private boolean canAccess(Dimension dim) {
        Role role = this.monConnection.getRole();
        if (!role.canAccess((OlapElement)dim)) {
            return false;
        }
        Hierarchy[] hiers = dim.getHierarchies();
        for (int i = 0; i < hiers.length; ++i) {
            if (!role.canAccess((OlapElement)hiers[i])) continue;
            return true;
        }
        return false;
    }

    private void resetMetaData(Query monQuery) {
        this.hDimensions = new HashMap();
        this.hHierarchies = new HashMap();
        this.hLevels = new HashMap();
        this.hMembers = new HashMap();
        this.aMeasures = new ArrayList();
        Cube cube = monQuery.getCube();
        Dimension[] monDims = cube.getDimensions();
        for (int i = 0; i < monDims.length; ++i) {
            if (!this.canAccess(monDims[i])) continue;
            this.addDimension(monDims[i]);
        }
        SchemaReader sr = cube.getSchemaReader(null).withLocus();
        for (int i = 0; i < monDims.length; ++i) {
            Hierarchy[] monHiers = monDims[i].getHierarchies();
            for (int j = 0; j < monHiers.length; ++j) {
                List calcMembers = sr.getCalculatedMembers(monHiers[j]);
                Iterator it = calcMembers.iterator();
                while (it.hasNext()) {
                    this.addMember((mondrian.olap.Member)it.next());
                }
            }
        }
    }

    public Connection getConnection() {
        return this.monConnection;
    }

    @Override
    public String getCurrentMdx() {
        if (this.result != null) {
            return this.currentMdx;
        }
        if (this.queryAdapter == null) {
            return this.mdxQuery;
        }
        try {
            this.getResult();
        }
        catch (Exception e) {
            logger.error((Object)("unexpected Exeption getResult " + e.toString()));
            throw new RuntimeException(e);
        }
        return this.currentMdx;
    }

    boolean setUserMdx(String mdxQuery) throws OlapException {
        if (this.currentMdx.equals(mdxQuery)) {
            return false;
        }
        String saveMdx = this.mdxQuery;
        this.mdxQuery = mdxQuery;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("setUserMdx =" + mdxQuery));
        }
        Query monQuery = null;
        try {
            monQuery = this.parseMDX();
        }
        catch (OlapException e) {
            logger.error((Object)("setUserMdx failed " + e.getMessage()));
            this.mdxQuery = saveMdx;
            throw e;
        }
        this.resetMetaData(monQuery);
        this.queryAdapter = new MondrianQueryAdapter(this, monQuery);
        MondrianSortRank sortExt = (MondrianSortRank)this.getExtension("sortRank");
        if (sortExt != null) {
            sortExt.reset();
        }
        this.result = null;
        this.currentMdx = mdxQuery.replace('\r', ' ');
        return true;
    }

    protected String getMdxQuery() {
        return this.mdxQuery;
    }

    public Object getRootDecoree() {
        return this;
    }

    @Override
    public void destroy() {
        logger.info(null);
        super.destroy();
        if (this.monConnection != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("MondrianModel: closing connection " + this.monConnection));
            }
            this.monConnection.close();
            this.monConnection = null;
        }
        this.sessionId = null;
    }

    protected void setCurrentMdx(String currentMdx) {
        this.currentMdx = currentMdx.replaceAll("\r", "");
    }

    protected Connection getMonConnection() {
        return this.monConnection;
    }

    protected String getJdbcDriver() {
        return this.jdbcDriver;
    }

    protected String getConnectString() {
        return this.connectString;
    }

    protected Util.PropertyList getConnectProperties() {
        return this.connectProperties;
    }

    @Override
    public Object retrieveBookmarkState(int levelOfDetail) {
        if (this.result == null) {
            return null;
        }
        try {
            if (levelOfDetail == 0) {
                return this.getExtensionalBookmarkState();
            }
            return this.getIntensionalBookmarkState();
        }
        catch (OlapException e) {
            logger.error(null, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Object getExtensionalBookmarkState() throws OlapException {
        MondrianMemento memento = this.createMemento();
        memento.setMdxQuery(this.currentMdx);
        boolean useQuax = this.queryAdapter.isUseQuax();
        memento.setUseQuax(useQuax);
        if (useQuax) {
            MondrianQuax[] quaxes = (MondrianQuax[])this.queryAdapter.getQuaxes();
            QuaxBean[] quaxBeans = new MondrianQuaxBean[quaxes.length];
            for (int i = 0; i < quaxes.length; ++i) {
                quaxBeans[i] = new MondrianQuaxBean();
                this.beanFromQuax(quaxBeans[i], quaxes[i]);
            }
            memento.setQuaxes(quaxBeans);
        }
        return memento;
    }

    private Object getIntensionalBookmarkState() throws OlapException {
        MondrianMemento memento = this.createMemento();
        memento.setUseQuax(true);
        MondrianAxis[] axes = (MondrianAxis[])this.result.getAxes();
        QuaxBean[] quaxBeans = new MondrianQuaxBean[axes.length];
        for (int i = 0; i < axes.length; ++i) {
            quaxBeans[i] = this.intensionalQuaxBeanFromAxis(axes[i]);
        }
        memento.setQuaxes(quaxBeans);
        String newMdx = this.intensionalMdx((MondrianQuaxBean[])quaxBeans);
        memento.setMdxQuery(newMdx);
        return memento;
    }

    private String intensionalMdx(MondrianQuaxBean[] quaxBeans) {
        String saveMdx = this.currentMdx;
        Query cloneQuery = this.queryAdapter.getMonQuery().safeClone();
        Quax[] quaxes = new MondrianQuax[quaxBeans.length];
        for (int i = 0; i < quaxes.length; ++i) {
            MondrianQuax q = (MondrianQuax)this.queryAdapter.getQuaxes()[i];
            QueryAxis a = this.queryAdapter.getMonQuery().axes[i];
            quaxes[i] = new MondrianQuax(q.getOrdinal(), a, this);
        }
        try {
            this.quaxesFromBeans(quaxes, quaxBeans);
        }
        catch (OlapException e) {
            logger.error(null, (Throwable)e);
            throw new IllegalArgumentException(e.toString());
        }
        Quax[] saveQuaxes = (MondrianQuax[])this.queryAdapter.getQuaxes();
        this.queryAdapter.setQuaxes(quaxes);
        Query mQuery = this.queryAdapter.getMonQuery();
        mQuery.setSlicerAxis(null);
        this.queryAdapter.onExecute();
        Formula[] formulas = mQuery.getFormulas();
        for (int i = 0; i < formulas.length; ++i) {
            mondrian.olap.Member m = formulas[i].getMdxMember();
            boolean remove = false;
            if (!m.getDimension().isMeasures()) {
                remove = true;
            } else {
                Exp exp = formulas[i].getExpression();
                if (this.notMeasures(exp)) {
                    remove = true;
                }
            }
            if (!remove) continue;
            String name = formulas[i].getMdxMember().getUniqueName();
            if (mQuery.canRemoveFormula(name)) {
                mQuery.removeFormula(name, true);
                continue;
            }
            logger.fatal((Object)("cannot remove formula " + formulas[i].getName()));
        }
        this.queryAdapter.onExecute();
        String newMdx = this.currentMdx;
        this.queryAdapter.setQuaxes(saveQuaxes);
        this.queryAdapter.setMonQuery(cloneQuery);
        this.currentMdx = saveMdx;
        return newMdx;
    }

    private boolean notMeasures(Exp exp) {
        if (exp instanceof mondrian.olap.Member) {
            mondrian.olap.Member m = (mondrian.olap.Member)exp;
            return !m.getDimension().isMeasures();
        }
        if (exp instanceof FunCall) {
            FunCall f = (FunCall)exp;
            Exp[] args = f.getArgs();
            for (int i = 0; i < args.length; ++i) {
                if (!this.notMeasures(args[i])) continue;
                return true;
            }
        }
        return false;
    }

    private MondrianMemento createMemento() {
        MondrianMemento memento = new MondrianMemento();
        memento.setJdbcDriver(this.jdbcDriver);
        memento.setConnectString(this.connectString);
        memento.setVersion(3);
        memento.setAxesSwapped(this.queryAdapter.isSwapAxes());
        MondrianSortRank sortExt = (MondrianSortRank)this.getExtension("sortRank");
        if (sortExt != null) {
            this.storeSort(sortExt, memento);
        }
        return memento;
    }

    private MondrianQuaxBean intensionalQuaxBeanFromAxis(MondrianAxis axis) throws OlapException {
        MondrianQuaxBean quaxBean = new MondrianQuaxBean();
        MondrianHierarchy[] hiers = (MondrianHierarchy[])axis.getHierarchies();
        quaxBean.setNDimension(hiers.length);
        quaxBean.setHierarchizeNeeded(false);
        quaxBean.setOrdinal(axis.getOrdinal());
        PositionNodeBean rootBean = new PositionNodeBean();
        rootBean.setReference(null);
        quaxBean.setPosTreeRoot(rootBean);
        PositionNodeBean parentBean = rootBean;
        for (int i = 0; i < hiers.length; ++i) {
            ExpBean expBean;
            if (hiers[i].getDimension().isMeasure()) {
                Exp exp = this.createMeasuresExp(axis, i);
                expBean = this.createBeanFromExp(exp);
            } else {
                ExpBean hierBean = this.createBeanFromExp(hiers[i].getMonHierarchy());
                expBean = new ExpBean();
                expBean.setType(8);
                expBean.setArgs(new ExpBean[]{hierBean});
            }
            PositionNodeBean nodeBean = new PositionNodeBean();
            nodeBean.setReference(expBean);
            parentBean.setChildren(new PositionNodeBean[]{nodeBean});
            parentBean = nodeBean;
        }
        return quaxBean;
    }

    private Exp createMeasuresExp(MondrianAxis axis, int i) {
        ArrayList<MemberExpr> measuresList = new ArrayList<MemberExpr>();
        HashSet<MondrianMember> measuresSet = new HashSet<MondrianMember>();
        for (MondrianPosition mp : axis.getPositions()) {
            MondrianMember member = (MondrianMember)mp.getMembers()[i];
            if (!measuresSet.add(member)) continue;
            measuresList.add(new MemberExpr(member.getMonMember()));
        }
        if (measuresList.size() == 1) {
            return (Exp)measuresList.get(0);
        }
        Exp[] args = measuresList.toArray(new Exp[measuresList.size()]);
        return new UnresolvedFunCall("{}", Syntax.Braces, args);
    }

    @Override
    public void setBookmarkState(Object state) {
        MondrianSortRank sortExt;
        MondrianMemento memento = (MondrianMemento)state;
        int version = memento.getVersion();
        if (version <= 1) {
            logger.warn((Object)"Bookmark is of old state (not supported any more in the future)!\nPlease save again!");
        }
        this.mdxQuery = memento.getMdxQuery();
        if (this.isInitialized) {
            Query monQuery = null;
            try {
                monQuery = this.parseMDX();
            }
            catch (OlapException e) {
                String err = e.getMessage();
                logger.fatal((Object)err);
                throw new RuntimeException(err);
            }
            this.resetMetaData(monQuery);
            this.queryAdapter = new MondrianQueryAdapter(this, monQuery);
            sortExt = (MondrianSortRank)this.getExtension("sortRank");
            if (sortExt != null) {
                sortExt.reset();
            }
        } else {
            this.connectString = memento.getConnectString();
            this.jdbcDriver = memento.getJdbcDriver();
            try {
                this.initialize();
            }
            catch (OlapException e) {
                String err = e.getMessage();
                logger.fatal((Object)err);
                throw new RuntimeException(err);
            }
        }
        boolean useQuax = true;
        if (version >= 3) {
            useQuax = memento.isUseQuax();
            this.queryAdapter.setUseQuax(useQuax);
        }
        if (useQuax) {
            QuaxBean[] quaxBeans = (MondrianQuaxBean[])memento.getQuaxes();
            Quax[] quaxes = (MondrianQuax[])this.queryAdapter.getQuaxes();
            if (version <= 1) {
                for (int i = 0; i < quaxes.length; ++i) {
                    boolean qubonMode = quaxBeans[i].isQubonMode();
                    quaxes[i].setQubonMode(qubonMode);
                    if (qubonMode) {
                        MondrianOldStuff.handleQubonMode((MondrianQuax)quaxes[i], (MondrianQuaxBean)quaxBeans[i], this);
                        continue;
                    }
                    MondrianOldStuff.handleDrillExMode((MondrianQuax)quaxes[i], (MondrianQuaxBean)quaxBeans[i], this);
                }
            } else {
                try {
                    this.quaxesFromBeans(quaxes, quaxBeans);
                }
                catch (OlapException e) {
                    logger.error(null, (Throwable)e);
                    throw new IllegalArgumentException(e.toString());
                }
            }
        }
        sortExt = (MondrianSortRank)this.getExtension("sortRank");
        this.restoreSort(sortExt, memento);
        this.queryAdapter.setSwapAxes(memento.isAxesSwapped());
        this.fireModelChanged();
    }

    private Exp[] createExpsFromBeans(ExpBean[] beans) throws OlapException {
        Exp[] exps = new Exp[beans.length];
        for (int i = 0; i < beans.length; ++i) {
            exps[i] = (Exp)this.createExpFromBean(beans[i]);
        }
        return exps;
    }

    @Override
    protected Object createExpFromBean(ExpBean expBean) throws OlapException {
        if (expBean.getType() == 8) {
            SchemaReader scr = this.getSchemaReader();
            Exp[] args = this.createExpsFromBeans(expBean.getArgs());
            HierarchyExpr he = (HierarchyExpr)args[0];
            Hierarchy h = he.getHierarchy();
            return MondrianUtil.topLevelMembers(h, false, scr);
        }
        if (expBean.getType() == 0) {
            MondrianMember member = (MondrianMember)this.lookupMemberByUName(expBean.getName());
            if (member == null) {
                throw new OlapException("could not find member " + expBean.getName());
            }
            return new MemberExpr(member.getMonMember());
        }
        if (expBean.getType() == 1) {
            String name = expBean.getName();
            ExpBean[] argBeans = expBean.getArgs();
            Exp[] args = this.createExpsFromBeans(argBeans);
            if ("Parameter".equalsIgnoreCase(name)) {
                String paramId = String.valueOf(((Literal)args[0]).getValue());
                Exp value = args[2];
                Type type = value.getType();
                String descr = "";
                if (args.length == 4) {
                    descr = (String)((Literal)args[3]).getValue();
                }
                return new ParameterExpr((Parameter)new ParameterImpl(paramId, value, descr, type));
            }
            if ("ParamRef".equalsIgnoreCase(name)) {
                throw new IllegalArgumentException(name);
            }
            Syntax syntax = MondrianUtil.funCallSyntax(name, argBeans.length);
            return new UnresolvedFunCall(name, syntax, args);
        }
        if (expBean.getType() == 2) {
            MondrianLevel lev = this.lookupLevel(expBean.getName());
            if (lev == null) {
                throw new OlapException("could not find Level " + expBean.getName());
            }
            return new LevelExpr(lev.getMonLevel());
        }
        if (expBean.getType() == 4) {
            MondrianHierarchy hier = this.lookupHierarchy(expBean.getName());
            if (hier == null) {
                throw new OlapException("could not find Hierarchy " + expBean.getName());
            }
            return new HierarchyExpr(hier.getMonHierarchy());
        }
        if (expBean.getType() == 3) {
            MondrianDimension dim = this.lookupDimension(expBean.getName());
            if (dim == null) {
                throw new OlapException("could not find Dimension " + expBean.getName());
            }
            return new DimensionExpr(dim.getMonDimension());
        }
        if (expBean.getType() == 5) {
            String str = (String)expBean.getLiteralValue();
            return Literal.createString((String)str);
        }
        if (expBean.getType() == 6) {
            Integer iii = (Integer)expBean.getLiteralValue();
            return Literal.create((Integer)iii);
        }
        if (expBean.getType() == 7) {
            Double ddd = new Double(((Number)expBean.getLiteralValue()).doubleValue());
            return Literal.create((Double)ddd);
        }
        throw new OlapException("Invalid ExpBean Type " + expBean.getType());
    }

    @Override
    protected ExpBean createBeanFromExp(Object exp) throws OlapException {
        ExpBean bean = new ExpBean();
        if (exp instanceof mondrian.olap.Member) {
            mondrian.olap.Member m = (mondrian.olap.Member)exp;
            bean.setType(0);
            bean.setName(m.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof Level) {
            Level lev = (Level)exp;
            bean.setType(2);
            bean.setName(lev.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof Hierarchy) {
            Hierarchy hier = (Hierarchy)exp;
            bean.setType(4);
            bean.setName(hier.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof Dimension) {
            Dimension dim = (Dimension)exp;
            bean.setType(3);
            bean.setName(dim.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof FunCall) {
            FunCall f = (FunCall)exp;
            bean.setType(1);
            bean.setName(f.getFunName());
            bean.setArgs(this.createBeansFromExps(f.getArgs()));
        } else if (exp instanceof ParameterExpr) {
            Parameter p = ((ParameterExpr)exp).getParameter();
            bean.setType(1);
            bean.setName("Parameter");
            bean.setArgs(this.createBeansFromExps(this.getParamterArgs(p)));
        } else if (exp instanceof MemberExpr) {
            mondrian.olap.Member m = ((MemberExpr)exp).getMember();
            bean.setType(0);
            bean.setName(m.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof LevelExpr) {
            Level lev = ((LevelExpr)exp).getLevel();
            bean.setType(2);
            bean.setName(lev.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof HierarchyExpr) {
            Hierarchy hier = ((HierarchyExpr)exp).getHierarchy();
            bean.setType(4);
            bean.setName(hier.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof DimensionExpr) {
            Dimension dim = ((DimensionExpr)exp).getDimension();
            bean.setType(3);
            bean.setName(dim.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof Literal) {
            Literal lit = (Literal)exp;
            Object val = lit.getValue();
            if (lit.getCategory() == 7) {
                if (val instanceof Integer) {
                    bean.setType(6);
                } else {
                    bean.setType(7);
                }
            } else {
                bean.setType(5);
            }
            bean.setLiteralValue(val);
            bean.setArgs(new ExpBean[0]);
        } else {
            logger.fatal((Object)("cannot create ExpBean type =" + exp.getClass().toString()));
            throw new IllegalArgumentException(exp.getClass().toString());
        }
        return bean;
    }

    private Exp[] getParamterArgs(Parameter p) {
        Literal expType;
        Literal expValue;
        Literal expName = Literal.createString((String)p.getName());
        Object objValue = p.getValue();
        if (objValue == null) {
            objValue = p.getDefaultExp();
        }
        if (objValue instanceof Literal) {
            objValue = ((Literal)objValue).getValue();
        } else if (objValue instanceof MemberExpr) {
            objValue = ((MemberExpr)objValue).getMember();
        }
        if (objValue instanceof String) {
            expValue = Literal.createString((String)((String)objValue));
            expType = Literal.createSymbol((String)"STRING");
        } else if (objValue instanceof Double) {
            expValue = Literal.create((Double)((Double)objValue));
            expType = Literal.createSymbol((String)"NUMBER");
        } else if (objValue instanceof Integer) {
            expValue = Literal.create((Integer)((Integer)objValue));
            expType = Literal.createSymbol((String)"NUMBER");
        } else if (objValue instanceof mondrian.olap.Member) {
            mondrian.olap.Member m = (mondrian.olap.Member)objValue;
            expValue = new MemberExpr(m);
            expType = new DimensionExpr(m.getDimension());
        } else {
            throw new IllegalArgumentException("unknown Param value: " + objValue + ": " + objValue.getClass());
        }
        Literal expDescr = p.getDescription() != null ? Literal.createString((String)p.getDescription()) : Literal.createString((String)"");
        return new Exp[]{expName, expType, expValue, expDescr};
    }

    private ExpBean[] createBeansFromExps(Object[] exps) throws OlapException {
        ExpBean[] beans = new ExpBean[exps.length];
        for (int i = 0; i < exps.length; ++i) {
            beans[i] = this.createBeanFromExp(exps[i]);
        }
        return beans;
    }

    public DataSource getSqlDataSource() {
        return ((RolapConnection)this.monConnection).getDataSource();
    }

    public String getDynresolver() {
        return this.dynresolver;
    }

    public void setDynresolver(String dynresolver) {
        this.dynresolver = dynresolver;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public boolean isConnectionPooling() {
        return this.connectionPooling;
    }

    public void setConnectionPooling(boolean connectionPooling) {
        this.connectionPooling = connectionPooling;
    }

    public DataSource getExternalDataSource() {
        return this.externalDataSource;
    }

    public void setExternalDataSource(DataSource externalDataSource) {
        this.externalDataSource = externalDataSource;
    }

    public String getDynLocale() {
        return this.dynLocale;
    }

    public void setDynLocale(String dynLocale) {
        this.dynLocale = dynLocale;
    }

    public String getDataSourceChangeListener() {
        return this.dataSourceChangeListener;
    }

    public void setDataSourceChangeListener(String dataSourceChangeListener) {
        this.dataSourceChangeListener = dataSourceChangeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query rewriteMDXQuery(Query query) {
        try {
            QueryVisitor visitor = new QueryVisitor();
            QueryAxis[] axes = query.getAxes();
            for (int i = 0; i < axes.length; ++i) {
                axes[i].accept((MdxVisitor)visitor);
            }
            String originalQuery = query.toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("rewriteMDXQuery: originalQuery=" + originalQuery));
            }
            visitor.cleanUpPhysicalModel();
            this.removeLogicalNameFromList("[Time]");
            boolean changeHappened = false;
            block5: for (List list : visitor.getPhysicalModel()) {
                Iterator memIterator = list.iterator();
                if (!memIterator.hasNext()) continue;
                String memberName = ((mondrian.olap.Member)memIterator.next()).toString();
                List uniqueNameParts = Util.parseIdentifier((String)memberName);
                String dimension = ((Id.Segment)uniqueNameParts.get(0)).toString();
                for (String logicalName : this.aLogicalModel) {
                    if (!logicalName.startsWith(dimension) || !this.isAtSameLevel(memberName, logicalName)) continue;
                    originalQuery = this.replaceEnumeratedQuery(originalQuery, memberName, logicalName);
                    changeHappened = true;
                    continue block5;
                }
            }
            Query result = query;
            if (changeHappened) {
                result = this.getConnection().parseQuery(originalQuery);
                visitor = new QueryVisitor();
                axes = result.getAxes();
                for (int i = 0; i < axes.length; ++i) {
                    axes[i].accept((MdxVisitor)visitor);
                }
            }
            this.aLogicalModel = visitor.getLogicalModel();
            Query query2 = result;
            return query2;
        }
        catch (Exception e) {
            logger.warn((Object)" Error in rewriting MDX Query ");
            e.printStackTrace();
            this.aLogicalModel.clear();
            Query query3 = query;
            return query3;
        }
    }

    public String replaceEnumeratedQuery(String query, String memberName, String logicalName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("replaceEnumeratedQuery: Given Query is " + query));
        }
        StringBuffer result = new StringBuffer(200);
        int index = query.indexOf(memberName);
        result.append(query.substring(0, index));
        result.append(logicalName);
        index = query.indexOf("}", index);
        result.append(query.substring(index));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("replaceEnumeratedQuery: Resultant Query is " + result.toString()));
        }
        return result.toString();
    }

    public boolean isAtSameLevel(String memberName, String logicalName) {
        List memberUniqueNameParts = Util.parseIdentifier((String)memberName);
        List logicalUniqueNameParts = Util.parseIdentifier((String)logicalName);
        return memberUniqueNameParts.size() == logicalUniqueNameParts.size();
    }

    protected void removeLogicalNameFromList(String hierName) {
        for (int i = 0; i < this.aLogicalModel.size(); ++i) {
            String listName = (String)this.aLogicalModel.get(i);
            if (!listName.startsWith(hierName)) continue;
            this.aLogicalModel.remove(i);
            break;
        }
    }

    public boolean isUseChecksum() {
        return this.useChecksum;
    }

    public void setUseChecksum(boolean useChecksum) {
        this.useChecksum = useChecksum;
    }

    class Listener
    implements MemoryMonitor.Listener {
        String oomMsg;

        Listener() {
        }

        public void memoryUsageNotification(long used, long max) {
            StringBuffer buf = new StringBuffer(200);
            buf.append("OutOfMemory used=");
            buf.append(used);
            buf.append(", max=");
            buf.append(max);
            buf.append(" for mdx: ");
            buf.append(MondrianModel.this.queryAdapter.getMonQuery().toString());
            this.oomMsg = buf.toString();
        }

        final void check() throws MemoryLimitExceededException {
            if (this.oomMsg != null) {
                throw new MemoryLimitExceededException(this.oomMsg);
            }
        }
    }

    static class QueryVisitor
    extends MdxVisitorImpl {
        private LinkedList logicalDimensionList = new LinkedList();
        private List physicalDimensionList = new ArrayList();
        private List enumMemberList = new ArrayList();

        private QueryVisitor() {
        }

        public Object visit(UnresolvedFunCall call) {
            if (call.getFunName().equalsIgnoreCase("children") || call.getFunName().equalsIgnoreCase("members")) {
                this.logicalDimensionList.add(call.toString());
                this.enumMemberList = new ArrayList();
                this.physicalDimensionList.add(this.enumMemberList);
            } else if (call.getFunName().equals("{}")) {
                this.enumMemberList = new ArrayList();
                this.physicalDimensionList.add(this.enumMemberList);
            }
            return null;
        }

        public Object visit(ResolvedFunCall call) {
            if (call.getFunName().equalsIgnoreCase("children") || call.getFunName().equalsIgnoreCase("members")) {
                this.logicalDimensionList.add(call.toString());
                this.enumMemberList = new ArrayList();
                this.physicalDimensionList.add(this.enumMemberList);
            } else if (call.getFunName().equals("{}")) {
                this.enumMemberList = new ArrayList();
                this.physicalDimensionList.add(this.enumMemberList);
            }
            return null;
        }

        public Object visit(MemberExpr memberExpr) {
            mondrian.olap.Member member = memberExpr.getMember();
            this.enumMemberList.add(member);
            return null;
        }

        public LinkedList getLogicalModel() {
            return this.logicalDimensionList;
        }

        public List getPhysicalModel() {
            return this.physicalDimensionList;
        }

        public void cleanUpPhysicalModel() {
            ArrayList<List> newList = new ArrayList<List>();
            for (int i = 0; i < this.physicalDimensionList.size(); ++i) {
                List aList = (List)this.physicalDimensionList.get(i);
                if (aList.size() == 1 || !this.allSameDimension(aList)) continue;
                newList.add(aList);
            }
            this.physicalDimensionList = newList;
        }

        public void print(Object msg) {
            System.out.println(msg);
        }

        public void printLists() {
            Iterator it = this.logicalDimensionList.iterator();
            while (it.hasNext()) {
                this.print((String)it.next());
            }
            this.print(" going to print members ");
            for (List list : this.physicalDimensionList) {
                Iterator ite = list.iterator();
                while (ite.hasNext()) {
                    this.print((mondrian.olap.Member)ite.next());
                }
                this.print(" Going to print next member lists");
            }
        }

        private boolean allSameDimension(List list) {
            if (list.size() == 0) {
                return false;
            }
            String firstMemberName = ((mondrian.olap.Member)list.get(0)).toString();
            List uniqueNameParts = Util.parseIdentifier((String)firstMemberName);
            String dimName = ((Id.Segment)uniqueNameParts.get(0)).toString();
            boolean result = true;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String name = ((mondrian.olap.Member)it.next()).toString();
                if (name.startsWith(dimName)) continue;
                result = false;
                break;
            }
            return result;
        }
    }
}

