/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.mdxparse;

import com.tonbeller.jpivot.olap.mdxparse.CompoundId;
import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.ExpVisitor;
import com.tonbeller.jpivot.olap.mdxparse.Formula;
import com.tonbeller.jpivot.olap.mdxparse.FunCall;
import com.tonbeller.jpivot.olap.mdxparse.Literal;
import com.tonbeller.jpivot.olap.mdxparse.MemberProperty;
import com.tonbeller.jpivot.olap.mdxparse.Parameter;
import com.tonbeller.jpivot.olap.mdxparse.QueryAxis;
import com.tonbeller.jpivot.olap.model.OlapException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ParsedQuery
implements Exp {
    static Logger logger = Logger.getLogger(ParsedQuery.class);
    List formulas = new ArrayList();
    Map paraMap = new Hashtable();
    ArrayList axisDef = null;
    String cube;
    List cellProps = new ArrayList();
    Exp slicer = null;
    private QueryAxis[] axes = new QueryAxis[0];

    public void afterParse() throws OlapException {
        if (this.axisDef != null) {
            this.axes = this.axisDef.toArray(new QueryAxis[0]);
            this.axisDef = null;
        }
        this.collectParams();
    }

    public QueryAxis[] getAxes() {
        return this.axes;
    }

    public void setAxes(QueryAxis[] axes) {
        this.axes = axes;
    }

    public String getCube() {
        if (this.cube.charAt(0) == '[' && this.cube.charAt(this.cube.length() - 1) == ']') {
            return this.cube.substring(1, this.cube.length() - 1);
        }
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public Formula[] getFormulas() {
        return this.formulas.toArray(new Formula[0]);
    }

    @Override
    public String toMdx() {
        StringBuffer mdx = new StringBuffer();
        if (this.formulas.size() > 0) {
            mdx.append("WITH ");
            Iterator iter = this.formulas.iterator();
            while (iter.hasNext()) {
                mdx.append(' ');
                Formula form = (Formula)iter.next();
                mdx.append(form.toMdx());
            }
            mdx.append(' ');
        }
        mdx.append("SELECT ");
        boolean isFollow = false;
        for (int i = 0; i < this.axes.length; ++i) {
            QueryAxis qa = this.axes[i];
            if (isFollow) {
                mdx.append(", ");
            }
            isFollow = true;
            mdx.append(qa.toMdx());
        }
        mdx.append(" FROM ");
        mdx.append(this.cube);
        if (this.slicer != null) {
            mdx.append(" WHERE ");
            mdx.append(this.slicer.toMdx());
        }
        if (this.cellProps.size() > 0) {
            mdx.append(" CELL PROPERTIES VALUE, FORMATTED_VALUE");
            for (CompoundId cid : this.cellProps) {
                String str = cid.toMdx();
                if (str.equalsIgnoreCase("VALUE") || str.equalsIgnoreCase("FORMATTED_VALUE")) continue;
                mdx.append(" ,");
                mdx.append(str);
            }
        }
        return mdx.toString();
    }

    public String toDrillMdx() {
        StringBuffer mdx = new StringBuffer();
        if (this.formulas.size() > 0) {
            mdx.append("WITH ");
            Iterator iter = this.formulas.iterator();
            while (iter.hasNext()) {
                mdx.append(' ');
                Formula form = (Formula)iter.next();
                mdx.append(form.toMdx());
            }
            mdx.append(' ');
        }
        mdx.append("DRILLTHROUGH SELECT ");
        boolean isFollow = false;
        for (int i = 0; i < this.axes.length; ++i) {
            QueryAxis qa = this.axes[i];
            if (isFollow) {
                mdx.append(", ");
            }
            isFollow = true;
            mdx.append(qa.toMdx());
        }
        mdx.append(" FROM ");
        mdx.append(this.cube);
        if (this.slicer != null) {
            mdx.append(" WHERE ");
            mdx.append(this.slicer.toMdx());
        }
        if (this.cellProps.size() > 0) {
            mdx.append(" CELL PROPERTIES VALUE, FORMATTED_VALUE");
            for (CompoundId cid : this.cellProps) {
                String str = cid.toMdx();
                if (str.equalsIgnoreCase("VALUE") || str.equalsIgnoreCase("FORMATTED_VALUE")) continue;
                mdx.append(" ,");
                mdx.append(str);
            }
        }
        return mdx.toString();
    }

    @Override
    public Object clone() {
        ParsedQuery cloned = new ParsedQuery();
        if (this.formulas.size() > 0) {
            ArrayList<Object> clonedFormulas = new ArrayList<Object>();
            for (Formula form : this.formulas) {
                clonedFormulas.add(form.clone());
            }
            cloned.formulas = clonedFormulas;
        }
        if (this.axes.length > 0) {
            QueryAxis[] clonedAxes = new QueryAxis[this.axes.length];
            for (int i = 0; i < clonedAxes.length; ++i) {
                clonedAxes[i] = (QueryAxis)this.axes[i].clone();
            }
            cloned.setAxes(clonedAxes);
        }
        if (this.slicer != null) {
            cloned.slicer = (Exp)this.slicer.clone();
        }
        cloned.setCube("[" + this.getCube() + "]");
        return cloned;
    }

    public Exp getSlicer() {
        return this.slicer;
    }

    public void setSlicer(Exp exp) {
        this.slicer = exp;
    }

    private void collectParams() throws OlapException {
        int iAxis = -2;
        for (Formula formula : this.formulas) {
            this.walkTreeForParams(formula.getExp(), iAxis);
            for (int i = 0; i < formula.memberProperties.length; ++i) {
                this.walkTreeForParams(formula.memberProperties[i].getExp(), iAxis);
            }
        }
        int i = 0;
        while (i < this.axes.length) {
            Exp exp = this.axes[i].getExp();
            iAxis = i++;
            this.walkTreeForParams(exp, iAxis);
        }
    }

    private void walkTreeForParams(Exp exp, int iAxis) throws OlapException {
        if (!(exp instanceof FunCall)) {
            return;
        }
        FunCall f = (FunCall)exp;
        if (f.isCallTo("Parameter")) {
            Exp val;
            int type;
            int nArgs = f.getArgs().length;
            if (nArgs != 3 && nArgs != 4) {
                throw new OlapException("Syntax Error in Parameter: wrong number of arguments");
            }
            if (!(f.getArgs()[0] instanceof Literal)) {
                throw new OlapException("Syntax Error in Parameter definition - 1.argument");
            }
            Literal eName = (Literal)f.getArgs()[0];
            String paraName = eName.stringValue();
            if (this.paraMap.containsKey(paraName.toUpperCase())) {
                String err = "Parameter defined more than once:" + paraName;
                logger.error((Object)err);
                throw new OlapException(err);
            }
            Object value = null;
            f.pQuery = this;
            CompoundId id = (CompoundId)f.getArgs()[1];
            String[] ids = id.toStringArray();
            if (ids.length > 1) {
                throw new OlapException("Syntax Error in Parameter definition - 2.argument");
            }
            if (ids[0].equalsIgnoreCase("NUMERIC")) {
                type = 1;
                if (!(f.getArgs()[0] instanceof Literal)) {
                    throw new OlapException("Syntax Error in Parameter definition - 3.argument");
                }
                val = (Literal)f.getArgs()[2];
                value = ((Literal)val).getValueObject();
            } else if (ids[0].equalsIgnoreCase("STRING")) {
                type = 2;
                val = (Literal)f.getArgs()[2];
                value = ((Literal)val).getValueObject();
            } else {
                type = 3;
                val = (CompoundId)f.getArgs()[2];
                value = ((CompoundId)val).toMdx();
            }
            Parameter par = new Parameter(paraName, type, iAxis);
            par.setOValue(value);
            if (nArgs == 4) {
                Literal desc = (Literal)f.getArgs()[3];
                String description = (String)desc.getValueObject();
                par.setDescription(description);
            }
            this.paraMap.put(paraName.toUpperCase(), par);
        } else if (f.isCallTo("ParamRef")) {
            f.pQuery = this;
        }
        for (int i = 0; i < f.getArgs().length; ++i) {
            this.walkTreeForParams(f.getArgs()[i], iAxis);
        }
    }

    public Map getParaMap() {
        return this.paraMap;
    }

    public void addFormula(String[] names, Exp exp, MemberProperty[] memberProperties) {
        Formula newFormula = new Formula(names, exp, memberProperties);
        this.formulas.add(newFormula);
    }

    public void addFormula(String[] names, Exp exp) {
        Formula newFormula = new Formula(names, exp);
        this.formulas.add(newFormula);
    }

    public void removeFormula(String uniqueName) {
        Iterator iter = this.formulas.iterator();
        while (iter.hasNext()) {
            Formula formula = (Formula)iter.next();
            if (!uniqueName.equals(formula.getUniqeName())) continue;
            iter.remove();
        }
    }

    @Override
    public void accept(ExpVisitor visitor) {
        visitor.visitParsedQuery(this);
    }

    public List getCellProps() {
        return this.cellProps;
    }
}

