/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.model.impl;

import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import java.util.List;
import java.util.ListIterator;

public class PositionSpan {
    Axis axis;
    Position position;
    Member member;
    int memberIndex;
    int startIndex;
    int endIndex;

    public PositionSpan(Axis axis, Position position, Member member) {
        this.axis = axis;
        this.position = position;
        this.member = member;
        this.memberIndex = this.indexOf(position.getMembers(), member);
        this.initStartIndex();
        this.initEndIndex();
    }

    void initStartIndex() {
        Position p;
        List list = this.axis.getPositions();
        int index = list.indexOf(this.position);
        ListIterator li = list.listIterator(index);
        while (li.hasPrevious() && this.match(p = (Position)li.previous())) {
            --index;
        }
        this.startIndex = index;
    }

    void initEndIndex() {
        Position p;
        List list = this.axis.getPositions();
        int index = list.indexOf(this.position);
        ListIterator li = list.listIterator(index);
        while (li.hasNext() && this.match(p = (Position)li.next())) {
            ++index;
        }
        this.endIndex = index;
    }

    boolean match(Position p) {
        Member[] m1 = p.getMembers();
        Member[] m2 = this.position.getMembers();
        for (int i = 0; i <= this.memberIndex; ++i) {
            if (m1[i].equals(m2[i])) continue;
            return false;
        }
        return true;
    }

    int indexOf(Object[] array, Object obj) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public Member getMember() {
        return this.member;
    }

    public Position getPosition() {
        return this.position;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getMemberIndex() {
        return this.memberIndex;
    }
}

