/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.query;

import com.tonbeller.jpivot.core.Extension;
import com.tonbeller.jpivot.core.ModelSupport;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.query.MDXElement;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.olap.query.ResultBase;
import com.tonbeller.jpivot.olap.query.SortRankBase;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class QueryAdapter {
    static Logger logger = Logger.getLogger(QueryAdapter.class);
    protected ModelSupport model;
    protected Quax[] quaxes;
    protected boolean useQuax = false;
    protected boolean axesSwapped = false;
    protected boolean genMDXHierarchize = false;
    protected SortRankBase sortMan = null;

    protected QueryAdapter(ModelSupport model) {
        this.model = model;
        Extension sortExt = model.getExtension("sortRank");
        if (sortExt != null) {
            this.sortMan = (SortRankBase)sortExt;
        }
        this.axesSwapped = false;
    }

    public Quax[] getQuaxes() {
        return this.quaxes;
    }

    public void setQuaxes(Quax[] quaxes) {
        this.quaxes = quaxes;
    }

    public Quax findQuax(Dimension dim) {
        for (int i = 0; i < this.quaxes.length; ++i) {
            if (this.quaxes[i].dimIdx(dim) < 0) continue;
            return this.quaxes[i];
        }
        return null;
    }

    public void afterExecute(Result result) {
        int i;
        Axis[] axes = result.getAxes();
        if (!this.useQuax) {
            for (i = 0; i < axes.length; ++i) {
                List positions = axes[i].getPositions();
                this.quaxes[this.iASwap(i)].init(positions);
            }
        } else {
            int i2;
            int iQuaxToSort = -1;
            if (this.sortMan != null) {
                iQuaxToSort = this.sortMan.activeQuaxToSort();
            }
            if (!this.genMDXHierarchize) {
                for (i2 = 0; i2 < this.quaxes.length; ++i2) {
                    if (!this.quaxes[i2].isHierarchizeNeeded() || i2 == iQuaxToSort) continue;
                    ((ResultBase)result).hierarchize(this.iASwap(i2));
                }
            }
            for (i2 = 0; i2 < this.quaxes.length; ++i2) {
                List positions = axes[this.iASwap(i2)].getPositions();
                if (this.quaxes[i2].getGenerateMode() == 1) {
                    this.quaxes[i2].resetGenerate();
                    this.quaxes[i2].init(positions);
                    continue;
                }
                int nDimension = this.quaxes[i2].getNDimension();
                for (int j = 0; j < nDimension; ++j) {
                    if (!this.quaxes[i2].isUnknownFunction(j)) continue;
                    List memList = this.memListForHier(j, positions);
                    this.quaxes[i2].setHierMemberList(j, memList);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            for (i = 0; i < axes.length; ++i) {
                List positions = axes[i].getPositions();
                logger.debug((Object)("Positions of axis " + i));
                if (positions.size() == 0) {
                    logger.debug((Object)"0 positions");
                    continue;
                }
                int nDimension = ((Position)positions.get(0)).getMembers().length;
                for (Position pos : positions) {
                    Member[] mems = pos.getMembers();
                    StringBuffer sb = new StringBuffer();
                    for (int j = 0; j < nDimension; ++j) {
                        if (j > 0) {
                            sb.append(" * ");
                        }
                        Member[] memsj = new Member[j + 1];
                        for (int k = 0; k <= j; ++k) {
                            memsj[k] = mems[k];
                        }
                        if (this.canExpand(memsj)) {
                            sb.append("(+)");
                        } else if (this.canCollapse(memsj)) {
                            sb.append("(-)");
                        } else {
                            sb.append("   ");
                        }
                        sb.append(((MDXElement)((Object)mems[j])).getUniqueName());
                    }
                    logger.debug((Object)sb.toString());
                }
            }
        }
    }

    private List memListForHier(int hierIndex, List positions) {
        ArrayList<Member> memList = new ArrayList<Member>();
        for (Position pos : positions) {
            Member m = pos.getMembers()[hierIndex];
            if (memList.contains(m)) continue;
            memList.add(m);
        }
        return memList;
    }

    protected abstract Object createMemberSet(List var1);

    public abstract boolean canExpand(Member var1);

    public abstract boolean canExpand(Member[] var1);

    public abstract boolean canCollapse(Member var1);

    public abstract boolean canCollapse(Member[] var1);

    public void expand(Member member) {
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("expand Member" + this.poString(null, member)));
        }
        if (quax == null || !quax.canExpand(member)) {
            logger.fatal((Object)("Expand Member failed for" + ((MDXElement)((Object)member)).getUniqueName()));
            return;
        }
        quax.expand(member);
        this.model.fireModelChanged();
    }

    public void expand(Member[] pathMembers) {
        Member member = pathMembers[pathMembers.length - 1];
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("expand Path" + this.poString(pathMembers, null)));
        }
        if (quax == null || !quax.canExpand(pathMembers)) {
            logger.fatal((Object)("Expand failed for" + this.poString(pathMembers, null)));
            throw new IllegalArgumentException("cannot expand");
        }
        quax.expand(pathMembers);
        this.model.fireModelChanged();
    }

    public void collapse(Member member) {
        Quax quax;
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("collapse " + ((MDXElement)((Object)member)).getUniqueName()));
        }
        if ((quax = this.findQuax(dim)) == null) {
            logger.info((Object)("collapse Quax was null " + ((MDXElement)((Object)member)).getUniqueName()));
            return;
        }
        quax.collapse(member);
        this.model.fireModelChanged();
    }

    public void collapse(Member[] pathMembers) {
        Member member;
        Dimension dim;
        Quax quax;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("collapse" + this.poString(pathMembers, null)));
        }
        if ((quax = this.findQuax(dim = (member = pathMembers[pathMembers.length - 1]).getLevel().getHierarchy().getDimension())) == null) {
            logger.debug((Object)("collapse Quax was null" + this.poString(pathMembers, null)));
            return;
        }
        quax.collapse(pathMembers);
        this.model.fireModelChanged();
    }

    public abstract boolean canDrillDown(Member var1);

    public boolean canDrillUp(Hierarchy hier) {
        Quax quax = this.findQuax(hier.getDimension());
        return quax == null ? false : quax.canDrillUp(hier);
    }

    public void drillDown(Member member) {
        Quax quax = this.findQuax(member.getLevel().getHierarchy().getDimension());
        if (quax == null) {
            logger.info((Object)("drillDown Quax was null" + this.poString(null, member)));
            return;
        }
        quax.drillDown(member);
        this.model.fireModelChanged();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("drillDown " + this.poString(null, member)));
        }
    }

    public void drillUp(Hierarchy hier) {
        Quax quax = this.findQuax(hier.getDimension());
        if (quax == null) {
            logger.info((Object)("drillUp Hierarchy Quax was null" + hier.getLabel()));
            return;
        }
        quax.drillUp(hier);
        this.model.fireModelChanged();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("drillUp Hierarchy " + hier.getLabel()));
        }
    }

    public boolean isSwapAxes() {
        return this.axesSwapped;
    }

    public int iASwap(int i) {
        if (this.axesSwapped) {
            return (i + 1) % 2;
        }
        return i;
    }

    protected String poString(Member[] posMembers, Member member) {
        StringBuffer sb = new StringBuffer();
        if (posMembers != null) {
            sb.append(" Position=");
            for (int i = 0; i < posMembers.length; ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(((MDXElement)((Object)posMembers[i])).getUniqueName());
            }
        }
        if (member != null) {
            sb.append(" Member=");
            sb.append(((MDXElement)((Object)member)).getUniqueName());
        }
        return sb.toString();
    }

    public boolean isUseQuax() {
        return this.useQuax;
    }

    public void setUseQuax(boolean b) {
        this.useQuax = b;
    }

    public static interface QueryAdapterHolder {
        public QueryAdapter getQueryAdapter();
    }
}

