/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Displayable;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.navi.MemberTree;
import com.tonbeller.jpivot.table.AxisBuilder;
import com.tonbeller.jpivot.table.AxisConfig;
import com.tonbeller.jpivot.table.AxisHeaderBuilder;
import com.tonbeller.jpivot.table.AxisHeaderBuilderSupport;
import com.tonbeller.jpivot.table.LevelAxisDecorator;
import com.tonbeller.jpivot.table.PartBuilderSupport;
import com.tonbeller.jpivot.table.SpanBuilder;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.span.HierarchyHeaderFactory;
import com.tonbeller.jpivot.table.span.LevelHeaderFactory;
import com.tonbeller.jpivot.table.span.PropertyConfig;
import com.tonbeller.jpivot.table.span.PropertySpanBuilder;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanCalc;
import com.tonbeller.jpivot.table.span.SpanConfigSupport;
import com.tonbeller.wcf.controller.RequestContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public abstract class AxisBuilderSupport
extends PartBuilderSupport
implements AxisBuilder,
AxisConfig,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(AxisBuilderSupport.class);
    protected SpanCalc spanCalc;
    protected SpanBuilder spanBuilder;
    protected PropertySpanBuilder propertySpanBuilder;
    protected AxisHeaderBuilder axisHeaderBuilder;
    protected boolean showParentMembers = false;
    protected boolean memberIndent = false;
    protected int hierarchyHeader = 0;
    protected int memberSpan = 3;
    protected int headerSpan = 3;

    protected AxisBuilderSupport(SpanBuilder spanBuilder) {
        this.spanBuilder = spanBuilder;
    }

    @Override
    public void initialize(RequestContext context, TableComponent table) throws Exception {
        logger.info((Object)"initialize");
        super.initialize(context, table);
        this.spanBuilder.initialize(context, table);
        this.propertySpanBuilder = new PropertySpanBuilder(table.getOlapModel());
        this.propertySpanBuilder.addPropertyChangeListener(this);
        this.propertySpanBuilder.initialize(context);
        this.axisHeaderBuilder = new AxisHeaderBuilderSupport(this.spanBuilder);
    }

    @Override
    public void destroy(HttpSession session) throws Exception {
        logger.info((Object)"destroy");
        this.propertySpanBuilder.destroy(session);
        this.propertySpanBuilder = null;
        super.destroy(session);
    }

    protected void initialize(Axis axis) {
        MemberTree tree;
        logger.info((Object)"initialize(Axis)");
        if (this.showParentMembers && (tree = (MemberTree)this.table.getOlapModel().getExtension("memberTree")) != null) {
            logger.info((Object)"adding LevelAxisDecorator");
            axis = new LevelAxisDecorator(axis, tree);
        }
        logger.info((Object)"creating SpanCalc");
        this.spanCalc = new SpanCalc(axis);
        SpanConfigSupport scs = new SpanConfigSupport();
        scs.setDirection(Member.class, this.memberSpan);
        scs.setDirection(Displayable.class, this.headerSpan);
        this.spanCalc.setConfig(scs);
        this.propertySpanBuilder.addPropertySpans(this.spanCalc);
        switch (this.hierarchyHeader) {
            case 1: {
                this.spanCalc.addHierarchyHeader(new HierarchyHeaderFactory(), true);
                break;
            }
            case 2: {
                this.spanCalc.addHierarchyHeader(new LevelHeaderFactory(), true);
            }
        }
    }

    @Override
    public boolean isShowParentMembers() {
        return this.showParentMembers;
    }

    @Override
    public void setShowParentMembers(boolean showParentMembers) {
        this.showParentMembers = showParentMembers;
        this.setDirty(true);
    }

    @Override
    public SpanBuilder getSpanBuilder() {
        return this.spanBuilder;
    }

    @Override
    public void setSpanBuilder(SpanBuilder spanBuilder) {
        this.spanBuilder = spanBuilder;
        this.setDirty(true);
    }

    @Override
    public boolean isMemberIndent() {
        return this.memberIndent;
    }

    @Override
    public void setMemberIndent(boolean memberIndent) {
        this.memberIndent = memberIndent;
        this.setDirty(true);
    }

    @Override
    public AxisConfig getAxisConfig() {
        return this;
    }

    @Override
    public int getHeaderSpan() {
        return this.headerSpan;
    }

    @Override
    public int getHierarchyHeader() {
        return this.hierarchyHeader;
    }

    @Override
    public int getMemberSpan() {
        return this.memberSpan;
    }

    @Override
    public void setHeaderSpan(int headerSpan) {
        this.headerSpan = headerSpan;
        this.setDirty(true);
    }

    @Override
    public void setHierarchyHeader(int hierarchyHeader) {
        this.hierarchyHeader = hierarchyHeader;
        this.setDirty(true);
    }

    @Override
    public void setMemberSpan(int memberSpan) {
        this.memberSpan = memberSpan;
        this.setDirty(true);
    }

    protected abstract Axis getAxis();

    @Override
    public void startBuild(RequestContext context) {
        Axis axis = this.getAxis();
        if (axis != null) {
            this.initialize(axis);
        }
        super.startBuild(context);
        this.spanBuilder.startBuild(context);
    }

    @Override
    public void stopBuild() {
        this.spanBuilder.stopBuild();
        super.stopBuild();
        this.spanCalc = null;
    }

    @Override
    public SpanCalc getSpanCalc() {
        return this.spanCalc;
    }

    protected void buildHeading(Element row, Span span, int rowspan, int colspan, boolean even) {
        this.axisHeaderBuilder.build(row, span, rowspan, colspan, even, this.isMemberIndent());
    }

    @Override
    public PropertyConfig getPropertyConfig() {
        return this.propertySpanBuilder;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setDirty(true);
    }

    @Override
    public Object retrieveBookmarkState(int levelOfDetail) {
        return this.getPropertyConfig().retrieveBookmarkState(levelOfDetail);
    }

    @Override
    public void setBookmarkState(Object state) {
        this.getPropertyConfig().setBookmarkState(state);
    }

    @Override
    public AxisHeaderBuilder getAxisHeaderBuilder() {
        return this.axisHeaderBuilder;
    }

    @Override
    public void setAxisHeaderBuilder(AxisHeaderBuilder axisHeaderBuilder) {
        this.axisHeaderBuilder = axisHeaderBuilder;
    }
}

