/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table;

import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.table.CellBuilder;
import com.tonbeller.jpivot.table.PartBuilderSupport;
import com.tonbeller.jpivot.table.span.PropertyUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class CellBuilderImpl
extends PartBuilderSupport
implements CellBuilder {
    private static final Logger logger = Logger.getLogger(CellBuilderImpl.class);
    private static final String STYLE = "style";
    private static final String NBSP = "\u00a0";

    @Override
    public Element build(Cell cell, boolean even) {
        Element cellElem = this.table.elem("cell");
        String s = cell.isNull() ? NBSP : cell.getFormattedValue();
        if ((s = s.trim()).length() == 0) {
            s = NBSP;
        }
        cellElem.setAttribute("value", s);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("building cell " + s));
        }
        PropertyUtils.addProperties(cellElem, cell.getProperties());
        Property style = cell.getProperty(STYLE);
        if (style != null) {
            String value = style.getValue();
            if (value != null && value.length() > 0) {
                cellElem.setAttribute(STYLE, value);
            } else {
                cellElem.setAttribute(STYLE, even ? "even" : "odd");
            }
        } else {
            cellElem.setAttribute(STYLE, even ? "even" : "odd");
        }
        return cellElem;
    }
}

