/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.olap.model.Displayable;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.table.SpanBuilder;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.jpivot.table.navi.AbstractClickableMember;
import com.tonbeller.wcf.controller.Dispatcher;
import com.tonbeller.wcf.controller.DispatcherSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestListener;
import com.tonbeller.wcf.utils.DomUtils;
import org.apache.log4j.Logger;

public abstract class ClickableMemberSupport
extends AbstractClickableMember {
    private static final Logger logger = Logger.getLogger(ClickableMemberSupport.class);
    protected Dispatcher dispatcher = new DispatcherSupport();
    protected OlapModel model;
    private String urlPattern;

    protected abstract String getMenuLabel();

    protected abstract RequestListener createRequestListener(OlapModel var1, Member var2);

    public ClickableMemberSupport(String uniqueName) {
        super(uniqueName);
    }

    @Override
    public void startRendering(RequestContext context, TableComponent table) {
        this.model = table.getOlapModel();
        this.dispatcher.clear();
        super.startRendering(context, table);
    }

    @Override
    public void stopRendering() {
        super.stopRendering();
        this.model = null;
    }

    private String handlerUrl(String id) {
        String pattern = this.urlPattern == null ? "" : this.urlPattern;
        char sep = '?';
        if (pattern.indexOf(63) > 0) {
            sep = '&';
        }
        return pattern + sep + id + "=x";
    }

    @Override
    public void decorate(SpanBuilder.SBContext sbctx, Displayable obj) {
        if (!(obj instanceof Member)) {
            return;
        }
        Member m = (Member)obj;
        if (this.match(m)) {
            RequestListener r = this.createRequestListener(this.model, m);
            String id = DomUtils.randomId();
            this.dispatcher.addRequestListener(id, null, r);
            sbctx.addClickable(this.handlerUrl(id), this.getMenuLabel());
        }
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
    }

    @Override
    public void structureChanged(ModelChangeEvent e) {
        this.dispatcher.clear();
    }

    public void request(RequestContext context) throws Exception {
        this.dispatcher.request(context);
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }
}

