/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.VisitorSupportSloppy;
import com.tonbeller.jpivot.olap.navi.DrillReplace;
import com.tonbeller.jpivot.table.navi.DrillExpandUI;
import com.tonbeller.jpivot.table.span.PropertyHeading;
import com.tonbeller.jpivot.table.span.Span;
import com.tonbeller.jpivot.table.span.SpanVisitor;

public class DrillReplaceUI
extends DrillExpandUI {
    public static final String ID = "drillReplace";
    DrillReplace extension;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    protected boolean canCollapse(Span span) {
        CanCollapse cc = new CanCollapse();
        span.getObject().accept(cc);
        return cc.result;
    }

    @Override
    protected void collapse(Span span) {
        DoCollapse dc = new DoCollapse();
        span.getObject().accept(dc);
    }

    @Override
    protected boolean canExpand(Span span) {
        if (DrillReplaceUI.positionContainsMember(span)) {
            return this.extension.canDrillDown((Member)span.getMember().getRootDecoree());
        }
        return false;
    }

    @Override
    protected void expand(Span span) {
        this.extension.drillDown((Member)span.getMember().getRootDecoree());
    }

    @Override
    protected boolean initializeExtension() {
        OlapModel om = this.table.getOlapModel();
        this.extension = (DrillReplace)om.getExtension(ID);
        return this.extension != null;
    }

    @Override
    protected String getCollapseImage() {
        return "drill-replace-collapse";
    }

    @Override
    protected String getExpandImage() {
        return "drill-replace-expand";
    }

    @Override
    protected String getOtherImage() {
        return "drill-replace-other";
    }

    class DoCollapse
    extends VisitorSupportSloppy
    implements SpanVisitor {
        DoCollapse() {
        }

        @Override
        public void visitHierarchy(Hierarchy v) {
            DrillReplaceUI.this.extension.drillUp(v);
        }

        @Override
        public void visitLevel(Level v) {
            DrillReplaceUI.this.extension.drillUp(v.getHierarchy());
        }

        @Override
        public void visitPropertyHeading(PropertyHeading heading) {
        }
    }

    class CanCollapse
    extends VisitorSupportSloppy
    implements SpanVisitor {
        boolean result = false;

        CanCollapse() {
        }

        @Override
        public void visitHierarchy(Hierarchy v) {
            this.result = DrillReplaceUI.this.extension.canDrillUp(v);
        }

        @Override
        public void visitLevel(Level v) {
            this.result = DrillReplaceUI.this.extension.canDrillUp(v.getHierarchy());
        }

        @Override
        public void visitPropertyHeading(PropertyHeading heading) {
        }
    }
}

