/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.tags;

import com.tonbeller.jpivot.tags.Log4jStateLogger;
import com.tonbeller.jpivot.tags.StateLogger;
import com.tonbeller.jpivot.tags.StateManager;
import java.util.Stack;

public class StackStateManager
implements StateManager {
    Stack stack = new Stack();
    StateLogger logger = new Log4jStateLogger();

    private boolean stackContainsName(String name) {
        for (StateManager.State s : this.stack) {
            if (!name.equals(s.getName())) continue;
            return true;
        }
        return false;
    }

    private void hideCurrent() throws Exception {
        StateManager.State s = this.getCurrent();
        if (s != null) {
            this.logger.hide(s);
            s.hide();
        }
    }

    private void showCurrent() throws Exception {
        StateManager.State s = this.getCurrent();
        if (s != null) {
            this.logger.show(s);
            s.show();
        }
    }

    private StateManager.State getCurrent() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return (StateManager.State)this.stack.peek();
    }

    @Override
    public void initializeAndShow(StateManager.State s) throws Exception {
        this.hideCurrent();
        while (this.stackContainsName(s.getName())) {
            StateManager.State t = (StateManager.State)this.stack.pop();
            this.logger.destroy(s);
            t.destroy();
        }
        this.logger.initialize(s);
        s.initialize();
        this.stack.push(s);
        this.showCurrent();
    }

    @Override
    public void showByName(String name) throws Exception {
        if (!this.stackContainsName(name)) {
            this.logger.error("not found in stack: " + name);
            return;
        }
        StateManager.State s = this.getCurrent();
        if (name.equals(s.getName())) {
            return;
        }
        this.hideCurrent();
        while (!name.equals(s.getName())) {
            StateManager.State t = (StateManager.State)this.stack.pop();
            this.logger.destroy(t);
            t.destroy();
            s = (StateManager.State)this.stack.peek();
        }
        this.showCurrent();
    }

    @Override
    public void destroyAll() throws Exception {
        this.hideCurrent();
        while (!this.stack.isEmpty()) {
            StateManager.State s = (StateManager.State)this.stack.pop();
            this.logger.destroy(s);
            s.destroy();
        }
    }

    @Override
    public void destroyByName(String name) throws Exception {
        this.hideCurrent();
        while (this.stackContainsName(name)) {
            StateManager.State t = (StateManager.State)this.stack.pop();
            this.logger.destroy(t);
            t.destroy();
        }
        this.showCurrent();
    }

    @Override
    public StateLogger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(StateLogger logger) {
        this.logger = logger;
    }
}

