/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.test.olap;

import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.MemberPropertyMeta;
import com.tonbeller.jpivot.olap.model.Property;
import com.tonbeller.jpivot.olap.navi.MemberProperties;
import com.tonbeller.jpivot.test.olap.TestDimension;
import com.tonbeller.jpivot.test.olap.TestExtensionSupport;
import com.tonbeller.jpivot.test.olap.TestHierarchy;
import com.tonbeller.jpivot.test.olap.TestMember;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TestMemberProperties
extends TestExtensionSupport
implements MemberProperties {
    boolean initialized = false;
    boolean levelScope;
    HashMap levelMap = new HashMap();

    @Override
    public String getId() {
        return "memberProperties";
    }

    void initialize() {
        this.initialized = true;
        for (int i = 0; i < this.model().getDimensions().length; ++i) {
            TestDimension dim = (TestDimension)this.model().getDimensions()[i];
            for (int j = 0; j < dim.getHierarchies().length; ++j) {
                TestHierarchy th = (TestHierarchy)dim.getHierarchies()[j];
                for (int k = 0; k < th.getRootMembers().length; ++k) {
                    this.recurse(th.getRootMembers()[k]);
                }
            }
        }
    }

    private void recurse(TestMember member) {
        Property[] p = member.getProperties();
        String scope = this.getPropertyScope(member);
        Level level = member.getLevel();
        LevelProps levelProps = (LevelProps)this.levelMap.get(level);
        if (levelProps == null) {
            levelProps = new LevelProps();
            this.levelMap.put(level, levelProps);
        }
        for (int i = 0; i < p.length; ++i) {
            if (levelProps.contains(p[i].getName())) continue;
            MemberPropertyMeta pm = new MemberPropertyMeta();
            pm.setName(p[i].getName());
            pm.setLabel(p[i].getName());
            pm.setScope(scope);
            levelProps.add(pm);
        }
        Iterator it = member.getChildMember().iterator();
        while (it.hasNext()) {
            this.recurse((TestMember)it.next());
        }
    }

    @Override
    public MemberPropertyMeta[] getMemberPropertyMetas(Level level) {
        if (!this.initialized) {
            this.initialize();
        }
        LevelProps levelProps = (LevelProps)this.levelMap.get(level);
        return levelProps.toArray();
    }

    @Override
    public String getPropertyScope(Member m) {
        if (this.levelScope) {
            return m.getLevel().getLabel();
        }
        return m.getLevel().getHierarchy().getLabel();
    }

    @Override
    public boolean isLevelScope() {
        return this.levelScope;
    }

    public void setLevelScope(boolean b) {
        this.levelScope = b;
    }

    @Override
    public void setVisibleProperties(MemberPropertyMeta[] props) {
    }

    static class LevelProps {
        Set names = new HashSet();
        List metas = new ArrayList();

        LevelProps() {
        }

        boolean contains(String name) {
            return this.names.contains(name);
        }

        void add(MemberPropertyMeta m) {
            this.names.add(m.getName());
            this.metas.add(m);
        }

        MemberPropertyMeta[] toArray() {
            return this.metas.toArray(new MemberPropertyMeta[this.metas.size()]);
        }
    }
}

