/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.QueryResultHandler;
import com.tonbeller.jpivot.olap.model.impl.FormatStringParser;
import com.tonbeller.jpivot.olap.model.impl.PropertyImpl;
import com.tonbeller.jpivot.olap.query.ResultBase;
import com.tonbeller.jpivot.xmla.XMLA_Axis;
import com.tonbeller.jpivot.xmla.XMLA_Cell;
import com.tonbeller.jpivot.xmla.XMLA_Dimension;
import com.tonbeller.jpivot.xmla.XMLA_Hierarchy;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_MemberProp;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.jpivot.xmla.XMLA_Position;
import com.tonbeller.jpivot.xmla.XMLA_PropValAssign;
import com.tonbeller.jpivot.xmla.XMLA_SOAP;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class XMLA_Result
extends ResultBase
implements QueryResultHandler {
    static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    static Logger logger = Logger.getLogger(XMLA_Result.class);
    XMLA_Axis axis;
    private XMLA_Member[] tuple;
    private FormatStringParser formatStringParser = new FormatStringParser();
    private int axisOrdinalMeasures = -1;
    private int nXPositions = 0;
    private Map calcMeasurePos = new HashMap();
    private Map drillHeader;
    private List drillRows;

    public XMLA_Result(XMLA_Model model, XMLA_SOAP soap, String catalog, String mdx) throws OlapException {
        super(model);
        soap.executeQuery(mdx, catalog, this);
    }

    public XMLA_Result(XMLA_Model model, XMLA_SOAP soap, String catalog, String mdx, boolean drillthrough) throws OlapException {
        super(model);
        if (drillthrough) {
            soap.executeDrillQuery(mdx, catalog, this);
        } else {
            soap.executeQuery(mdx, catalog, this);
        }
    }

    @Override
    public void handleAxisInfo(String axisName, int axisOrdinal) {
        this.axis = new XMLA_Axis(axisOrdinal, axisName);
        if (axisOrdinal == -1) {
            this.slicer = this.axis;
        } else {
            this.axesList.add(this.axis);
        }
    }

    @Override
    public void handleHierInfo(String hierName, int axisOrdinal, int number) {
        XMLA_Hierarchy hier = hierName.indexOf("[") > -1 && hierName.indexOf("]") > -1 ? ((XMLA_Model)this.model).lookupHierByUName(hierName) : ((XMLA_Model)this.model).lookupHierByUName("[" + hierName + "]");
        this.axis.addHier(hier);
    }

    @Override
    public void handleAxis(String axisName, int axisOrdinal) {
        this.axis = this.lookupAxisByName(axisName);
    }

    @Override
    public void handleTuple(int axisOrdinal, int positionOrdinal) {
        int n = this.axis.getHierarchies().length;
        this.tuple = new XMLA_Member[n];
    }

    @Override
    public void handleMember(String uniqueName, String caption, String levUName, String displayInfo, Map otherProps, int axisOrdinal, int positionOrdinal, int memberOrdinal) {
        XMLA_Member member = (XMLA_Member)((XMLA_Model)this.model).lookupMemberByUName(uniqueName);
        XMLA_Level lev = ((XMLA_Model)this.model).lookupLevelByUName(levUName);
        logger.debug((Object)("handleMember: uniqueName - " + uniqueName + ", level - " + levUName));
        if (member == null) {
            boolean isCalc = ((XMLA_Model)this.model).isMemberInFormulas(uniqueName);
            member = new XMLA_Member((XMLA_Model)this.model, uniqueName, caption, lev, isCalc);
        } else {
            XMLA_Level mLev = (XMLA_Level)member.getLevel();
            if (!mLev.equals(lev)) {
                lev = mLev;
                member.setLevel(mLev);
            }
        }
        member.setDisplayInfo(displayInfo);
        if (!member.isCalculated()) {
            member.clearProps();
            XMLA_Model xmod = (XMLA_Model)this.model;
            Map props = xmod.isSAP() || xmod.isMondrian() ? ((XMLA_Dimension)member.getDimension()).getProps() : ((XMLA_Level)member.getLevel()).getProps();
            for (String tag : otherProps.keySet()) {
                if ((xmod.isSAP() || xmod.isMondrian()) && !tag.startsWith("_")) continue;
                for (XMLA_MemberProp prop : props.values()) {
                    if (!prop.getXmlTag().equals(tag)) continue;
                    String nam = prop.getName();
                    String val = (String)otherProps.get(tag);
                    if (val == null || val.length() <= 0) continue;
                    member.addProp(new PropertyImpl(nam, val));
                }
            }
        } else if (member.getLevel().getHierarchy().getDimension().isMeasure()) {
            this.axisOrdinalMeasures = axisOrdinal;
            this.calcMeasurePos.put(new Integer(positionOrdinal), member);
        }
        this.tuple[memberOrdinal] = member;
        if (memberOrdinal == this.tuple.length - 1) {
            if (axisOrdinal == -1) {
                int n = 0;
                for (int i = 0; i < this.tuple.length; ++i) {
                    XMLA_Member m = this.tuple[i];
                    lev = (XMLA_Level)m.getLevel();
                    if (lev.getType() == 1) {
                        this.tuple[i] = null;
                        continue;
                    }
                    ++n;
                }
                if (n < this.tuple.length) {
                    XMLA_Member[] newTuple = new XMLA_Member[n];
                    int j = 0;
                    for (int i = 0; i < this.tuple.length; ++i) {
                        if (this.tuple[i] == null) continue;
                        newTuple[j++] = this.tuple[i];
                    }
                    this.tuple = newTuple;
                }
            }
            XMLA_Position pos = new XMLA_Position(axisOrdinal);
            pos.setMembers(this.tuple);
            this.axis.addPosition(pos);
        }
    }

    @Override
    public void handleCellData() {
        int nCells = 1;
        for (XMLA_Axis ax : this.axesList) {
            int nPositions = ax.getPositions().size();
            if (this.nXPositions == 0) {
                this.nXPositions = nPositions;
            }
            nCells *= nPositions;
        }
        for (int i = 0; i < nCells; ++i) {
            this.aCells.add(new XMLA_Cell(i, (XMLA_Model)this.model));
        }
    }

    @Override
    public void handleCell(int iOrdinal, Object value, String fmtValue, String fontSize) {
        XMLA_Cell cell = (XMLA_Cell)this.aCells.get(iOrdinal);
        cell.setValue(value);
        cell.setFormattedValue(fmtValue, this.formatStringParser);
        if (fontSize != null) {
            Map calcMeasurePropMap;
            XMLA_PropValAssign cmprops;
            int iFontSize = Integer.parseInt(fontSize);
            int posY = iOrdinal / this.nXPositions;
            int posX = iOrdinal - posY * this.nXPositions;
            XMLA_Member m = null;
            if (this.axisOrdinalMeasures == 0) {
                m = (XMLA_Member)this.calcMeasurePos.get(new Integer(posX));
            } else if (this.axisOrdinalMeasures == 1) {
                m = (XMLA_Member)this.calcMeasurePos.get(new Integer(posY));
            }
            if (m != null && (cmprops = (XMLA_PropValAssign)(calcMeasurePropMap = ((XMLA_Model)this.model).getCalcMeasurePropMap()).get(m.getUniqueName())) != null) {
                Set propSet = cmprops.getPropMap().keySet();
                block0: for (String prop : propSet) {
                    List valAssignList = cmprops.getValAssignList(prop);
                    for (XMLA_PropValAssign.ValAssign vAssign : valAssignList) {
                        int mask = vAssign.getBitMask();
                        int mVal = mask & iFontSize;
                        if (mVal != vAssign.getBitVal()) continue;
                        cell.addProperty(prop, vAssign.getVal());
                        continue block0;
                    }
                }
            }
        }
    }

    private XMLA_Axis lookupAxisByName(String name) {
        if (name.equals("SlicerAxis")) {
            return (XMLA_Axis)this.slicer;
        }
        for (XMLA_Axis ax : this.axesList) {
            if (!ax.getName().equals(name)) continue;
            return ax;
        }
        return null;
    }

    @Override
    public Axis[] getAxes() {
        return this.axesList.toArray(new XMLA_Axis[0]);
    }

    public Map getDrillHeader() {
        return this.drillHeader;
    }

    @Override
    public void setDrillHeader(Map drillHeader) {
        this.drillHeader = drillHeader;
    }

    public List getDrillRows() {
        return this.drillRows;
    }

    @Override
    public void setDrillRows(List drillRows) {
        this.drillRows = drillRows;
    }
}

