/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.olap.model.OlapDiscoverer;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.QueryResultHandler;
import com.tonbeller.jpivot.xmla.XMLA_OlapItem;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.soap.Text;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;

public class XMLA_SOAP
implements OlapDiscoverer {
    static final String MDD_URI = "urn:schemas-microsoft-com:xml-analysis:mddataset";
    static final String ROWS_URI = "urn:schemas-microsoft-com:xml-analysis:rowset";
    static final String XMLA_URI = "urn:schemas-microsoft-com:xml-analysis";
    static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    static Logger logger = Logger.getLogger(XMLA_SOAP.class);
    private SOAPConnectionFactory scf = null;
    private MessageFactory mf = null;
    private int provider = 0;
    private String uri;
    private URL url;
    private String dataSource;
    private String user;
    private String password;
    private String[][] headers;

    public XMLA_SOAP(String uri, String user, String password) throws OlapException {
        logger.debug((Object)"Constructor: straight DiscoverDS");
        this.init(uri, user, password);
        this.setProviderAndDataSource(this.discoverDS());
    }

    public XMLA_SOAP(String uri, String user, String password, String dataSource) throws OlapException {
        logger.debug((Object)("Constructor: given dataSource= " + dataSource));
        this.init(uri, user, password);
        this.dataSource = dataSource;
        this.provider = this.determineProvider(dataSource);
    }

    public XMLA_SOAP(String uri, String user, String password, int newProvider) throws OlapException {
        logger.debug((Object)("Constructor: given provider= " + newProvider));
        this.init(uri, user, password);
        this.provider = newProvider;
        this.setProviderAndDataSource(this.discoverDS());
    }

    private void init(String uri, String user, String password) throws OlapException {
        try {
            this.scf = SOAPConnectionFactory.newInstance();
            this.mf = MessageFactory.newInstance();
        }
        catch (UnsupportedOperationException e) {
            throw new OlapException(e);
        }
        catch (SOAPException e) {
            throw new OlapException(e);
        }
        this.uri = uri;
        this.user = user;
        this.password = password;
        try {
            this.url = new URL(uri);
        }
        catch (MalformedURLException e1) {
            throw new OlapException(e1);
        }
        if (user != null && user.length() > 0) {
            String newUri = this.url.getProtocol() + "://" + user;
            if (password != null && password.length() > 0) {
                newUri = newUri + ":" + password;
            }
            newUri = newUri + "@" + this.url.getHost() + ":" + this.url.getPort() + this.url.getPath();
            try {
                this.url = new URL(newUri);
            }
            catch (MalformedURLException e2) {
                throw new OlapException(e2);
            }
        }
    }

    @Override
    public List discoverCat() throws OlapException {
        final ArrayList cats = new ArrayList();
        HashMap rHash = new HashMap();
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("DataSourceInfo", this.dataSource);
        pHash.put("Content", "SchemaData");
        Rowhandler rh = new Rowhandler(){

            @Override
            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                XMLA_OlapItem oi = new XMLA_OlapItem(1);
                cats.add(oi);
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String lname = e.getElementName().getLocalName();
                    if (lname.equals("CATALOG_NAME")) {
                        oi.setName(e.getValue());
                        continue;
                    }
                    oi.setProperty(lname, e.getValue());
                }
            }
        };
        this.discover("DBSCHEMA_CATALOGS", this.url, rHash, pHash, rh);
        logger.debug((Object)("DBSCHEMA_CATALOGS: found " + cats.size()));
        return cats;
    }

    @Override
    public List discoverDSProps() throws OlapException {
        final ArrayList props = new ArrayList();
        HashMap rHash = new HashMap();
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("DataSourceInfo", this.dataSource);
        pHash.put("Content", "SchemaData");
        Rowhandler rh = new Rowhandler(){

            @Override
            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                XMLA_OlapItem oi = new XMLA_OlapItem(7);
                props.add(oi);
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String lname = e.getElementName().getLocalName();
                    if (lname.equals("PropertyName")) {
                        oi.setName(e.getValue());
                    }
                    oi.setProperty(lname, e.getValue());
                }
            }
        };
        this.discover("DISCOVER_PROPERTIES", this.url, rHash, pHash, rh);
        logger.debug((Object)("DISCOVER_PROPERTIES: found " + props.size()));
        return props;
    }

    @Override
    public List discoverCube(String cat) throws OlapException {
        final ArrayList cubes = new ArrayList();
        HashMap<String, String> rHash = new HashMap<String, String>();
        rHash.put("CATALOG_NAME", cat);
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("DataSourceInfo", this.dataSource);
        pHash.put("Content", "SchemaData");
        pHash.put("Catalog", cat);
        Rowhandler rh = new Rowhandler(){

            @Override
            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                XMLA_OlapItem oi = new XMLA_OlapItem(2);
                cubes.add(oi);
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String lname = e.getElementName().getLocalName();
                    if (lname.equals("CUBE_NAME")) {
                        oi.setName(e.getValue());
                        continue;
                    }
                    oi.setProperty(lname, e.getValue());
                }
            }
        };
        this.discover("MDSCHEMA_CUBES", this.url, rHash, pHash, rh);
        logger.debug((Object)("MDSCHEMA_CUBES: found " + cubes.size()));
        return cubes;
    }

    @Override
    public List discoverDim(String cat, String cube) throws OlapException {
        final ArrayList dims = new ArrayList();
        HashMap<String, String> rHash = new HashMap<String, String>();
        rHash.put("CATALOG_NAME", cat);
        rHash.put("CUBE_NAME", cube);
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("DataSourceInfo", this.dataSource);
        pHash.put("Catalog", cat);
        pHash.put("Content", "SchemaData");
        Rowhandler rh = new Rowhandler(){

            @Override
            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                XMLA_OlapItem oi = new XMLA_OlapItem(3);
                dims.add(oi);
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String lname = e.getElementName().getLocalName();
                    if (lname.equals("DIMENSION_UNIQUE_NAME")) {
                        oi.setUniqueName(e.getValue());
                        continue;
                    }
                    if (lname.equals("DIMENSION_CAPTION")) {
                        oi.setCaption(e.getValue());
                        continue;
                    }
                    if (lname.equals("DIMENSION_NAME")) {
                        oi.setName(e.getValue());
                        continue;
                    }
                    oi.setProperty(lname, e.getValue());
                }
            }
        };
        this.discover("MDSCHEMA_DIMENSIONS", this.url, rHash, pHash, rh);
        logger.debug((Object)("MDSCHEMA_DIMENSIONS: found " + dims.size()));
        if (dims.size() == 0) {
            throw new OlapException("No metadata schema dimensions for catalog: " + cat + " and cube: " + cube);
        }
        return dims;
    }

    @Override
    public List discoverHier(String cat, String cube, String dimension) throws OlapException {
        final ArrayList hiers = new ArrayList();
        HashMap<String, String> rHash = new HashMap<String, String>();
        rHash.put("CATALOG_NAME", cat);
        rHash.put("CUBE_NAME", cube);
        if (dimension != null) {
            rHash.put("DIMENSION_UNIQUE_NAME", dimension);
        }
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("DataSourceInfo", this.dataSource);
        pHash.put("Catalog", cat);
        pHash.put("Content", "SchemaData");
        Rowhandler rh = new Rowhandler(){

            @Override
            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                XMLA_OlapItem oi = new XMLA_OlapItem(4);
                hiers.add(oi);
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String lname = e.getElementName().getLocalName();
                    if (lname.equals("HIERARCHY_UNIQUE_NAME")) {
                        oi.setUniqueName(e.getValue());
                        continue;
                    }
                    if (lname.equals("HIERARCHY_CAPTION")) {
                        oi.setCaption(e.getValue());
                        continue;
                    }
                    if (lname.equals("HIERARCHY_NAME")) {
                        oi.setName(e.getValue());
                        continue;
                    }
                    oi.setProperty(lname, e.getValue());
                }
            }
        };
        this.discover("MDSCHEMA_HIERARCHIES", this.url, rHash, pHash, rh);
        logger.debug((Object)("MDSCHEMA_HIERARCHIES: found " + hiers.size()));
        if (hiers.size() == 0) {
            throw new OlapException("No metadata schema hierarchies for catalog: " + cat + " and cube: " + cube);
        }
        return hiers;
    }

    @Override
    public List discoverLev(String cat, String cube, String dimension, String hier) throws OlapException {
        final ArrayList levels = new ArrayList();
        HashMap<String, String> rHash = new HashMap<String, String>();
        rHash.put("CATALOG_NAME", cat);
        rHash.put("CUBE_NAME", cube);
        if (dimension != null) {
            rHash.put("DIMENSION_UNIQUE_NAME", dimension);
        }
        if (hier != null) {
            rHash.put("HIERARCHY_UNIQUE_NAME", dimension);
        }
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("DataSourceInfo", this.dataSource);
        pHash.put("Catalog", cat);
        pHash.put("Content", "SchemaData");
        Rowhandler rh = new Rowhandler(){

            @Override
            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                XMLA_OlapItem oi = new XMLA_OlapItem(5);
                levels.add(oi);
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String lname = e.getElementName().getLocalName();
                    if (lname.equals("LEVEL_UNIQUE_NAME")) {
                        oi.setUniqueName(e.getValue());
                        continue;
                    }
                    if (lname.equals("LEVEL_CAPTION")) {
                        oi.setCaption(e.getValue());
                        continue;
                    }
                    if (lname.equals("LEVEL_NAME")) {
                        oi.setName(e.getValue());
                        continue;
                    }
                    oi.setProperty(lname, e.getValue());
                }
            }
        };
        this.discover("MDSCHEMA_LEVELS", this.url, rHash, pHash, rh);
        logger.debug((Object)("MDSCHEMA_LEVELS: found " + levels.size()));
        if (levels.size() == 0) {
            throw new OlapException("No metadata schema levels for catalog: " + cat + " and cube: " + cube);
        }
        return levels;
    }

    @Override
    public List discoverMem(String cat, String cube, String dimension, String hierarchy, String level) throws OlapException {
        final ArrayList mems = new ArrayList();
        HashMap<String, String> rHash = new HashMap<String, String>();
        rHash.put("CATALOG_NAME", cat);
        rHash.put("CUBE_NAME", cube);
        if (dimension != null) {
            rHash.put("DIMENSION_UNIQUE_NAME", dimension);
        }
        if (hierarchy != null) {
            rHash.put("HIERARCHY_UNIQUE_NAME", hierarchy);
        }
        if (level != null) {
            rHash.put("LEVEL_UNIQUE_NAME", level);
        }
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("DataSourceInfo", this.dataSource);
        pHash.put("Catalog", cat);
        pHash.put("Content", "SchemaData");
        Rowhandler rh = new Rowhandler(){

            @Override
            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                XMLA_OlapItem oi = new XMLA_OlapItem(6);
                mems.add(oi);
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String lname = e.getElementName().getLocalName();
                    if (lname.equals("MEMBER_UNIQUE_NAME")) {
                        oi.setUniqueName(e.getValue());
                        continue;
                    }
                    if (lname.equals("MEMBER_CAPTION")) {
                        oi.setCaption(e.getValue());
                        continue;
                    }
                    if (lname.equals("MEMBER_NAME")) {
                        oi.setName(e.getValue());
                        continue;
                    }
                    oi.setProperty(lname, e.getValue());
                }
            }
        };
        this.discover("MDSCHEMA_MEMBERS", this.url, rHash, pHash, rh);
        logger.debug((Object)("MDSCHEMA_MEMBERS: found " + mems.size()));
        if (mems.size() == 0) {
            logger.error((Object)("No metadata schema members for catalog: " + cat + " and cube: " + cube));
        }
        return mems;
    }

    @Override
    public List discoverMemTree(String cat, String cube, String member, int treeop) throws OlapException {
        final ArrayList mems = new ArrayList();
        HashMap<String, String> rHash = new HashMap<String, String>();
        rHash.put("CATALOG_NAME", cat);
        rHash.put("CUBE_NAME", cube);
        rHash.put("MEMBER_UNIQUE_NAME", member);
        rHash.put("TREE_OP", String.valueOf(treeop));
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("DataSourceInfo", this.dataSource);
        pHash.put("Catalog", cat);
        pHash.put("Content", "SchemaData");
        Rowhandler rh = new Rowhandler(){

            @Override
            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                XMLA_OlapItem oi = new XMLA_OlapItem(6);
                mems.add(oi);
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String lname = e.getElementName().getLocalName();
                    if (lname.equals("MEMBER_UNIQUE_NAME")) {
                        oi.setUniqueName(e.getValue());
                        continue;
                    }
                    if (lname.equals("MEMBER_CAPTION")) {
                        oi.setCaption(e.getValue());
                        continue;
                    }
                    if (lname.equals("MEMBER_NAME")) {
                        oi.setName(e.getValue());
                        continue;
                    }
                    oi.setProperty(lname, e.getValue());
                }
            }
        };
        this.discover("MDSCHEMA_MEMBERS", this.url, rHash, pHash, rh);
        logger.debug((Object)("MDSCHEMA_MEMBERS Tree: found " + mems.size()));
        if (mems.size() == 0) {
            logger.error((Object)("No metadata schema members tree for catalog: " + cat + " and cube: " + cube + ", member unique name: " + member + ", tree operation: " + String.valueOf(treeop)));
        }
        return mems;
    }

    @Override
    public Map discoverDS() throws OlapException {
        HashMap rHash = new HashMap();
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("Content", "Data");
        final HashMap resultMap = new HashMap();
        Rowhandler rh = new Rowhandler(){

            @Override
            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String name = e.getElementName().getLocalName();
                    String value = e.getValue();
                    resultMap.put(name, value);
                }
            }
        };
        this.discover("DISCOVER_DATASOURCES", this.url, rHash, pHash, rh);
        logger.debug((Object)("DISCOVER_DATASOURCES: found " + resultMap.size()));
        return resultMap;
    }

    @Override
    public List discoverProp(String cat, String cube, String dimension, String hierarchy, String level) throws OlapException {
        final ArrayList props = new ArrayList();
        HashMap<String, String> rHash = new HashMap<String, String>();
        rHash.put("CATALOG_NAME", cat);
        rHash.put("CUBE_NAME", cube);
        if (dimension != null) {
            rHash.put("DIMENSION_UNIQUE_NAME", dimension);
        }
        if (hierarchy != null) {
            rHash.put("HIERARCHY_UNIQUE_NAME", hierarchy);
        }
        if (level != null) {
            rHash.put("LEVEL_UNIQUE_NAME", level);
        }
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("DataSourceInfo", this.dataSource);
        pHash.put("Catalog", cat);
        pHash.put("Content", "SchemaData");
        Rowhandler rh = new Rowhandler(){

            @Override
            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                XMLA_OlapItem oi = new XMLA_OlapItem(7);
                props.add(oi);
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String lname = e.getElementName().getLocalName();
                    if (lname.equals("PROPERTY_NAME")) {
                        oi.setName(e.getValue());
                        continue;
                    }
                    if (lname.equals("PROPERTY_CAPTION")) {
                        oi.setCaption(e.getValue());
                        continue;
                    }
                    oi.setProperty(lname, e.getValue());
                }
            }
        };
        this.discover("MDSCHEMA_PROPERTIES", this.url, rHash, pHash, rh);
        logger.debug((Object)("MDSCHEMA_PROPERTIES: found " + props.size()));
        return props;
    }

    @Override
    public List discoverSapVar(String cat, String cube) throws OlapException {
        final ArrayList props = new ArrayList();
        HashMap<String, String> rHash = new HashMap<String, String>();
        rHash.put("CATALOG_NAME", cat);
        rHash.put("CUBE_NAME", cube);
        HashMap<String, String> pHash = new HashMap<String, String>();
        pHash.put("DataSourceInfo", this.dataSource);
        pHash.put("Catalog", cat);
        pHash.put("Content", "SchemaData");
        Rowhandler rh = new Rowhandler(){

            @Override
            public void handleRow(SOAPElement eRow, SOAPEnvelope envelope) {
                XMLA_OlapItem oi = new XMLA_OlapItem(7);
                props.add(oi);
                Iterator it = eRow.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement e = (SOAPElement)o;
                    String lname = e.getElementName().getLocalName();
                    if (lname.equals("VARIABLE_NAME")) {
                        oi.setName(e.getValue());
                        continue;
                    }
                    if (lname.equals("VARIABLE_CAPTION")) {
                        oi.setCaption(e.getValue());
                        continue;
                    }
                    oi.setProperty(lname, e.getValue());
                }
            }
        };
        this.discover("SAP_VARIABLES", this.url, rHash, pHash, rh);
        return props;
    }

    public void executeQuery(String query, String catalog, QueryResultHandler handler) throws OlapException {
        SOAPConnection connection = null;
        SOAPMessage reply = null;
        try {
            connection = this.scf.createConnection();
            SOAPMessage msg = this.mf.createMessage();
            MimeHeaders mh = msg.getMimeHeaders();
            mh.setHeader("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Execute\"");
            if (this.headers != null) {
                for (int i = 0; i < this.headers.length; ++i) {
                    mh.setHeader(this.headers[i][0], this.headers[i][1]);
                }
            }
            SOAPPart soapPart = msg.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody body = envelope.getBody();
            Name nEx = envelope.createName("Execute", "", XMLA_URI);
            SOAPElement eEx = body.addChildElement(nEx);
            Name nCom = envelope.createName("Command", "", XMLA_URI);
            SOAPElement eCommand = eEx.addChildElement(nCom);
            Name nSta = envelope.createName("Statement", "", XMLA_URI);
            SOAPElement eStatement = eCommand.addChildElement(nSta);
            eStatement.addTextNode(query);
            HashMap<String, String> paraList = new HashMap<String, String>();
            paraList.put("DataSourceInfo", this.dataSource);
            paraList.put("Catalog", catalog);
            paraList.put("Format", "Multidimensional");
            paraList.put("AxisFormat", "TupleFormat");
            this.addParameterList(envelope, eEx, "Properties", "PropertyList", paraList);
            msg.saveChanges();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Query to Execute");
                this.logSoapMsg(msg);
            }
            reply = connection.call(msg, (Object)this.url);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Reply from Execute");
                this.logSoapMsg(reply);
            }
            this.errorCheck(reply);
            SOAPElement eRoot = this.findExecRoot(reply);
            Name name = envelope.createName("OlapInfo", "", MDD_URI);
            SOAPElement eOlapInfo = this.selectSingleNode(eRoot, name);
            if (eOlapInfo == null) {
                throw new OlapException("Excecute result has no eOlapInfo element");
            }
            name = envelope.createName("AxesInfo", "", MDD_URI);
            SOAPElement eAxesInfo = this.selectSingleNode(eOlapInfo, name);
            if (eAxesInfo == null) {
                throw new OlapException("Excecute result has no AxesInfo element");
            }
            name = envelope.createName("AxisInfo", "", MDD_URI);
            Iterator itAxisInfo = eAxesInfo.getChildElements(name);
            int iOrdinal = 0;
            while (itAxisInfo.hasNext()) {
                SOAPElement eAxisInfo = (SOAPElement)itAxisInfo.next();
                String axisName = eAxisInfo.getAttributeValue(name = envelope.createName("name"));
                int axisOrdinal = axisName.equals("SlicerAxis") ? -1 : iOrdinal++;
                handler.handleAxisInfo(axisName, axisOrdinal);
                name = envelope.createName("HierarchyInfo", "", MDD_URI);
                Iterator itHierInfo = eAxisInfo.getChildElements(name);
                int hierNumber = 0;
                while (itHierInfo.hasNext()) {
                    SOAPElement eHierInfo = (SOAPElement)itHierInfo.next();
                    name = envelope.createName("name");
                    String hierName = eHierInfo.getAttributeValue(name);
                    handler.handleHierInfo(hierName, axisOrdinal, hierNumber++);
                }
            }
            name = envelope.createName("Axes", "", MDD_URI);
            SOAPElement eAxes = this.selectSingleNode(eRoot, name);
            if (eAxes == null) {
                throw new OlapException("Excecute result has no Axes element");
            }
            name = envelope.createName("Axis", "", MDD_URI);
            Iterator itAxis = eAxes.getChildElements(name);
            iOrdinal = 0;
            while (itAxis.hasNext()) {
                SOAPElement eAxis = (SOAPElement)itAxis.next();
                String axisName = eAxis.getAttributeValue(name = envelope.createName("name"));
                int axisOrdinal = axisName.equals("SlicerAxis") ? -1 : iOrdinal++;
                handler.handleAxis(axisName, axisOrdinal);
                name = envelope.createName("Tuples", "", MDD_URI);
                SOAPElement eTuples = this.selectSingleNode(eAxis, name);
                if (eTuples == null) continue;
                name = envelope.createName("Tuple", "", MDD_URI);
                Iterator itTuple = eTuples.getChildElements(name);
                int positionOrdinal = 0;
                while (itTuple.hasNext()) {
                    SOAPElement eTuple = (SOAPElement)itTuple.next();
                    handler.handleTuple(axisOrdinal, positionOrdinal);
                    int index = 0;
                    name = envelope.createName("Member", "", MDD_URI);
                    Iterator itMember = eTuple.getChildElements(name);
                    while (itMember.hasNext()) {
                        SOAPElement eMem = (SOAPElement)itMember.next();
                        String uName = null;
                        String caption = null;
                        String levUname = null;
                        String displayInfo = null;
                        Iterator it = eMem.getChildElements();
                        HashMap<String, String> otherProps = new HashMap<String, String>();
                        while (it.hasNext()) {
                            Node n = (Node)it.next();
                            if (!(n instanceof SOAPElement)) continue;
                            SOAPElement el = (SOAPElement)n;
                            String enam = el.getElementName().getLocalName();
                            if (enam.equals("UName")) {
                                uName = el.getValue();
                                continue;
                            }
                            if (enam.equals("Caption")) {
                                caption = el.getValue();
                                continue;
                            }
                            if (enam.equals("LName")) {
                                levUname = el.getValue();
                                continue;
                            }
                            if (enam.equals("DisplayInfo")) {
                                displayInfo = el.getValue();
                                continue;
                            }
                            otherProps.put(enam, el.getValue());
                        }
                        handler.handleMember(uName, caption, levUname, displayInfo, otherProps, axisOrdinal, positionOrdinal, index);
                        ++index;
                    }
                    ++positionOrdinal;
                }
            }
            name = envelope.createName("CellData", "", MDD_URI);
            SOAPElement eCellData = this.selectSingleNode(eRoot, name);
            handler.handleCellData();
            name = envelope.createName("Cell", "", MDD_URI);
            Iterator itSoapCell = eCellData.getChildElements(name);
            while (itSoapCell.hasNext()) {
                SOAPElement eFmtValue;
                SOAPElement eCell = (SOAPElement)itSoapCell.next();
                name = envelope.createName("CellOrdinal", "", "");
                String cellOrdinal = eCell.getAttributeValue(name);
                int ordinal = Integer.parseInt(cellOrdinal);
                name = envelope.createName("Value", "", MDD_URI);
                SOAPElement eValue = this.selectSingleNode(eCell, name);
                Object value = null;
                if (eValue != null) {
                    name = envelope.createName("type", "xsi", XSI_URI);
                    String type = eValue.getAttributeValue(name);
                    value = "xsd:int".equals(type) ? new Long(eValue.getValue()) : ("xsd:double".equals(type) ? new Double(eValue.getValue()) : ("xsd:decimal".equals(type) ? new Double(eValue.getValue()) : eValue.getValue()));
                }
                String fmtValue = (eFmtValue = this.selectSingleNode(eCell, name = envelope.createName("FmtValue", "", MDD_URI))) != null ? eFmtValue.getValue() : "";
                name = envelope.createName("FontSize", "", MDD_URI);
                SOAPElement eFontSize = this.selectSingleNode(eCell, name);
                String fontSize = null;
                if (eFontSize != null) {
                    fontSize = eFontSize.getValue();
                }
                handler.handleCell(ordinal, value, fmtValue, fontSize);
            }
        }
        catch (SOAPException se) {
            throw new OlapException(se);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SOAPException e) {
                    logger.error((Object)"?", (Throwable)e);
                }
            }
        }
    }

    public void executeDrillQuery(String query, String catalog, QueryResultHandler handler) throws OlapException {
        SOAPConnection connection = null;
        SOAPMessage reply = null;
        try {
            connection = this.scf.createConnection();
            SOAPMessage msg = this.mf.createMessage();
            MimeHeaders mh = msg.getMimeHeaders();
            mh.setHeader("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Execute\"");
            if (this.headers != null) {
                for (int i = 0; i < this.headers.length; ++i) {
                    mh.setHeader(this.headers[i][0], this.headers[i][1]);
                }
            }
            SOAPPart soapPart = msg.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody body = envelope.getBody();
            Name nEx = envelope.createName("Execute", "", XMLA_URI);
            SOAPElement eEx = body.addChildElement(nEx);
            Name nCom = envelope.createName("Command", "", XMLA_URI);
            SOAPElement eCommand = eEx.addChildElement(nCom);
            Name nSta = envelope.createName("Statement", "", XMLA_URI);
            SOAPElement eStatement = eCommand.addChildElement(nSta);
            eStatement.addTextNode(query);
            HashMap<String, String> paraList = new HashMap<String, String>();
            paraList.put("DataSourceInfo", this.dataSource);
            paraList.put("Catalog", catalog);
            paraList.put("Format", "Tabular");
            this.addParameterList(envelope, eEx, "Properties", "PropertyList", paraList);
            msg.saveChanges();
            reply = connection.call(msg, (Object)this.url);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Reply from Execute");
                this.logSoapMsg(reply);
            }
            this.errorCheck(reply);
            SOAPElement eRoot = this.findDrillExecRoot(reply);
            Name name = envelope.createName("row", "", ROWS_URI);
            SOAPElement columnHeader = this.selectSingleNode(eRoot, name);
            if (columnHeader == null) {
                throw new OlapException("Excecute result has no rows element");
            }
            HashMap<String, Integer> colNames = new HashMap<String, Integer>();
            Iterator columnHeaderIt = columnHeader.getChildElements();
            int colIdx = 0;
            while (columnHeaderIt.hasNext()) {
                Object columnHeaderObj = columnHeaderIt.next();
                if (!(columnHeaderObj instanceof SOAPElement)) continue;
                String colName = ((SOAPElement)columnHeaderObj).getElementName().getLocalName();
                colNames.put(colName, new Integer(colIdx));
                ++colIdx;
            }
            ArrayList drillRows = new ArrayList();
            name = envelope.createName("row", "", ROWS_URI);
            Iterator rowIt = eRoot.getChildElements(name);
            while (rowIt.hasNext()) {
                SOAPElement rowElement = (SOAPElement)rowIt.next();
                Iterator rowDataIt = rowElement.getChildElements();
                Text child = (Text)rowDataIt.next();
                SOAPElement columnElement = child.getParentElement();
                Iterator columnIterator = columnElement.getChildElements();
                HashMap<String, String> dataRow = new HashMap<String, String>();
                while (columnIterator.hasNext()) {
                    Object colObject = columnIterator.next();
                    if (!(colObject instanceof SOAPElement)) continue;
                    String colName = ((SOAPElement)colObject).getElementName().getLocalName();
                    if (!colNames.containsKey(colName)) {
                        colNames.put(colName, new Integer(colIdx));
                        ++colIdx;
                    }
                    String colValue = ((SOAPElement)colObject).getValue();
                    dataRow.put(colName, colValue);
                }
                drillRows.add(dataRow);
            }
            handler.setDrillHeader(colNames);
            handler.setDrillRows(drillRows);
        }
        catch (SOAPException se) {
            throw new OlapException(se);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SOAPException e) {
                    logger.error((Object)"?", (Throwable)e);
                }
            }
        }
    }

    @Override
    public int getProvider() {
        return this.provider;
    }

    private int determineProvider(String dataSourceString) throws OlapException {
        logger.debug((Object)("determineProvider from dataSourceString: " + dataSourceString));
        if (dataSourceString == null) {
            throw new OlapException("No data source given for determining XML/A OLAP provider");
        }
        String upperDSString = dataSourceString.toUpperCase();
        if (!upperDSString.startsWith("PROVIDER=")) {
            throw new OlapException("Malformed data source given for determining XML/A provider");
        }
        if (upperDSString.startsWith("PROVIDER=SAP")) {
            logger.debug((Object)"Provider is SAP");
            return 2;
        }
        if (upperDSString.startsWith("PROVIDER=MONDRIAN")) {
            logger.debug((Object)"Provider is Mondrian");
            return 3;
        }
        if (upperDSString.startsWith("PROVIDER=MS")) {
            logger.debug((Object)"Provider is Microsoft");
            return 1;
        }
        if (upperDSString.startsWith("PROVIDER=MICROSOFT")) {
            logger.debug((Object)"Provider is Microsoft");
            return 1;
        }
        logger.error((Object)("Error determining provider from: " + dataSourceString));
        throw new OlapException("Unexpected data source determining XML/A provider");
    }

    private void setProviderAndDataSource(Map resMap) throws OlapException {
        if (resMap == null || resMap.size() == 0) {
            logger.error((Object)"No resource map from Discover Datasource");
            throw new OlapException("No resource map from Discover Datasource");
        }
        String pstr = (String)resMap.get("ProviderName");
        if (pstr == null) {
            throw new OlapException("No ProviderName from Discover Datasource");
        }
        this.provider = this.determineProvider("Provider=" + pstr);
        logger.debug((Object)("Provider ID: " + this.provider));
        if (this.provider == 2) {
            String dstr = (String)resMap.get("DataSourceDescription");
            if (dstr == null) {
                throw new OlapException("No DataSourceDescription from Discover Datasource");
            }
            this.dataSource = "Provider=" + pstr + ";DataSource=" + dstr;
        } else {
            logger.debug((Object)("DataSourceName: " + String.valueOf(resMap.get("DataSourceName"))));
            logger.debug((Object)("DataSourceInfo: " + String.valueOf(resMap.get("DataSourceInfo"))));
            this.dataSource = (String)resMap.get("DataSourceInfo");
            if (this.dataSource == null || this.dataSource.length() < 1) {
                this.dataSource = (String)resMap.get("DataSourceName");
            }
            if (this.dataSource == null) {
                throw new OlapException("No DataSourceName from Discover Datasource");
            }
        }
        logger.debug((Object)("Discover Datasource set: " + this.dataSource));
    }

    private int getProviderFromDiscoverResponse(SOAPEnvelope envelope, SOAPElement e) throws OlapException, SOAPException {
        Name name = e.getElementName();
        if (!name.getLocalName().equals("DiscoverResponse")) {
            throw new OlapException("Not a DiscoverResponse element. Was: " + name.getLocalName());
        }
        SOAPElement walker = this.getDiscoverReturn(envelope, e);
        if (walker == null) {
            throw new OlapException("Discover result has no DiscoverResponse/return element");
        }
        if ((walker = this.getDiscoverRoot(envelope, walker)) == null) {
            throw new OlapException("Discover result has no DiscoverResponse/return/root element");
        }
        if ((walker = this.getDiscoverRow(envelope, walker)) == null) {
            throw new OlapException("Discover result has no DiscoverResponse/return/root/row element");
        }
        String value = null;
        Iterator it = walker.getChildElements();
        while (it.hasNext()) {
            SOAPElement e2;
            String nameString;
            Object o = it.next();
            if (!(o instanceof SOAPElement) || !(nameString = (e2 = (SOAPElement)o).getElementName().getLocalName()).equals("ProviderName")) continue;
            value = e2.getValue();
            logger.debug((Object)("Found ProviderName with value: " + value));
            break;
        }
        if (value == null || value.trim().length() == 0) {
            throw new OlapException("Discover result has empty DiscoverResponse/return/root/row/ProviderName element");
        }
        return this.determineProvider("Provider=" + value);
    }

    private SOAPElement getDiscoverReturn(SOAPEnvelope envelope, SOAPElement e) throws OlapException, SOAPException {
        Name nReturn = this.provider == 1 ? envelope.createName("return", "m", XMLA_URI) : envelope.createName("return", "", XMLA_URI);
        SOAPElement eReturn = this.selectSingleNode(e, nReturn);
        if (eReturn == null && (eReturn = this.selectSingleNode(e, nReturn = envelope.createName("return", "", ""))) == null) {
            throw new OlapException("Discover result has no return element");
        }
        return eReturn;
    }

    private SOAPElement getDiscoverRoot(SOAPEnvelope envelope, SOAPElement e) throws OlapException, SOAPException {
        Name nRoot = envelope.createName("root", "", ROWS_URI);
        SOAPElement eRoot = this.selectSingleNode(e, nRoot);
        if (eRoot == null) {
            throw new OlapException("Discover result has no root element");
        }
        return eRoot;
    }

    private SOAPElement getDiscoverRow(SOAPEnvelope envelope, SOAPElement e) throws OlapException, SOAPException {
        Name nRow = envelope.createName("row", "", ROWS_URI);
        SOAPElement eRow = this.selectSingleNode(e, nRow);
        if (eRow == null) {
            throw new OlapException("Discover result has no row element");
        }
        return eRow;
    }

    private void discover(String request, URL url, Map restrictions, Map properties, Rowhandler rh) throws OlapException {
        try {
            SOAPConnection connection = this.scf.createConnection();
            SOAPMessage msg = this.mf.createMessage();
            MimeHeaders mh = msg.getMimeHeaders();
            mh.setHeader("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Discover\"");
            if (this.headers != null) {
                for (int i = 0; i < this.headers.length; ++i) {
                    mh.setHeader(this.headers[i][0], this.headers[i][1]);
                }
            }
            SOAPPart soapPart = msg.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody body = envelope.getBody();
            Name nDiscover = envelope.createName("Discover", "", XMLA_URI);
            SOAPElement eDiscover = body.addChildElement(nDiscover);
            Name nPara = envelope.createName("RequestType", "", XMLA_URI);
            SOAPElement eRequestType = eDiscover.addChildElement(nPara);
            eRequestType.addTextNode(request);
            if (restrictions != null) {
                this.addParameterList(envelope, eDiscover, "Restrictions", "RestrictionList", restrictions);
            }
            this.addParameterList(envelope, eDiscover, "Properties", "PropertyList", properties);
            msg.saveChanges();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Discover Request for " + request));
                this.logSoapMsg(msg);
            }
            SOAPMessage reply = connection.call(msg, (Object)url);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Discover Response for " + request));
                this.logSoapMsg(reply);
            }
            this.errorCheck(reply);
            SOAPElement eRoot = this.findDiscoverRoot(reply);
            Name nRow = envelope.createName("row", "", ROWS_URI);
            Iterator itRow = eRoot.getChildElements(nRow);
            while (itRow.hasNext()) {
                SOAPElement eRow = (SOAPElement)itRow.next();
                rh.handleRow(eRow, envelope);
            }
            connection.close();
        }
        catch (UnsupportedOperationException e) {
            throw new OlapException(e);
        }
        catch (SOAPException e) {
            throw new OlapException(e);
        }
    }

    private void addParameterList(SOAPEnvelope envelope, SOAPElement eParent, String typeName, String listName, Map params) throws SOAPException {
        Name nPara = envelope.createName(typeName, "", XMLA_URI);
        SOAPElement eType = eParent.addChildElement(nPara);
        nPara = envelope.createName(listName, "", XMLA_URI);
        SOAPElement eList = eType.addChildElement(nPara);
        if (params == null) {
            return;
        }
        for (String tag : params.keySet()) {
            String value = (String)params.get(tag);
            nPara = envelope.createName(tag, "", XMLA_URI);
            SOAPElement eTag = eList.addChildElement(nPara);
            eTag.addTextNode(value);
        }
    }

    private void errorCheck(SOAPMessage reply) throws SOAPException, OlapException {
        String[] strings = new String[4];
        if (this.soapFault(reply, strings)) {
            String faultString = "Soap Fault code=" + strings[0] + " fault string=" + strings[1] + " fault actor=" + strings[2];
            if (strings[3] != null) {
                faultString = faultString + "\ndetail:" + strings[3];
            }
            throw new OlapException(faultString);
        }
    }

    private SOAPElement selectSingleNode(SOAPElement contextNode, Name childName) {
        Iterator it = contextNode.getChildElements(childName);
        if (it.hasNext()) {
            return (SOAPElement)it.next();
        }
        return null;
    }

    private SOAPElement findDiscoverRoot(SOAPMessage reply) throws SOAPException, OlapException {
        SOAPElement eReturn;
        SOAPPart sp = reply.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPElement eResponse = null;
        if (this.provider == 0) {
            Iterator itBody = body.getChildElements();
            while (itBody.hasNext()) {
                Name name;
                Node n = (Node)itBody.next();
                if (!(n instanceof SOAPElement) || !(name = ((SOAPElement)n).getElementName()).getLocalName().equals("DiscoverResponse")) continue;
                eResponse = (SOAPElement)n;
                this.provider = this.getProviderFromDiscoverResponse(envelope, eResponse);
                break;
            }
            if (eResponse == null) {
                throw new OlapException("Discover result has no DiscoverResponse element");
            }
        } else {
            Name childName;
            if (this.provider == 1) {
                childName = envelope.createName("DiscoverResponse", "m", XMLA_URI);
            } else if (this.provider == 2 || this.provider == 3) {
                childName = envelope.createName("DiscoverResponse", "", XMLA_URI);
            } else {
                throw new IllegalArgumentException("no a valid provider specification");
            }
            eResponse = this.selectSingleNode((SOAPElement)body, childName);
            if (eResponse == null) {
                throw new OlapException("Discover result has no DiscoverResponse element");
            }
        }
        if ((eReturn = this.getDiscoverReturn(envelope, eResponse)) == null) {
            throw new OlapException("Discover result has no return element");
        }
        SOAPElement eRoot = this.getDiscoverRoot(envelope, eReturn);
        if (eRoot == null) {
            throw new OlapException("Discover result has no root element");
        }
        return eRoot;
    }

    private void logSoapMsg(SOAPMessage msg) {
        try {
            StringWriter writer = new StringWriter();
            TransformerFactory tFact = TransformerFactory.newInstance();
            Transformer transformer = tFact.newTransformer();
            Source src = msg.getSOAPPart().getContent();
            StreamResult result = new StreamResult(writer);
            transformer.transform(src, result);
            logger.debug((Object)((Object)writer).toString());
        }
        catch (Exception e) {
            logger.error((Object)"?", (Throwable)e);
        }
    }

    private boolean soapFault(SOAPMessage reply, String[] faults) throws SOAPException {
        SOAPPart sp = reply.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPBody body = envelope.getBody();
        if (!body.hasFault()) {
            return false;
        }
        SOAPFault fault = body.getFault();
        faults[0] = fault.getFaultCode();
        faults[1] = fault.getFaultString();
        faults[2] = fault.getFaultActor();
        Detail detail = fault.getDetail();
        if (detail == null) {
            return true;
        }
        String detailMsg = "";
        Iterator it = detail.getDetailEntries();
        while (it.hasNext()) {
            DetailEntry det = (DetailEntry)it.next();
            Iterator ita = det.getAllAttributes();
            boolean cont = false;
            while (ita.hasNext()) {
                Name name = (Name)ita.next();
                if (cont) {
                    detailMsg = detailMsg + "; ";
                }
                detailMsg = detailMsg + name.getLocalName();
                detailMsg = detailMsg + " = ";
                detailMsg = detailMsg + det.getAttributeValue(name);
                cont = true;
            }
        }
        faults[3] = detailMsg;
        return true;
    }

    private SOAPElement findExecRoot(SOAPMessage reply) throws SOAPException, OlapException {
        Name name;
        SOAPPart sp = reply.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPElement eResponse = this.selectSingleNode((SOAPElement)body, name = this.provider == 2 ? envelope.createName("ExecuteResponse", "", XMLA_URI) : envelope.createName("ExecuteResponse", "m", XMLA_URI));
        if (eResponse == null) {
            throw new OlapException("Excecute result has no ExecuteResponse element");
        }
        name = this.provider == 2 ? envelope.createName("return", "", XMLA_URI) : envelope.createName("return", "m", XMLA_URI);
        SOAPElement eReturn = this.selectSingleNode(eResponse, name);
        if (eReturn == null && (eReturn = this.selectSingleNode(eResponse, name = envelope.createName("return", "", ""))) == null) {
            throw new OlapException("Excecute result has no ExecuteResponse element");
        }
        name = envelope.createName("root", "", MDD_URI);
        SOAPElement eRoot = this.selectSingleNode(eReturn, name);
        if (eRoot == null) {
            throw new OlapException("Excecute result has no root element");
        }
        return eRoot;
    }

    private SOAPElement findDrillExecRoot(SOAPMessage reply) throws SOAPException, OlapException {
        Name name;
        SOAPPart sp = reply.getSOAPPart();
        SOAPEnvelope envelope = sp.getEnvelope();
        SOAPBody body = envelope.getBody();
        SOAPElement eResponse = this.selectSingleNode((SOAPElement)body, name = this.provider == 2 ? envelope.createName("ExecuteResponse", "", XMLA_URI) : envelope.createName("ExecuteResponse", "m", XMLA_URI));
        if (eResponse == null) {
            throw new OlapException("Excecute result has no ExecuteResponse element");
        }
        name = this.provider == 2 ? envelope.createName("return", "", XMLA_URI) : envelope.createName("return", "m", XMLA_URI);
        SOAPElement eReturn = this.selectSingleNode(eResponse, name);
        if (eReturn == null) {
            throw new OlapException("Excecute result has no return element");
        }
        name = envelope.createName("root", "", ROWS_URI);
        SOAPElement eRoot = this.selectSingleNode(eReturn, name);
        if (eRoot == null) {
            throw new OlapException("Excecute result has no root element");
        }
        return eRoot;
    }

    public String[][] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String[][] headers) {
        this.headers = headers;
    }

    static interface Rowhandler {
        public void handleRow(SOAPElement var1, SOAPEnvelope var2);
    }
}

