/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.BlankAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.CreateAttribute;
import org.pentaho.agilebi.modeler.models.annotations.CreateCalculatedMember;
import org.pentaho.agilebi.modeler.models.annotations.CreateDimensionKey;
import org.pentaho.agilebi.modeler.models.annotations.CreateMeasure;
import org.pentaho.agilebi.modeler.models.annotations.LinkDimension;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ShowHideAttribute;
import org.pentaho.agilebi.modeler.models.annotations.ShowHideMeasure;
import org.pentaho.agilebi.modeler.models.annotations.UpdateAttribute;
import org.pentaho.agilebi.modeler.models.annotations.UpdateCalculatedMember;
import org.pentaho.agilebi.modeler.models.annotations.UpdateMeasure;
import org.pentaho.agilebi.modeler.models.annotations.data.ColumnMapping;
import org.pentaho.agilebi.modeler.models.annotations.data.DataProvider;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.metadata.model.concept.types.DataType;
import org.w3c.dom.Node;

public class ModelAnnotationGroupXmlReader {
    public ModelAnnotationGroup readModelAnnotationGroup(Node step) throws KettleXMLException {
        ModelAnnotationGroup modelAnnotationGroup = new ModelAnnotationGroup();
        Node annotations = XMLHandler.getSubNode((Node)step, (String)"annotations");
        int annotationsCount = XMLHandler.countNodes((Node)annotations, (String)"annotation");
        for (int i = 0; i < annotationsCount; ++i) {
            try {
                Node annotation = XMLHandler.getSubNodeByNr((Node)annotations, (String)"annotation", (int)i);
                String name = XMLHandler.getTagValue((Node)annotation, (String)"name");
                String field = XMLHandler.getTagValue((Node)annotation, (String)"field");
                String type = XMLHandler.getTagValue((Node)annotation, (String)"type");
                Node properties = XMLHandler.getSubNode((Node)annotation, (String)"properties");
                int propertiesCount = XMLHandler.countNodes((Node)properties, (String)"property");
                ModelAnnotation<?> modelAnnotation = ModelAnnotationGroupXmlReader.create(type, field);
                if (StringUtils.isNotBlank((String)name)) {
                    modelAnnotation.setName(name);
                }
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                for (int j = 0; j < propertiesCount; ++j) {
                    Node property = XMLHandler.getSubNodeByNr((Node)properties, (String)"property", (int)j);
                    String n = XMLHandler.getTagValue((Node)property, (String)"name");
                    String v = XMLHandler.getTagValue((Node)property, (String)"value");
                    map.put(n, (Serializable)((Object)v));
                }
                modelAnnotation.populateAnnotation(map);
                modelAnnotationGroup.add(modelAnnotation);
                continue;
            }
            catch (KettleException kettleException) {
                // empty catch block
            }
        }
        modelAnnotationGroup.setSharedDimension(BooleanUtils.toBoolean((String)XMLHandler.getTagValue((Node)annotations, (String)"sharedDimension")));
        modelAnnotationGroup.setDescription(XMLHandler.getTagValue((Node)annotations, (String)"description"));
        this.readDataProviders(annotations, modelAnnotationGroup);
        return modelAnnotationGroup;
    }

    public void readDataProviders(Node node, ModelAnnotationGroup group) {
        if (node == null || group == null) {
            return;
        }
        ArrayList<DataProvider> dataProviders = new ArrayList<DataProvider>();
        Node dataProvidersNode = XMLHandler.getSubNode((Node)node, (String)"data-providers");
        int dataProviderCount = XMLHandler.countNodes((Node)dataProvidersNode, (String)"data-provider");
        for (int i = 0; i < dataProviderCount; ++i) {
            try {
                Node dataProviderNode = XMLHandler.getSubNodeByNr((Node)dataProvidersNode, (String)"data-provider", (int)i);
                DataProvider dataProvider = new DataProvider();
                dataProvider.setName(XMLHandler.getTagValue((Node)dataProviderNode, (String)"name"));
                dataProvider.setSchemaName(XMLHandler.getTagValue((Node)dataProviderNode, (String)"schemaName"));
                dataProvider.setTableName(XMLHandler.getTagValue((Node)dataProviderNode, (String)"tableName"));
                dataProvider.setDatabaseMetaNameRef(XMLHandler.getTagValue((Node)dataProviderNode, (String)"databaseMetaRef"));
                this.readColumnMappings(dataProviderNode, dataProvider);
                dataProviders.add(dataProvider);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        group.setDataProviders(dataProviders);
    }

    public void readColumnMappings(Node dataProviderNode, DataProvider dataProvider) {
        if (dataProviderNode == null || dataProvider == null) {
            return;
        }
        ArrayList<ColumnMapping> columnMappings = new ArrayList<ColumnMapping>();
        Node columnMappingNodes = XMLHandler.getSubNode((Node)dataProviderNode, (String)"column-mappings");
        int columnMappingCount = XMLHandler.countNodes((Node)columnMappingNodes, (String)"column-mapping");
        for (int i = 0; i < columnMappingCount; ++i) {
            try {
                Node columnMappingNode = XMLHandler.getSubNodeByNr((Node)columnMappingNodes, (String)"column-mapping", (int)i);
                ColumnMapping columnMapping = new ColumnMapping();
                columnMapping.setName(XMLHandler.getTagValue((Node)columnMappingNode, (String)"name"));
                columnMapping.setColumnName(XMLHandler.getTagValue((Node)columnMappingNode, (String)"columnName"));
                String dataType = XMLHandler.getTagValue((Node)columnMappingNode, (String)"dataType");
                if (StringUtils.isNotBlank((String)dataType)) {
                    columnMapping.setColumnDataType(DataType.valueOf((String)dataType));
                }
                columnMappings.add(columnMapping);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        dataProvider.setColumnMappings(columnMappings);
    }

    public static ModelAnnotation<?> create(String annotationType, String field) throws KettleException {
        if (annotationType != null) {
            return ModelAnnotationGroupXmlReader.create(ModelAnnotation.Type.valueOf(annotationType), field);
        }
        return new ModelAnnotation();
    }

    private static ModelAnnotation<? extends AnnotationType> create(ModelAnnotation.Type annotationType, String field) {
        switch (annotationType) {
            case CREATE_ATTRIBUTE: {
                CreateAttribute ca = new CreateAttribute();
                ca.setField(field);
                return new ModelAnnotation<CreateAttribute>(ca);
            }
            case CREATE_MEASURE: {
                CreateMeasure cm = new CreateMeasure();
                cm.setField(field);
                return new ModelAnnotation<CreateMeasure>(cm);
            }
            case CREATE_DIMENSION_KEY: {
                CreateDimensionKey cdk = new CreateDimensionKey();
                cdk.setField(field);
                return new ModelAnnotation<CreateDimensionKey>(cdk);
            }
            case LINK_DIMENSION: {
                LinkDimension ld = new LinkDimension();
                ld.setField(field);
                return new ModelAnnotation<LinkDimension>(ld);
            }
            case UPDATE_MEASURE: {
                UpdateMeasure um = new UpdateMeasure();
                return new ModelAnnotation<UpdateMeasure>(um);
            }
            case CREATE_CALCULATED_MEMBER: {
                CreateCalculatedMember calculatedMember = new CreateCalculatedMember();
                return new ModelAnnotation<CreateCalculatedMember>(calculatedMember);
            }
            case UPDATE_CALCULATED_MEMBER: {
                UpdateCalculatedMember updateCalculatedMember = new UpdateCalculatedMember();
                return new ModelAnnotation<UpdateCalculatedMember>(updateCalculatedMember);
            }
            case SHOW_HIDE_ATTRIBUTE: {
                ShowHideAttribute hideAttribute = new ShowHideAttribute();
                return new ModelAnnotation<ShowHideAttribute>(hideAttribute);
            }
            case SHOW_HIDE_MEASURE: {
                ShowHideMeasure hideMeasure = new ShowHideMeasure();
                return new ModelAnnotation<ShowHideMeasure>(hideMeasure);
            }
            case UPDATE_ATTRIBUTE: {
                UpdateAttribute updateAttribute = new UpdateAttribute();
                return new ModelAnnotation<UpdateAttribute>(updateAttribute);
            }
        }
        BlankAnnotation ba = new BlankAnnotation();
        ba.setField(field);
        return new ModelAnnotation<BlankAnnotation>(ba);
    }
}

