/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.util.Arrays;
import java.util.List;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.nodes.BaseAggregationMetaDataNode;
import org.pentaho.agilebi.modeler.nodes.CategoryMetaData;
import org.pentaho.agilebi.modeler.propforms.FieldsPropertiesForm;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.ui.xul.stereotype.Bindable;

public class FieldMetaData
extends BaseAggregationMetaDataNode {
    private static final String IMAGE = "images/fields.png";
    private static final long serialVersionUID = -7091129923372909756L;

    public FieldMetaData(String locale) {
        super(locale);
    }

    public FieldMetaData(CategoryMetaData parent, String fieldName, String format, String displayName, String locale) {
        super(fieldName, format, displayName, locale);
        this.setParent(parent);
    }

    @Override
    public List<AggregationType> getNumericAggregationTypes() {
        return Arrays.asList(AggregationType.NONE, AggregationType.SUM, AggregationType.AVERAGE, AggregationType.MINIMUM, AggregationType.MAXIMUM, AggregationType.COUNT, AggregationType.COUNT_DISTINCT);
    }

    @Override
    public List<AggregationType> getTextAggregationTypes() {
        return Arrays.asList(AggregationType.NONE, AggregationType.COUNT, AggregationType.COUNT_DISTINCT);
    }

    @Override
    public String getValidImage() {
        return IMAGE;
    }

    @Override
    public Class<? extends ModelerNodePropertiesForm<BaseAggregationMetaDataNode>> getPropertiesForm() {
        return FieldsPropertiesForm.class;
    }

    @Override
    public void validate() {
        this.valid = true;
        this.validationMessages.clear();
        if (this.name == null || "".equals(this.name)) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.field.MISSING_NAME", new String[0]));
            this.valid = false;
        }
        if (this.logicalColumn == null) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.field.MISSING_BACKING_COLUMN", this.getName()));
            this.valid = false;
        }
    }

    @Override
    @Bindable
    public AggregationType getDefaultAggregation() {
        if (this.logicalColumn == null) {
            return null;
        }
        if (this.defaultAggregation == null) {
            this.defaultAggregation = AggregationType.NONE;
        }
        return this.defaultAggregation;
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        return false;
    }
}

