/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.propforms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.nodes.BaseAggregationMetaDataNode;
import org.pentaho.agilebi.modeler.propforms.MeasuresPropertiesForm;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.stereotype.Bindable;

public class FieldsPropertiesForm
extends MeasuresPropertiesForm {
    private static final long serialVersionUID = 1554704803752425723L;
    private static final String ID = "fieldprops";
    private Collection<AggregationType> selectedAggregations;
    private XulButton messageBtn;

    public FieldsPropertiesForm(String locale) {
        super(ID, locale);
    }

    public FieldsPropertiesForm(String panelId, String locale) {
        super(panelId, locale);
    }

    @Override
    @Bindable
    public void init(ModelerWorkspace workspace) {
        this.workspace = workspace;
        this.deck = (XulDeck)this.document.getElementById("propertiesdeck");
        this.panel = (XulVbox)this.document.getElementById(ID);
        XulMenuList formatFieldList = (XulMenuList)this.document.getElementById("fieldformatstring");
        this.bf.createBinding((Object)this, "notValid", "fieldmessages", "visible", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "validMessages", "fieldmessageslabel", "value", new BindingConvertor[]{validMsgTruncatedBinding});
        this.bf.createBinding((Object)this, "displayName", "fielddisplayname", "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "possibleAggregations", "field_optionalAggregationTypes", "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "selectedAggregations", "field_optionalAggregationTypes", "selectedItems", new BindingConvertor[]{BindingConvertor.collection2ObjectArray()});
        this.bf.createBinding((Object)this, "possibleAggregations", "field_defaultAggregation", "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "defaultAggregation", "field_defaultAggregation", "selectedItem", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "format", (Object)formatFieldList, "value", new BindingConvertor[]{new FormatStringConverter()});
        this.bf.createBinding((Object)this, "formatstring", (Object)formatFieldList, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "backingColumnAvailable", "fixFieldColumnsBtn", "!visible", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "columnName", "field_column_name", "value", new BindingConvertor[0]);
        this.messageBtn = (XulButton)this.document.getElementById("field_message_btn");
        this.bf.createBinding((Object)this, "validMessages", (Object)this.messageBtn, "visible", new BindingConvertor[]{showMsgBinding});
    }

    @Override
    public void setObject(BaseAggregationMetaDataNode t) {
        this.selectedAggregations = null;
        super.setObject(t);
        if (t == null) {
            return;
        }
        AggregationType aggType = t.getDefaultAggregation();
        this.setSelectedAggregations(t.getSelectedAggregations());
        this.setDefaultAggregation(aggType);
    }

    @Override
    @Bindable
    public void setPossibleAggregations(Vector aggTypes) {
        this.aggTypes = aggTypes;
        this.firePropertyChange("possibleAggregations", null, aggTypes);
        if (this.getNode() != null) {
            this.setSelectedAggregations(aggTypes);
        }
    }

    @Bindable
    public void setSelectedAggregations(Collection<AggregationType> selectedAggs) {
        Collection<AggregationType> prevVal = this.selectedAggregations;
        this.selectedAggregations = selectedAggs;
        if (this.getNode() != null) {
            ((BaseAggregationMetaDataNode)this.getNode()).setSelectedAggregations(new ArrayList<AggregationType>(selectedAggs));
        }
        if (prevVal == null || !prevVal.equals(this.selectedAggregations)) {
            this.firePropertyChange("selectedAggregations", null, this.selectedAggregations);
        }
    }

    @Bindable
    public List<AggregationType> getSelectedAggregations() {
        if (this.getNode() != null) {
            return ((BaseAggregationMetaDataNode)this.getNode()).getSelectedAggregations();
        }
        return Collections.emptyList();
    }

    private static class FormatStringConverter
    extends BindingConvertor<String, String> {
        private FormatStringConverter() {
        }

        public String sourceToTarget(String value) {
            if (value == null) {
                return "NONE";
            }
            return value;
        }

        public String targetToSource(String value) {
            if (value.equalsIgnoreCase("NONE")) {
                return null;
            }
            return value;
        }
    }
}

