/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mondrian.publish;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.swing.JOptionPane;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.pentaho.mondrian.publish.Base64;
import org.pentaho.mondrian.publish.Messages;
import org.pentaho.mondrian.publish.OverwriteSchemaDialog;
import org.pentaho.mondrian.publish.PublishException;
import org.pentaho.mondrian.publish.PublishSchemaPluginParent;
import org.pentaho.mondrian.publish.RepositoryLoginDialog;
import org.pentaho.mondrian.publish.workbench.PublishUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PublishToServerCommand {
    private static final Logger LOG = Logger.getLogger(PublishToServerCommand.class.getName());
    private static final String DEFAULT_SERVER_LOCATION = "http://localhost:8080/pentaho/";
    private static final String PUBLISH_WEB_LOCATION = "pentahoPublishWebLocation";
    private static final String PUBLISH_WEB_LOCATIONS = "pentahoPublishWebLocations";
    private static final String PUBLISH_USER_ID = "pentahoPublishUserId";
    private static final String PUBLISH_USER_IDS = "pentahoPublishUserIds";
    private static final String PUBLISH_USER_PASSWORD = "pentahoUserPassword";
    private static final String PUBLISH_USER_PASSWORDS = "pentahoUserPasswords";
    private static final String PUBLISH_JNDI_NAME = "pentahoPublishJndiName";
    private static final String PUBLISH_ENABLE_XMLA = "pentahoPublishEnableXmla";
    private static final String DELIMITER = "\t";
    private static final String MONDRIAN_SCHEMA_IMPORT_URL = "plugin/data-access/api/mondrian/putSchema";
    private static final String RESERVED_CHARS_URL = "api/repo/files/reservedCharacters";
    private SecretKeyFactory keyFactory;
    private Cipher cipher;
    private SecretKey encryptionKey;

    public PublishToServerCommand() {
        try {
            byte[] keyAsBytes = "abcdefghijkPENTAHOlmnopqrstuvw5xyz".getBytes("UTF8");
            DESedeKeySpec keySpec = new DESedeKeySpec(keyAsBytes);
            this.keyFactory = SecretKeyFactory.getInstance("DESede");
            this.encryptionKey = this.keyFactory.generateSecret(keySpec);
            this.cipher = Cipher.getInstance("DESede");
        }
        catch (Exception e) {
            LOG.severe("failed to initialize password encryption");
            e.printStackTrace();
        }
    }

    private String encryptPassword(String password) {
        if (password == null || password.trim().length() == 0) {
            return password;
        }
        try {
            this.cipher.init(1, this.encryptionKey);
            byte[] cleartext = password.getBytes("UTF8");
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            return Base64.encodeBytes(ciphertext);
        }
        catch (Exception e) {
            LOG.severe("failed to encrypt password");
            e.printStackTrace();
            return null;
        }
    }

    private String decryptPassword(String encryptedPassword) {
        if (encryptedPassword == null || encryptedPassword.trim().length() == 0) {
            return encryptedPassword;
        }
        try {
            this.cipher.init(2, this.encryptionKey);
            byte[] cleartext = Base64.decode(encryptedPassword);
            byte[] ciphertext = this.cipher.doFinal(cleartext);
            return new String(ciphertext, "UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> splitProperties(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value == null) {
            return list;
        }
        String[] items = value.split(DELIMITER);
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].trim().length() <= 0) continue;
            list.add(items[i]);
        }
        return list;
    }

    private String getListAsString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                sb.append(DELIMITER);
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }

    public void execute(PublishSchemaPluginParent parent) {
        String publishURL = parent.getProperty(PUBLISH_WEB_LOCATION);
        if (StringUtils.isEmpty((String)publishURL)) {
            publishURL = DEFAULT_SERVER_LOCATION;
        }
        String user = parent.getProperty(PUBLISH_USER_ID);
        String userPassword = this.decryptPassword(parent.getProperty(PUBLISH_USER_PASSWORD));
        boolean enableXmla = "true".equals(parent.getProperty(PUBLISH_ENABLE_XMLA));
        String jndiName = parent.getProperty(PUBLISH_JNDI_NAME);
        if (StringUtils.isEmpty((String)jndiName)) {
            jndiName = "FoodMart";
        }
        List<String> publishLocations = this.splitProperties(parent.getProperty(PUBLISH_WEB_LOCATIONS));
        List<String> publishUserIds = this.splitProperties(parent.getProperty(PUBLISH_USER_IDS));
        List<String> publishUserPasswords = this.splitProperties(this.decryptPassword(parent.getProperty(PUBLISH_USER_PASSWORDS)));
        RepositoryLoginDialog loginDialog = new RepositoryLoginDialog(parent.getFrame(), publishURL, publishLocations, publishUserIds, publishUserPasswords, jndiName, enableXmla);
        loginDialog.setLocationRelativeTo(parent.getFrame());
        loginDialog.setVisible(true);
        if (loginDialog.isPublishPressed()) {
            publishURL = loginDialog.getServerURL();
            user = loginDialog.getUsername();
            userPassword = loginDialog.getUserPassword();
            jndiName = loginDialog.getJndiDataSourceName();
            enableXmla = loginDialog.getEnableXmla();
            if (loginDialog.getRememberSettings()) {
                int index;
                parent.setProperty(PUBLISH_WEB_LOCATION, publishURL);
                parent.setProperty(PUBLISH_USER_ID, user);
                parent.setProperty(PUBLISH_USER_PASSWORD, this.encryptPassword(userPassword));
                parent.setProperty(PUBLISH_JNDI_NAME, jndiName);
                parent.setProperty(PUBLISH_ENABLE_XMLA, enableXmla ? "true" : "false");
                if (!publishLocations.contains(publishURL)) {
                    publishLocations.add(publishURL);
                    parent.setProperty(PUBLISH_WEB_LOCATIONS, this.getListAsString(publishLocations));
                }
                if ((index = publishLocations.indexOf(publishURL)) >= 0 && index < publishUserIds.size()) {
                    publishUserIds.remove(index);
                    publishUserIds.add(index, user);
                } else {
                    publishUserIds.add(user);
                }
                parent.setProperty(PUBLISH_USER_IDS, this.getListAsString(publishUserIds));
                if (index >= 0 && index < publishUserPasswords.size()) {
                    publishUserPasswords.remove(index);
                    publishUserPasswords.add(index, userPassword);
                } else {
                    publishUserPasswords.add(userPassword);
                }
                parent.setProperty(PUBLISH_USER_PASSWORDS, this.encryptPassword(this.getListAsString(publishUserPasswords)));
                parent.storeProperties();
            }
            try {
                try {
                    String publisherUrl = publishURL;
                    PublishUtil.fetchReservedChars(publishURL, user, userPassword);
                    if (!publishURL.endsWith("/")) {
                        publisherUrl = publisherUrl + "/";
                    }
                    publisherUrl = publisherUrl + MONDRIAN_SCHEMA_IMPORT_URL;
                    String message = "";
                    int statusCode = this.publish(publisherUrl, user, userPassword, jndiName, enableXmla, false, parent.getSchemaFile());
                    if (statusCode == 1 || statusCode == 2) {
                        message = Messages.getString("PublishToServerCommand.Failed");
                    } else if (statusCode == 3) {
                        message = Messages.getString("PublishToServerCommand.Successful");
                    } else if (statusCode == 4) {
                        message = Messages.getString("PublishToServerCommand.InvalidPassword");
                    } else if (statusCode == 5) {
                        message = Messages.getString("PublishToServerCommand.InvalidUsernameOrPassword");
                    } else if (statusCode == 6) {
                        message = Messages.getString("PublishToServerCommand.DataSourceProblem", jndiName);
                    } else if (statusCode == 7 || statusCode == 8) {
                        message = Messages.getString("PublishToServerCommand.XMLACatalogExists");
                        if (statusCode == 8) {
                            message = Messages.getString("PublishToServerCommand.XMLASchemaExists");
                        }
                        OverwriteSchemaDialog overwriteDialog = new OverwriteSchemaDialog((Frame)parent.getFrame(), parent.getSchemaFile().getName());
                        overwriteDialog.setLocationRelativeTo(parent.getFrame());
                        overwriteDialog.setVisible(true);
                        boolean overwrite = overwriteDialog.isOkPressed();
                        if (overwrite && (statusCode = this.publish(publisherUrl, user, userPassword, jndiName, enableXmla, true, parent.getSchemaFile())) == 3) {
                            message = Messages.getString("PublishToServerCommand.Successful");
                        }
                    } else {
                        message = statusCode == 99 ? Messages.getString("PublishToServerCommand.ReservedCharsViolation", PublishUtil.getReservedCharsDisplay()) : Messages.getString("PublishToServerCommand.Failed");
                    }
                    if (message.length() > 0) {
                        JOptionPane.showMessageDialog(parent.getFrame(), message.trim(), Messages.getString("PublishToServerCommand.Information.Title"), 1);
                    }
                }
                catch (PublishException e1) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "PublishToServerCommand.actionPerformed ", e1);
                    }
                    JOptionPane.showMessageDialog(parent.getFrame(), Messages.getString("PublishToServerCommand.Error.Message", e1.getMessage()), Messages.getString("PublishToServerCommand.Error.Title"), 0);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(parent.getFrame(), Messages.getString("PublishToServerCommand.Error.Message", e1.getMessage()), Messages.getString("PublishToServerCommand.Error.Title"), 0);
            }
        }
    }

    private int publish(String publishURL, String serverUserId, String serverPassword, String jndiName, boolean enableXmla, boolean overwrite, File schemaFile) throws PublishException, UnsupportedEncodingException {
        try {
            FileInputStream inputStream = new FileInputStream(schemaFile);
            String catalogName = this.determineDomainCatalogName(new FileInputStream(schemaFile), schemaFile.getName());
            if (!PublishUtil.validateName(catalogName) || !PublishUtil.validateName(schemaFile.getName())) {
                return 99;
            }
            FormDataMultiPart part = new FormDataMultiPart().field("uploadAnalysis", (Object)inputStream, MediaType.MULTIPART_FORM_DATA_TYPE).field("catalogName", (Object)catalogName, MediaType.MULTIPART_FORM_DATA_TYPE).field("Datasource", (Object)jndiName, MediaType.MULTIPART_FORM_DATA_TYPE).field("overwrite", (Object)(overwrite ? "true" : "false"), MediaType.MULTIPART_FORM_DATA_TYPE).field("xmlaEnabledFlag", (Object)(enableXmla ? "true" : "false"), MediaType.MULTIPART_FORM_DATA_TYPE).field("parameters", (Object)("Datasource=" + jndiName), MediaType.MULTIPART_FORM_DATA_TYPE);
            part.getField("uploadAnalysis").setContentDisposition((ContentDisposition)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"uploadAnalysis").fileName(schemaFile.getName())).build());
            Client client = Client.create();
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(serverUserId, serverPassword));
            LOG.fine("PUBLISH URL PATH : " + publishURL);
            WebResource resource = client.resource(publishURL);
            ClientResponse response = (ClientResponse)resource.type(MediaType.MULTIPART_FORM_DATA_TYPE).put(ClientResponse.class, (Object)part);
            return response != null ? response.getStatus() : -1;
        }
        catch (FileNotFoundException e) {
            throw new PublishException("Unable to publish Mondrian Schema");
        }
    }

    private String determineDomainCatalogName(InputStream dataInputStream, String fileName) {
        String domainId = "";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(dataInputStream);
            NodeList schemas = document.getElementsByTagName("Schema");
            Node schema = schemas.item(0);
            Node name = schema.getAttributes().getNamedItem("name");
            domainId = name.getTextContent();
            dataInputStream.reset();
        }
        catch (Exception e) {
            LOG.fine("Problem occurred when trying to get schema name from document. Using filename instead.");
        }
        if ("".equals(domainId)) {
            domainId = fileName;
        }
        return domainId;
    }
}

