/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mondrian.publish.workbench;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PublishUtil {
    private static final Logger LOG = Logger.getLogger(PublishUtil.class.getName());
    private static final String RESERVED_CHARS_URL = "api/repo/files/reservedCharacters";
    private static final String RESERVED_CHARS_URL_DISPLAY = "api/repo/files/reservedCharactersDisplay";
    protected static String reservedChars = "/\\\t\r\n";
    protected static String reservedCharsDisplay = "/, \\, TAB, CR, LF";
    private static Pattern containsReservedCharsPattern = PublishUtil.makePattern(reservedChars);

    private static Pattern makePattern(String reservedChars) {
        StringBuilder buf = new StringBuilder();
        buf.append(".*[");
        for (int i = 0; i < reservedChars.length(); ++i) {
            buf.append("\\");
            buf.append(reservedChars.substring(i, i + 1));
        }
        buf.append("]+.*");
        return Pattern.compile(buf.toString());
    }

    public static boolean validateName(String name) {
        return !StringUtils.isEmpty((String)name) && name.trim().equals(name) && !containsReservedCharsPattern.matcher(name).matches() && !".".equals(name) && !"..".equals(name);
    }

    public static void setReservedChars(String reservedChars) {
        containsReservedCharsPattern = PublishUtil.makePattern(reservedChars);
    }

    public static Pattern getPattern() {
        return containsReservedCharsPattern;
    }

    public static String getReservedCharsDisplay() {
        return reservedCharsDisplay;
    }

    public static void setReservedCharsDisplay(String reservedCharsDisplay) {
        PublishUtil.reservedCharsDisplay = reservedCharsDisplay;
    }

    public static void fetchReservedChars(String urlPart, String username, String password) {
        if (!urlPart.endsWith("/")) {
            urlPart = urlPart + "/";
        }
        Client client = Client.create();
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        try {
            String url = urlPart.concat(RESERVED_CHARS_URL);
            WebResource resource = client.resource(url);
            PublishUtil.setReservedChars((String)resource.get(String.class));
            url = urlPart.concat(RESERVED_CHARS_URL_DISPLAY);
            resource = client.resource(url);
            PublishUtil.setReservedCharsDisplay((String)resource.get(String.class));
        }
        catch (Exception e) {
            LOG.warning("Reserved character call failed: " + e.getMessage());
        }
    }
}

