/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca;

import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NagiosException;
import com.googlecode.jsendnsca.NagiosPassiveCheckSender;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.PassiveCheckSender;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NonBlockingNagiosPassiveCheckSender
implements PassiveCheckSender {
    private final PassiveCheckSender sender;
    private ExecutorService executor;

    public NonBlockingNagiosPassiveCheckSender(NagiosSettings settings) {
        this(new NagiosPassiveCheckSender(settings));
    }

    NonBlockingNagiosPassiveCheckSender(PassiveCheckSender sender) {
        this.sender = sender;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void send(MessagePayload payload) throws NagiosException, IOException {
        this.executor.execute(new NonBlockingSender(payload));
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    private class NonBlockingSender
    implements Runnable {
        private MessagePayload payload;

        public NonBlockingSender(MessagePayload payload) {
            this.payload = payload;
        }

        public void run() {
            try {
                NonBlockingNagiosPassiveCheckSender.this.sender.send(this.payload);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

