/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public abstract class ActionExecutor {
    public static final String CONF_PREFIX = "oozie.action.";
    public static final String ERROR_OTHER = "OTHER";
    private static boolean initMode = false;
    private static Map<String, Map<Class, ErrorInfo>> ERROR_INFOS = new HashMap<String, Map<Class, ErrorInfo>>();
    public static final int MAX_RETRIES = 3;
    public static final long RETRY_INTERVAL = 60L;
    private String type;
    private int maxRetries;
    private long retryInterval;

    protected ActionExecutor(String type) {
        this(type, 3, 60L);
    }

    protected ActionExecutor(String type, int retryAttempts, long retryInterval) {
        this.type = ParamChecker.notEmpty(type, "type");
        this.maxRetries = retryAttempts;
        this.retryInterval = retryInterval;
    }

    public static void resetInitInfo() {
        if (!initMode) {
            throw new IllegalStateException("Error, action type info locked");
        }
        ERROR_INFOS.clear();
    }

    public static void enableInit() {
        initMode = true;
    }

    public static void disableInit() {
        initMode = false;
    }

    public void initActionType() {
        ERROR_INFOS.put(this.getType(), new LinkedHashMap());
    }

    public String getOozieSystemId() {
        return Services.get().getSystemId();
    }

    public String getOozieRuntimeDir() {
        return Services.get().getRuntimeDir();
    }

    public Configuration getOozieConf() {
        return Services.get().getConf();
    }

    protected void registerError(String exClass, ActionExecutorException.ErrorType errorType, String errorCode) {
        if (!initMode) {
            throw new IllegalStateException("Error, action type info locked");
        }
        try {
            Class<?> klass = Thread.currentThread().getContextClassLoader().loadClass(exClass);
            Map<Class, ErrorInfo> executorErrorInfo = ERROR_INFOS.get(this.getType());
            executorErrorInfo.put(klass, new ErrorInfo(errorType, errorCode));
        }
        catch (ClassNotFoundException ex) {
            XLog.getLog(this.getClass()).warn("Exception [{0}] no in classpath, ActionExecutor [{1}] will handled it as ERROR", exClass, this.getType());
        }
    }

    public String getType() {
        return this.type;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    protected ActionExecutorException convertException(Exception ex) {
        if (ex instanceof ActionExecutorException) {
            return (ActionExecutorException)ex;
        }
        for (Map.Entry<Class, ErrorInfo> errorInfo : ERROR_INFOS.get(this.getType()).entrySet()) {
            if (!errorInfo.getKey().isInstance(ex)) continue;
            return new ActionExecutorException(errorInfo.getValue().errorType, errorInfo.getValue().errorCode, "{0}", ex.getMessage(), ex);
        }
        String errorCode = ex.getClass().getName();
        errorCode = errorCode.substring(errorCode.lastIndexOf(".") + 1);
        return new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, errorCode, "{0}", ex.getMessage(), ex);
    }

    protected String getActionSignal(WorkflowAction.Status status) {
        switch (status) {
            case OK: {
                return "OK";
            }
            case ERROR: 
            case KILLED: {
                return "ERROR";
            }
        }
        throw new IllegalArgumentException("Action status for signal can only be OK or ERROR");
    }

    protected String getActionDirPath(String jobId, WorkflowAction action, String key, boolean temp) {
        String name = jobId + "/" + action.getName() + "--" + key;
        if (temp) {
            name = name + ".temp";
        }
        return this.getOozieSystemId() + "/" + name;
    }

    public Path getActionDir(String jobId, WorkflowAction action, String key, boolean temp) {
        return new Path(this.getActionDirPath(jobId, action, key, temp));
    }

    public abstract void start(Context var1, WorkflowAction var2) throws ActionExecutorException;

    public abstract void end(Context var1, WorkflowAction var2) throws ActionExecutorException;

    public abstract void check(Context var1, WorkflowAction var2) throws ActionExecutorException;

    public abstract void kill(Context var1, WorkflowAction var2) throws ActionExecutorException;

    public abstract boolean isCompleted(String var1);

    public static interface Context {
        public String getCallbackUrl(String var1);

        public Configuration getProtoActionConf();

        public WorkflowJob getWorkflow();

        public ELEvaluator getELEvaluator();

        public void setVar(String var1, String var2);

        public String getVar(String var1);

        public void setStartData(String var1, String var2, String var3);

        public void setExecutionData(String var1, Properties var2);

        public void setEndData(WorkflowAction.Status var1, String var2);

        public boolean isRetry();

        public void setExternalStatus(String var1);

        public String getRecoveryId();

        public Path getActionDir() throws HadoopAccessorException, IOException, URISyntaxException;

        public FileSystem getAppFileSystem() throws HadoopAccessorException, IOException, URISyntaxException;

        public void setErrorInfo(String var1, String var2);
    }

    private static class ErrorInfo {
        ActionExecutorException.ErrorType errorType;
        String errorCode;

        private ErrorInfo(ActionExecutorException.ErrorType errorType, String errorCode) {
            this.errorType = errorType;
            this.errorCode = errorCode;
        }
    }
}

