/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;

public class FsELFunctions {
    private static FileSystem getFileSystem(URI uri) throws HadoopAccessorException {
        WorkflowJobBean workflow = DagELFunctions.getWorkflow();
        String user = workflow.getUser();
        String group = workflow.getGroup();
        return Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, uri, DagELFunctions.getProtoActionConf());
    }

    private static FileStatus getFileStatus(String pathUri) throws Exception {
        Path p;
        URI uri = new URI(pathUri);
        String path = uri.getPath();
        FileSystem fs = FsELFunctions.getFileSystem(uri);
        return fs.exists(p = new Path(path)) ? fs.getFileStatus(p) : null;
    }

    public static boolean fs_exists(String pathUri) throws Exception {
        URI uri = new URI(pathUri);
        String path = uri.getPath();
        FileSystem fs = FsELFunctions.getFileSystem(uri);
        return fs.exists(new Path(path));
    }

    public static boolean fs_isDir(String pathUri) throws Exception {
        boolean isDir = false;
        FileStatus fileStatus = FsELFunctions.getFileStatus(pathUri);
        if (fileStatus != null) {
            isDir = fileStatus.isDir();
        }
        return isDir;
    }

    public static long fs_fileSize(String pathUri) throws Exception {
        long len = -1L;
        FileStatus fileStatus = FsELFunctions.getFileStatus(pathUri);
        if (fileStatus != null) {
            len = fileStatus.getLen();
        }
        return len;
    }

    public static long fs_dirSize(String pathUri) throws Exception {
        URI uri = new URI(pathUri);
        String path = uri.getPath();
        long size = -1L;
        try {
            FileSystem fs = FsELFunctions.getFileSystem(uri);
            Path p = new Path(path);
            if (fs.exists(p) && !fs.isFile(p)) {
                FileStatus[] stati = fs.listStatus(p);
                size = 0L;
                if (stati != null) {
                    for (FileStatus status : stati) {
                        if (status.isDir()) continue;
                        size += status.getLen();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return size;
    }

    public static long fs_blockSize(String pathUri) throws Exception {
        long blockSize = -1L;
        FileStatus fileStatus = FsELFunctions.getFileStatus(pathUri);
        if (fileStatus != null) {
            blockSize = fileStatus.getBlockSize();
        }
        return blockSize;
    }
}

