/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.Date;
import java.util.List;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.ResumeTransitionXCommand;
import org.apache.oozie.command.coord.CoordResumeXCommand;
import org.apache.oozie.executor.jpa.BundleActionUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.BundleActionsGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class BundleJobResumeXCommand
extends ResumeTransitionXCommand {
    private final String bundleId;
    private JPAService jpaService = null;
    private BundleJobBean bundleJob;
    private List<BundleActionBean> bundleActions;

    public BundleJobResumeXCommand(String jobId) {
        super("bundle_resume", "bundle_resume", 1);
        this.bundleId = ParamChecker.notNull(jobId, "BundleId");
    }

    @Override
    public void resumeChildren() throws CommandException {
        try {
            for (BundleActionBean action : this.bundleActions) {
                if (action.getStatus() != Job.Status.SUSPENDED && action.getStatus() != Job.Status.PREPSUSPENDED) continue;
                if (action.getCoordId() != null) {
                    this.queue(new CoordResumeXCommand(action.getCoordId()));
                    this.updateBundleAction(action);
                    this.LOG.debug("Resume bundle action = [{0}], new status = [{1}], pending = [{2}] and queue CoordResumeXCommand for [{3}]", action.getBundleActionId(), action.getStatus(), action.getPending(), action.getCoordId());
                    continue;
                }
                this.updateBundleAction(action);
                this.LOG.debug("Resume bundle action = [{0}], new status = [{1}], pending = [{2}] and coord id is null", action.getBundleActionId(), action.getStatus(), action.getPending());
            }
            this.LOG.debug("Resume bundle actions for the bundle=[{0}]", this.bundleId);
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    private void updateBundleAction(BundleActionBean action) throws CommandException {
        if (action.getStatus() == Job.Status.PREPSUSPENDED) {
            action.setStatus(Job.Status.PREP);
        } else if (action.getStatus() == Job.Status.SUSPENDED) {
            action.setStatus(Job.Status.RUNNING);
        }
        action.incrementAndGetPending();
        action.setLastModifiedTime(new Date());
        try {
            this.jpaService.execute(new BundleActionUpdateJPAExecutor(action));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public void notifyParent() throws CommandException {
    }

    @Override
    public void updateJob() throws CommandException {
        InstrumentUtils.incrJobCounter("bundle_resume", 1, null);
        this.bundleJob.setSuspendedTime(null);
        this.bundleJob.setLastModifiedTime(new Date());
        this.LOG.debug("Resume bundle job id = " + this.bundleId + ", status = " + this.bundleJob.getStatus() + ", pending = " + this.bundleJob.isPending());
        try {
            this.jpaService.execute(new BundleJobUpdateJPAExecutor(this.bundleJob));
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    protected String getEntityKey() {
        return this.bundleId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            this.bundleJob = this.jpaService.execute(new BundleJobGetJPAExecutor(this.bundleId));
            this.bundleActions = this.jpaService.execute(new BundleActionsGetJPAExecutor(this.bundleId));
        }
        catch (Exception Ex) {
            throw new CommandException(ErrorCode.E0604, this.bundleId);
        }
        LogUtils.setLogInfo(this.bundleJob, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.bundleJob.getStatus() != Job.Status.SUSPENDED && this.bundleJob.getStatus() != Job.Status.PREPSUSPENDED) {
            throw new PreconditionException(ErrorCode.E1100, "BundleResumeCommand not Resumed - job not in SUSPENDED/PREPSUSPENDED state " + this.bundleId);
        }
    }

    @Override
    public Job getJob() {
        return this.bundleJob;
    }
}

