/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.List;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.CoordActionsDeleteForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;

public class CoordPurgeXCommand
extends CoordinatorXCommand<Void> {
    private JPAService jpaService = null;
    private final int olderThan;
    private final int limit;
    private List<CoordinatorJobBean> jobList = null;

    public CoordPurgeXCommand(int olderThan, int limit) {
        super("coord_purge", "coord_purge", 0);
        this.olderThan = olderThan;
        this.limit = limit;
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.debug("STARTED Coord-Purge to purge Jobs older than [{0}] days.", this.olderThan);
        int actionDeleted = 0;
        if (this.jobList != null && this.jobList.size() != 0) {
            for (CoordinatorJobBean coord : this.jobList) {
                String jobId = coord.getId();
                try {
                    this.jpaService.execute(new CoordJobDeleteJPAExecutor(jobId));
                    actionDeleted += this.jpaService.execute(new CoordActionsDeleteForPurgeJPAExecutor(jobId)).intValue();
                }
                catch (JPAExecutorException e) {
                    throw new CommandException(e);
                }
            }
            this.LOG.debug("ENDED Coord-Purge deleted jobs :" + this.jobList.size() + " and actions " + actionDeleted);
        } else {
            this.LOG.debug("ENDED Coord-Purge no Coord job to be deleted");
        }
        return null;
    }

    @Override
    protected String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.jobList = this.jpaService.execute(new CoordJobsGetForPurgeJPAExecutor(this.olderThan, this.limit));
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

